/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.navigator;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.ui.navigator.images.PeerImageDescriptor;
import org.eclipse.tcf.te.tcf.ui.navigator.nodes.PeerRedirectorGroupNode;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;

public class LabelProviderDelegate
extends LabelProvider
implements ILabelDecorator {
    public String getText(Object element) {
        if (element instanceof IPeerModel) {
            String label = null;
            final IPeer peer = ((IPeerModel)element).getPeer();
            final String[] peerName = new String[1];
            if (Protocol.isDispatchThread()) {
                peerName[0] = peer.getName();
            } else {
                Protocol.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        peerName[0] = peer.getName();
                    }
                });
            }
            label = peerName[0];
            if (label != null && !"".equals(label.trim())) {
                return label;
            }
        } else if (element instanceof PeerRedirectorGroupNode) {
            return Messages.RemotePeerDiscoveryRootNode_label;
        }
        return "";
    }

    public Image getImage(final Object element) {
        if (element instanceof IPeerModel) {
            final AtomicBoolean isStatic = new AtomicBoolean();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    String value = (String)((IPeerModel)element).getPeer().getAttributes().get("static.transient");
                    isStatic.set(value != null && Boolean.parseBoolean(value.trim()));
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
            return isStatic.get() ? UIPlugin.getImage("PeerObject") : UIPlugin.getImage("PeerObjectDiscovered");
        }
        if (element instanceof PeerRedirectorGroupNode) {
            return UIPlugin.getImage("RemotePeerDiscoverRootNodeObject");
        }
        return super.getImage(element);
    }

    public Image decorateImage(Image image, Object element) {
        Image decoratedImage = null;
        if (image != null && element instanceof IPeerModel) {
            PeerImageDescriptor descriptor = new PeerImageDescriptor(UIPlugin.getDefault().getImageRegistry(), image, (IPeerModel)element);
            decoratedImage = UIPlugin.getSharedImage(descriptor);
        }
        return decoratedImage;
    }

    public String decorateText(String text, final Object element) {
        if (element instanceof IPeerModel) {
            String label = text;
            final StringBuilder builder = new StringBuilder(label != null && !"".equals(label.trim()) ? label.trim() : "<noname>");
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    IPeer peer = ((IPeerModel)element).getPeer();
                    String dnsName = ((IPeerModel)element).getStringProperty("dns.name.transient");
                    LabelProviderDelegate.this.doDecorateText(builder, peer, dnsName);
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
            label = builder.toString();
            if (label != null && !"".equals(label.trim()) && !"<noname>".equals(label.trim())) {
                return label;
            }
        }
        return null;
    }

    void doDecorateText(StringBuilder builder, IPeer peer, String dnsName) {
        Assert.isNotNull((Object)builder);
        Assert.isNotNull((Object)peer);
        Assert.isTrue((boolean)Protocol.isDispatchThread());
        String ip = (String)peer.getAttributes().get("Host");
        String port = (String)peer.getAttributes().get("Port");
        if (ip != null && !"".equals(ip.trim())) {
            builder.append(" [");
            builder.append(dnsName != null && !"".equals(dnsName.trim()) ? dnsName.trim() : ip.trim());
            if (port != null && !"".equals(port.trim()) && !"1534".equals(port.trim())) {
                builder.append(":");
                builder.append(port.trim());
            }
            builder.append("]");
        }
    }
}

