/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.utils;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.tcf.te.runtime.persistence.AbstractGsonMapPersistenceDelegate;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.utils.FileState;

public class URIKeyMapPersistenceDelegate
extends AbstractGsonMapPersistenceDelegate {
    public Class<?> getPersistedClass(Object context) {
        return Map.class;
    }

    protected Map<String, Object> toMap(Object context) throws IOException {
        Map attrs = (Map)context;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (attrs != null) {
            for (Map.Entry entry : attrs.entrySet()) {
                Object value;
                Object object = entry.getValue();
                if (object instanceof URI) {
                    value = "uri:" + object.toString();
                    result.put(((URI)entry.getKey()).toString(), value);
                    continue;
                }
                if (object instanceof IContentType) {
                    value = "contenttype:" + ((IContentType)object).getId();
                    result.put(((URI)entry.getKey()).toString(), value);
                    continue;
                }
                if (object instanceof FileState) {
                    value = this.digest2map((FileState)object);
                    result.put(((URI)entry.getKey()).toString(), value);
                    continue;
                }
                if (object instanceof Map) {
                    Map map = (Map)object;
                    Map<String, Object> valueMap = this.qNames2Map(map);
                    result.put(((URI)entry.getKey()).toString(), valueMap);
                    continue;
                }
                result.put(((URI)entry.getKey()).toString(), object);
            }
        }
        return result;
    }

    private Map<String, Object> qNames2Map(Map<QualifiedName, String> map) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("map.type", "QNames");
        for (Map.Entry<QualifiedName, String> entry : map.entrySet()) {
            result.put(entry.getKey().toString(), entry.getValue());
        }
        return result;
    }

    protected Object fromMap(Map<String, Object> map, Object context) throws IOException {
        if (context == null) {
            context = new HashMap();
        }
        Map result = context;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object value = entry.getValue();
            URI uri = this.toURI(entry.getKey());
            Assert.isNotNull((Object)uri);
            if (value instanceof String) {
                String string = (String)value;
                URI object = null;
                if (string.startsWith("uri:")) {
                    string = string.substring("uri:".length());
                    object = this.toURI(string);
                    Assert.isNotNull((Object)object);
                    result.put(uri, object);
                    continue;
                }
                if (!string.startsWith("contenttype:")) continue;
                string = string.substring("contenttype:".length());
                object = Platform.getContentTypeManager().getContentType(string);
                result.put(uri, object);
                continue;
            }
            if (value instanceof Map) {
                Map vMap = (Map)value;
                if ("QNames".equals(vMap.get("map.type"))) {
                    Map<QualifiedName, String> valueMap = this.toQNameMap((Map)value);
                    result.put(uri, valueMap);
                    continue;
                }
                if (!"Digest".equals(vMap.get("map.type"))) continue;
                FileState digest = this.map2digest((Map)value);
                result.put(uri, digest);
                continue;
            }
            result.put(uri, value);
        }
        return result;
    }

    private FileState map2digest(Map<String, Object> value) {
        byte[] base_digest = this.string2digest((String)value.get("base"));
        byte[] cache_digest = this.string2digest((String)value.get("cache"));
        byte[] target_digest = this.string2digest((String)value.get("target"));
        Number number = (Number)value.get("mtime");
        long mtime = number.longValue();
        return new FileState(mtime, cache_digest, target_digest, base_digest);
    }

    private Map<String, Object> digest2map(FileState digest) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("map.type", "Digest");
        map.put("base", this.digest2string(digest.getBaseDigest()));
        map.put("cache", this.digest2string(digest.getCacheDigest()));
        map.put("target", this.digest2string(digest.getTargetDigest()));
        map.put("mtime", digest.getCacheMTime());
        return map;
    }

    private String digest2string(byte[] digest) {
        if (digest != null && digest.length > 0) {
            StringBuilder buffer = new StringBuilder();
            int i = 0;
            while (i < digest.length) {
                int d = digest[i] & 0xFF;
                String sByte = Integer.toHexString(d);
                while (sByte.length() < 2) {
                    sByte = "0" + sByte;
                }
                buffer.append(sByte.toLowerCase());
                ++i;
            }
            return buffer.toString();
        }
        return "";
    }

    private byte[] string2digest(String string) {
        if (string != null && string.length() > 0) {
            int count = string.length() / 2;
            byte[] digest = new byte[count];
            int i = 0;
            while (i < count) {
                try {
                    String seg = string.substring(2 * i, 2 * (i + 1));
                    int d = Integer.parseInt(seg, 16);
                    digest[i] = (byte)d;
                }
                catch (Exception exception) {}
                ++i;
            }
            return digest;
        }
        return new byte[0];
    }

    private Map<QualifiedName, String> toQNameMap(Map<String, String> strMap) {
        HashMap<QualifiedName, String> result = new HashMap<QualifiedName, String>();
        for (Map.Entry<String, String> entry : strMap.entrySet()) {
            int dot = entry.getKey().lastIndexOf(":");
            String qualifier = null;
            String local = entry.getKey();
            if (dot != -1) {
                qualifier = entry.getKey().substring(0, dot);
                local = entry.getKey().substring(dot + 1);
            }
            QualifiedName name = new QualifiedName(qualifier, local);
            result.put(name, strMap.get(entry.getKey()));
        }
        return result;
    }

    private URI toURI(final String string) {
        final AtomicReference ref = new AtomicReference();
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
            }

            public void run() throws Exception {
                ref.set(new URI(string));
            }
        });
        return (URI)ref.get();
    }
}

