/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.views.editor;

import java.util.EventObject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.te.runtime.events.ChangeEvent;
import org.eclipse.tcf.te.runtime.events.EventManager;
import org.eclipse.tcf.te.runtime.interfaces.IDisposable;
import org.eclipse.tcf.te.runtime.interfaces.events.IEventListener;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.ui.events.AbstractEventListener;
import org.eclipse.tcf.te.ui.views.activator.UIPlugin;
import org.eclipse.tcf.te.ui.views.editor.Editor;
import org.eclipse.ui.forms.editor.IFormPage;

public final class EditorEventListener
extends AbstractEventListener
implements IDisposable {
    private final Editor editor;

    public EditorEventListener(Editor editor) {
        Object node;
        Assert.isNotNull((Object)((Object)editor));
        this.editor = editor;
        Object object = node = editor.getEditorInput() != null ? editor.getEditorInput().getAdapter(Object.class) : null;
        if (node instanceof IPropertiesContainer) {
            EventManager.getInstance().addEventListener((IEventListener)this, ChangeEvent.class, node);
        }
    }

    public void dispose() {
        EventManager.getInstance().removeEventListener((IEventListener)this);
    }

    public void eventFired(EventObject event) {
        Object node;
        if (!(event instanceof ChangeEvent)) {
            return;
        }
        ChangeEvent changeEvent = (ChangeEvent)event;
        if (UIPlugin.getTraceHandler().isSlotEnabled(0, "trace/editor/eventListener")) {
            UIPlugin.getTraceHandler().trace("Entered eventFired(...). eventId='" + changeEvent.getEventId() + "'" + ", oldValue='" + changeEvent.getOldValue() + "'" + ", newValue='" + changeEvent.getNewValue() + "'", 0, "trace/editor/eventListener", 1, (Object)this);
        }
        Object source = event.getSource();
        Object object = node = this.editor.getEditorInput() != null ? this.editor.getEditorInput().getAdapter(Object.class) : null;
        if (node == null || !node.equals(source)) {
            if (UIPlugin.getTraceHandler().isSlotEnabled(0, "trace/editor/eventListener")) {
                UIPlugin.getTraceHandler().trace("Dropping out of eventFired(...). Event source does not match editor input.", 0, "trace/editor/eventListener", 2, (Object)this);
            }
            return;
        }
        if ("editor.refreshTab".equals(changeEvent.getEventId())) {
            this.editor.updatePageList();
        } else {
            Object page = this.editor.getSelectedPage();
            if (page instanceof IFormPage) {
                ((IFormPage)page).setActive(((IFormPage)page).isActive());
            }
            this.editor.updatePartName();
        }
    }
}

