/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.views.extensions;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.te.runtime.extensions.AbstractExtensionPointManager;
import org.eclipse.tcf.te.runtime.extensions.ExecutableExtensionProxy;
import org.eclipse.tcf.te.ui.views.activator.UIPlugin;
import org.eclipse.tcf.te.ui.views.extensions.EditorPageBinding;
import org.eclipse.ui.IEditorInput;

public class EditorPageBindingExtensionPointManager
extends AbstractExtensionPointManager<EditorPageBinding> {
    EditorPageBindingExtensionPointManager() {
    }

    public static EditorPageBindingExtensionPointManager getInstance() {
        return LazyInstance.instance;
    }

    protected String getExtensionPointId() {
        return "org.eclipse.tcf.te.ui.views.editorPageBindings";
    }

    protected String getConfigurationElementName() {
        return "editorPageBinding";
    }

    protected ExecutableExtensionProxy<EditorPageBinding> doCreateExtensionProxy(IConfigurationElement element) throws CoreException {
        return new ExecutableExtensionProxy<EditorPageBinding>(element){

            public EditorPageBinding newInstance() {
                EditorPageBinding instance = new EditorPageBinding();
                try {
                    instance.setInitializationData(this.getConfigurationElement(), null, null);
                }
                catch (CoreException e) {
                    Status status = new Status(4, UIPlugin.getUniqueIdentifier(), e.getLocalizedMessage(), (Throwable)e);
                    UIPlugin.getDefault().getLog().log((IStatus)status);
                }
                return instance;
            }
        };
    }

    public EditorPageBinding[] getApplicableEditorPageBindings(IEditorInput input) {
        ArrayList<EditorPageBinding> applicable = new ArrayList<EditorPageBinding>();
        EditorPageBinding[] editorPageBindingArray = this.getEditorPageBindings();
        int n = editorPageBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean isApplicable;
            EditorPageBinding binding = editorPageBindingArray[n2];
            Expression enablement = binding.getEnablement();
            boolean bl = isApplicable = enablement == null;
            if (enablement != null && input != null) {
                Object node = input.getAdapter(Object.class);
                if (node != null) {
                    EvaluationContext context = new EvaluationContext(null, node);
                    context.addVariable("activeEditorInput", node);
                    context.setAllowPluginActivation(true);
                    try {
                        isApplicable = enablement.evaluate((IEvaluationContext)context).equals(EvaluationResult.TRUE);
                    }
                    catch (CoreException e) {
                        Status status = new Status(4, UIPlugin.getUniqueIdentifier(), e.getLocalizedMessage(), (Throwable)e);
                        UIPlugin.getDefault().getLog().log((IStatus)status);
                    }
                } else {
                    isApplicable = false;
                }
            }
            if (isApplicable) {
                applicable.add(binding);
            }
            ++n2;
        }
        return applicable.toArray(new EditorPageBinding[applicable.size()]);
    }

    public EditorPageBinding[] getEditorPageBindings() {
        ArrayList<EditorPageBinding> contributions = new ArrayList<EditorPageBinding>();
        Collection editorPageBindings = this.getExtensions().values();
        for (ExecutableExtensionProxy editorPageBinding : editorPageBindings) {
            EditorPageBinding instance = (EditorPageBinding)((Object)editorPageBinding.getInstance());
            if (instance == null || contributions.contains((Object)instance)) continue;
            contributions.add(instance);
        }
        return contributions.toArray(new EditorPageBinding[contributions.size()]);
    }

    public EditorPageBinding getEditorPageBinding(String id) {
        EditorPageBinding contribution = null;
        if (this.getExtensions().containsKey(id)) {
            ExecutableExtensionProxy proxy = (ExecutableExtensionProxy)this.getExtensions().get(id);
            contribution = (EditorPageBinding)((Object)proxy.getInstance());
        }
        return contribution;
    }

    private static class LazyInstance {
        public static EditorPageBindingExtensionPointManager instance = new EditorPageBindingExtensionPointManager();

        private LazyInstance() {
        }
    }
}

