/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.commands;

import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.internal.debug.ui.commands.AbstractActionDelegate;
import org.eclipse.tcf.internal.debug.ui.commands.SignalsDialog;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExpression;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeLaunch;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeModule;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeStackFrame;

public class SignalsCommand
extends AbstractActionDelegate {
    private static boolean isValidNode(TCFNode n) {
        if (n instanceof TCFNodeLaunch) {
            return true;
        }
        if (n instanceof TCFNodeExecContext) {
            return true;
        }
        if (n instanceof TCFNodeStackFrame) {
            return true;
        }
        if (n instanceof TCFNodeExpression) {
            return true;
        }
        return n instanceof TCFNodeModule;
    }

    protected void selectionChanged() {
        TCFNode n = this.getSelectedNode();
        this.getAction().setEnabled(SignalsCommand.isValidNode(n));
    }

    protected void run() {
        TCFNode n = this.getSelectedNode();
        if (SignalsCommand.isValidNode(n)) {
            Shell shell = this.getWindow().getShell();
            try {
                new SignalsDialog(shell, n).open();
            }
            catch (Throwable x) {
                MessageBox mb = new MessageBox(shell, 33);
                mb.setText("Cannot open Signals dialog");
                mb.setMessage(TCFModel.getErrorMessage(x, true));
                mb.open();
            }
        }
    }
}

