/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.model;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public class TCFNumberFormat {
    public static String isValidHexNumber(String s) {
        int l = s.length();
        if (l == 0) {
            return "Need at least one digit";
        }
        int i = 0;
        while (i < l) {
            char ch = s.charAt(i);
            if (!(ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'F' || ch >= 'a' && ch <= 'f')) {
                return "Hex digit expected";
            }
            ++i;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static String isValidDecNumber(boolean fp, String s) {
        i = 0;
        l = s.length();
        if (l == 0) {
            return "Need at least one digit";
        }
        if ((ch = s.charAt(i++)) == '-' || ch == '+') {
            if (i >= l) {
                return "Need at least one digit";
            }
            ch = s.charAt(i++);
        }
        if (!fp) ** GOTO lbl18
        n = s.substring(i - 1);
        if (n.equals("NaN")) {
            return null;
        }
        if (!n.equals("Infinity")) ** GOTO lbl18
        return null;
lbl-1000:
        // 1 sources

        {
            if (i >= l) {
                return null;
            }
            ch = s.charAt(i++);
lbl18:
            // 3 sources

            ** while (ch >= '0' && ch <= '9')
        }
lbl19:
        // 1 sources

        if (fp) {
            if (ch == '.') {
                if (i >= l) {
                    return null;
                }
                ch = s.charAt(i++);
                while (ch >= '0' && ch <= '9') {
                    if (i >= l) {
                        return null;
                    }
                    ch = s.charAt(i++);
                }
            }
            if (ch == 'e' || ch == 'E') {
                if (i >= l) {
                    return "Invalid exponent: need at least one digit";
                }
                if ((ch = s.charAt(i++)) == '-' || ch == '+') {
                    if (i >= l) {
                        return "Invalid exponent: need at least one digit";
                    }
                    ch = s.charAt(i++);
                }
                while (ch >= '0' && ch <= '9') {
                    if (i >= l) {
                        return null;
                    }
                    ch = s.charAt(i++);
                }
                return "Invalid exponent: decimal digit expected";
            }
        }
        return "Decimal digit expected";
    }

    public static byte[] toByteArray(String s, int radix, boolean fp, int size, boolean signed, boolean big_endian) throws Exception {
        int i;
        byte[] bf = null;
        if (!fp) {
            bf = new BigInteger(s, radix).toByteArray();
        } else if (size == 4) {
            int n = Float.floatToIntBits(Float.parseFloat(s));
            bf = new byte[size];
            i = 0;
            while (i < size) {
                bf[i] = (byte)(n >> (size - 1 - i) * 8 & 0xFF);
                ++i;
            }
        } else if (size == 8) {
            long n = Double.doubleToLongBits(Double.parseDouble(s));
            bf = new byte[size];
            int i2 = 0;
            while (i2 < size) {
                bf[i2] = (byte)(n >> (size - 1 - i2) * 8 & 0xFFL);
                ++i2;
            }
        } else {
            throw new Exception("Unsupported floating point format");
        }
        byte[] rs = new byte[size];
        if (signed && rs.length > bf.length && (bf[0] & 0x80) != 0) {
            i = 0;
            while (i < rs.length) {
                rs[i] = -1;
                ++i;
            }
        }
        i = 0;
        while (i < bf.length) {
            int j;
            byte b = bf[bf.length - i - 1];
            int n = j = big_endian ? rs.length - i - 1 : i;
            if (j >= 0 && j < rs.length) {
                rs[j] = b;
            }
            ++i;
        }
        return rs;
    }

    public static String toFPString(byte[] data, boolean big_endian) {
        return TCFNumberFormat.toFPString(data, 0, data.length, big_endian);
    }

    public static String toFPString(byte[] data, int offs, int size, boolean big_endian) {
        assert (offs + size <= data.length);
        byte[] arr = new byte[size];
        if (big_endian) {
            System.arraycopy(data, offs, arr, 0, size);
        } else {
            int i = 0;
            while (i < size) {
                arr[arr.length - i - 1] = data[offs + i];
                ++i;
            }
        }
        boolean neg = (arr[0] & 0x80) != 0;
        arr[0] = (byte)(arr[0] & 0x7F);
        int precision = 0;
        int exponent = 0;
        boolean nan = false;
        switch (size) {
            case 2: {
                precision = 3;
                exponent = (arr[0] & 0x7C) >> 2;
                nan = exponent == 31;
                arr[0] = (byte)(arr[0] & 3);
                if (exponent == 0) {
                    exponent = 1;
                } else {
                    arr[0] = (byte)(arr[0] | 4);
                }
                exponent -= 10;
                exponent -= 15;
                break;
            }
            case 4: {
                precision = 7;
                exponent = (arr[0] & 0x7F) << 1 | (arr[1] & 0x80) >> 7;
                nan = exponent == 255;
                arr[0] = 0;
                arr[1] = (byte)(arr[1] & 0x7F);
                if (exponent == 0) {
                    exponent = 1;
                } else {
                    arr[1] = (byte)(arr[1] | 0x80);
                }
                exponent -= 23;
                exponent -= 127;
                break;
            }
            case 8: {
                precision = 16;
                exponent = (arr[0] & 0x7F) << 4 | (arr[1] & 0xF0) >> 4;
                nan = exponent == 2047;
                arr[0] = 0;
                arr[1] = (byte)(arr[1] & 0xF);
                if (exponent == 0) {
                    exponent = 1;
                } else {
                    arr[1] = (byte)(arr[1] | 0x10);
                }
                exponent -= 52;
                exponent -= 1023;
                break;
            }
            case 10: 
            case 16: {
                precision = 34;
                exponent = (arr[0] & 0x7F) << 8 | arr[1] & 0xFF;
                nan = exponent == Short.MAX_VALUE;
                arr[1] = 0;
                arr[0] = 0;
                if (size == 10) {
                    exponent -= 63;
                } else {
                    if (exponent == 0) {
                        exponent = 1;
                    } else {
                        arr[1] = 1;
                    }
                    exponent -= 112;
                }
                exponent -= 16383;
                break;
            }
            default: {
                return null;
            }
        }
        if (nan) {
            int i = 0;
            while (i < arr.length) {
                int n = arr[i] & 0xFF;
                if (size == 10 && i == 2) {
                    n &= 0x7F;
                }
                if (n != 0) {
                    return neg ? "-NaN" : "+NaN";
                }
                ++i;
            }
            return neg ? "-Infinity" : "+Infinity";
        }
        BigDecimal a = new BigDecimal(new BigInteger(arr), 0);
        if (a.signum() != 0 && exponent != 0) {
            BigDecimal p = new BigDecimal(BigInteger.valueOf(2L), 0);
            if (exponent > 0) {
                a = a.multiply(p.pow(exponent));
            } else {
                BigDecimal b = p.pow(-exponent);
                a = a.divide(b, b.precision(), RoundingMode.HALF_DOWN);
            }
            if (precision != 0 && a.precision() > precision) {
                int scale = a.scale() - a.precision() + precision;
                a = a.setScale(scale, RoundingMode.HALF_DOWN);
            }
        }
        String s = a.toString();
        if (neg) {
            s = "-" + s;
        }
        return s;
    }

    public static BigInteger toBigInteger(byte[] data, boolean big_endian, boolean sign_extension) {
        return TCFNumberFormat.toBigInteger(data, 0, data.length, big_endian, sign_extension);
    }

    public static BigInteger toBigInteger(byte[] data, int offs, int size, boolean big_endian, boolean sign_extension) {
        assert (offs + size <= data.length);
        byte[] temp = null;
        if (sign_extension) {
            temp = new byte[size];
        } else {
            temp = new byte[size + 1];
            temp[0] = 0;
        }
        if (big_endian) {
            System.arraycopy(data, offs, temp, sign_extension ? 0 : 1, size);
        } else {
            int i = 0;
            while (i < size) {
                temp[temp.length - i - 1] = data[i + offs];
                ++i;
            }
        }
        return new BigInteger(temp);
    }
}

