/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.stepper.extensions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.te.runtime.extensions.ExecutableExtension;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.stepper.StepperAttributeUtil;
import org.eclipse.tcf.te.runtime.stepper.activator.CoreBundleActivator;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IExtendedStep;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IFullQualifiedId;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepContext;
import org.eclipse.tcf.te.runtime.stepper.nls.Messages;

public abstract class AbstractStep
extends ExecutableExtension
implements IExtendedStep {
    private final List<String> dependencies = new ArrayList<String>();
    public static final String SUFFIX_DELAYED_STATUS = "delayedStatus";
    public static final String SUFFIX_EVENT_LISTENER = "eventListener";
    public static final String SUFFIX_OPERATIONAL = "operational";

    @Override
    public boolean isSingleton() {
        return false;
    }

    public void doSetInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        IConfigurationElement[] requires;
        super.doSetInitializationData(config, propertyName, data);
        this.dependencies.clear();
        IConfigurationElement[] iConfigurationElementArray = requires = config.getChildren("requires");
        int n = requires.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement require = iConfigurationElementArray[n2];
            String value = require.getAttribute("id");
            if (value == null || value.trim().length() == 0) {
                throw new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), 0, NLS.bind((String)Messages.AbstractStep_error_missingRequiredAttribute, (Object)"dependency id (requires)", (Object)this.getLabel()), null));
            }
            if (!this.dependencies.contains(value.trim())) {
                this.dependencies.add(value.trim());
            }
            ++n2;
        }
    }

    @Override
    public void initializeFrom(IStepContext context, IPropertiesContainer data, IFullQualifiedId fullQualifiedId, IProgressMonitor monitor) {
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)data);
        Assert.isNotNull((Object)fullQualifiedId);
        Assert.isNotNull((Object)monitor);
        StepperAttributeUtil.setProperty(SUFFIX_DELAYED_STATUS, fullQualifiedId, data, false);
        StepperAttributeUtil.setProperty(SUFFIX_OPERATIONAL, fullQualifiedId, data, true);
    }

    @Override
    public void cleanup(IStepContext context, IPropertiesContainer data, IFullQualifiedId fullQualifiedId, IProgressMonitor monitor) {
        StepperAttributeUtil.setProperty(SUFFIX_DELAYED_STATUS, fullQualifiedId, data, false);
        StepperAttributeUtil.setProperty(SUFFIX_OPERATIONAL, fullQualifiedId, data, false);
    }

    @Override
    public void rollback(IStepContext context, IPropertiesContainer data, IStatus status, IFullQualifiedId fullQualifiedId, IProgressMonitor monitor, ICallback callback) {
        if (callback != null) {
            callback.done((Object)this, Status.OK_STATUS);
        }
    }

    @Override
    public int getTotalWork(IStepContext context, IPropertiesContainer data) {
        return 10;
    }

    @Override
    public String[] getDependencies() {
        return this.dependencies.toArray(new String[this.dependencies.size()]);
    }

    public final void callback(IPropertiesContainer stepData, IFullQualifiedId fullQualifiedId, ICallback callback, IStatus status, Object data) {
        Assert.isNotNull((Object)stepData);
        Assert.isNotNull((Object)fullQualifiedId);
        Assert.isNotNull((Object)callback);
        Assert.isNotNull((Object)status);
        IStatus delayedStatus = (IStatus)StepperAttributeUtil.getProperty(SUFFIX_DELAYED_STATUS, fullQualifiedId, stepData);
        if (status.getSeverity() != 4 && status.getSeverity() != 8 && delayedStatus != null) {
            if (status.getSeverity() == 0) {
                status = delayedStatus;
            } else {
                IStatus[] iStatusArray;
                if (delayedStatus instanceof MultiStatus) {
                    iStatusArray = ((MultiStatus)delayedStatus).getChildren();
                } else {
                    IStatus[] iStatusArray2 = new IStatus[1];
                    iStatusArray = iStatusArray2;
                    iStatusArray2[0] = delayedStatus;
                }
                IStatus[] delayedStati = iStatusArray;
                if (delayedStati.length > 0) {
                    if (!(status instanceof MultiStatus)) {
                        status = new MultiStatus(CoreBundleActivator.getUniqueIdentifier(), 0, NLS.bind((String)Messages.AbstractStep_warning_stepFinishedWithWarnings, (Object)this.getLabel()), null);
                    }
                    Assert.isTrue((boolean)(status instanceof MultiStatus));
                    IStatus[] iStatusArray3 = delayedStati;
                    int n = delayedStati.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IStatus delayed = iStatusArray3[n2];
                        ((MultiStatus)status).merge(delayed);
                        ++n2;
                    }
                }
            }
        }
        callback.setProperty("data", data);
        callback.done((Object)this, status);
    }

    protected void delayStatus(IPropertiesContainer data, IFullQualifiedId fullQualifiedId, IStatus status) {
        Assert.isNotNull((Object)status);
        Assert.isTrue((status.getSeverity() == 2 || status.getSeverity() == 1 ? 1 : 0) != 0);
        IStatus delayedStatus = (IStatus)StepperAttributeUtil.getProperty(SUFFIX_DELAYED_STATUS, fullQualifiedId, data);
        if (delayedStatus == null) {
            StepperAttributeUtil.setProperty(SUFFIX_DELAYED_STATUS, fullQualifiedId, data, status);
        } else if (delayedStatus instanceof MultiStatus) {
            ((MultiStatus)delayedStatus).merge(status);
        } else {
            MultiStatus multiStatus = new MultiStatus(CoreBundleActivator.getUniqueIdentifier(), 0, new IStatus[]{delayedStatus, status}, "", null);
            StepperAttributeUtil.setProperty(SUFFIX_DELAYED_STATUS, fullQualifiedId, data, multiStatus);
        }
    }
}

