/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.launch.core.services;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.tcf.internal.debug.model.TCFLaunch;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.concurrent.util.ExecutorsUtil;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.services.AbstractService;
import org.eclipse.tcf.te.runtime.services.interfaces.IDebugService;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;

public class DebugService
extends AbstractService
implements IDebugService {
    public void attach(Object context, final IPropertiesContainer data, final ICallback callback) {
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)data);
        Assert.isNotNull((Object)callback);
        IPeer peer = null;
        if (context instanceof IPeerModel) {
            peer = ((IPeerModel)context).getPeer();
        } else if (context instanceof IPeer) {
            peer = (IPeer)context;
        }
        if (peer != null) {
            if (!Protocol.isDispatchThread()) {
                this.attachPeer(peer, data, callback);
            } else {
                final IPeer finPeer = peer;
                ExecutorsUtil.execute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        DebugService.this.attachPeer(finPeer, data, callback);
                    }
                });
            }
        } else {
            callback.done((Object)this, Status.OK_STATUS);
        }
    }

    protected void attachPeer(IPeer peer, IPropertiesContainer data, final ICallback callback) {
        Assert.isNotNull((Object)peer);
        Assert.isNotNull((Object)data);
        Assert.isNotNull((Object)callback);
        ILaunchConfiguration lc = null;
        ILaunch l = null;
        ILaunchConfiguration[] configs = this.findExistingConfigs(peer);
        if (configs.length > 0) {
            ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
            ILaunchConfiguration[] iLaunchConfigurationArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                ILaunch[] iLaunchArray = launches;
                int n3 = launches.length;
                int n4 = 0;
                while (n4 < n3) {
                    ILaunch launch = iLaunchArray[n4];
                    if (config.equals(launch.getLaunchConfiguration())) {
                        lc = config;
                        l = launch;
                        break;
                    }
                    ++n4;
                }
                if (lc != null) break;
                ++n2;
            }
            if (lc == null) {
                lc = configs[0];
            }
        } else {
            lc = this.createNewConfig(peer);
        }
        if (lc != null && l == null) {
            try {
                final TCFLaunch.LaunchListener listener = new TCFLaunch.LaunchListener(){

                    public void onProcessStreamError(TCFLaunch launch, String process_id, int stream_id, Exception error, int lost_size) {
                    }

                    public void onProcessOutput(TCFLaunch launch, String process_id, int stream_id, byte[] data) {
                    }

                    public void onDisconnected(TCFLaunch launch) {
                    }

                    public void onCreated(TCFLaunch launch) {
                    }

                    public void onConnected(TCFLaunch launch) {
                        ILaunch l = (ILaunch)callback.getProperty("launch");
                        if (launch == l) {
                            TCFLaunch.removeListener((TCFLaunch.LaunchListener)this);
                            callback.done((Object)DebugService.this, Status.OK_STATUS);
                        }
                    }
                };
                if (Protocol.isDispatchThread()) {
                    TCFLaunch.addListener((TCFLaunch.LaunchListener)listener);
                } else {
                    Protocol.invokeAndWait((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            TCFLaunch.addListener((TCFLaunch.LaunchListener)listener);
                        }
                    });
                }
                l = lc.launch("debug", (IProgressMonitor)new NullProgressMonitor(), false, true);
                callback.setProperty("launch", (Object)l);
            }
            catch (CoreException e) {
                callback.done((Object)this, e.getStatus());
            }
        } else {
            callback.setProperty("launch", l);
            callback.done((Object)this, Status.OK_STATUS);
        }
    }

    protected ILaunchConfiguration createNewConfig(final IPeer peer) {
        ILaunchConfiguration lc;
        block5: {
            Assert.isNotNull((Object)peer);
            lc = null;
            final AtomicReference peerId = new AtomicReference();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    peerId.set(peer.getID());
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
            ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType lct = lm.getLaunchConfigurationType("org.eclipse.tcf.debug.LaunchConfigurationType");
            if (lct != null) {
                try {
                    String name = lm.generateLaunchConfigurationName((String)peerId.get());
                    ILaunchConfigurationWorkingCopy wc = lct.newInstance(null, name);
                    wc.setAttribute("org.eclipse.tcf.debug.PeerID", (String)peerId.get());
                    wc.setAttribute("org.eclipse.tcf.debug.StopAtMain", true);
                    wc.setAttribute("org.eclipse.tcf.debug.DisconnectOnCtxExit", true);
                    wc.setAttribute("org.eclipse.tcf.debug.RunLocalAgent", false);
                    wc.setAttribute("org.eclipse.tcf.debug.UseLocalAgent", false);
                    lc = wc.doSave();
                }
                catch (CoreException e) {
                    if (!Platform.inDebugMode()) break block5;
                    e.printStackTrace();
                }
            }
        }
        return lc;
    }

    protected ILaunchConfiguration[] findExistingConfigs(final IPeer peer) {
        ArrayList<ILaunchConfiguration> configs;
        block7: {
            Assert.isNotNull((Object)peer);
            configs = new ArrayList<ILaunchConfiguration>();
            final AtomicReference peerId = new AtomicReference();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    peerId.set(peer.getID());
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
            ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType lct = lm.getLaunchConfigurationType("org.eclipse.tcf.debug.LaunchConfigurationType");
            if (lct != null) {
                try {
                    ILaunchConfiguration[] candidates;
                    ILaunchConfiguration[] iLaunchConfigurationArray = candidates = lm.getLaunchConfigurations(lct);
                    int n = candidates.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ILaunchConfiguration candidate = iLaunchConfigurationArray[n2];
                        String lcPeerId = candidate.getAttribute("org.eclipse.tcf.debug.PeerID", null);
                        if (lcPeerId != null && lcPeerId.equals(peerId.get())) {
                            configs.add(candidate);
                        }
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    if (!Platform.inDebugMode()) break block7;
                    e.printStackTrace();
                }
            }
        }
        return configs.toArray(new ILaunchConfiguration[configs.size()]);
    }
}

