/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.ssh.types;

import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.ui.terminals.internal.SettingsStore;
import org.eclipse.tcf.te.ui.terminals.types.AbstractConnectorType;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalConnectorExtension;
import org.eclipse.tm.internal.terminal.ssh.SshSettings;

public class SshConnectorType
extends AbstractConnectorType {
    public ITerminalConnector createTerminalConnector(IPropertiesContainer properties) {
        Assert.isNotNull((Object)properties);
        String connectorId = properties.getStringProperty("tm.terminal.connector.id");
        String host = properties.getStringProperty("ip.host");
        String port = properties.getStringProperty("ip.port");
        String timeout = properties.getStringProperty("timeout");
        String keepAlive = properties.getStringProperty("ssh.keep_alive");
        String password = properties.getStringProperty("ssh.password");
        String user = properties.getStringProperty("ssh.user");
        int portOffset = 0;
        if (properties.getProperty("ip.port.offset") != null && (portOffset = properties.getIntProperty("ip.port.offset")) < 0) {
            portOffset = 0;
        }
        return host != null && port != null ? this.createSshConnector(connectorId, new String[]{host, port, timeout, keepAlive, password, user}, portOffset) : null;
    }

    protected ITerminalConnector createSshConnector(String connectorId, String[] attributes, int portOffset) {
        Assert.isNotNull((Object)attributes);
        Assert.isTrue((attributes.length == 6 ? 1 : 0) != 0);
        if (connectorId == null) {
            connectorId = "org.eclipse.tm.internal.terminal.ssh.SshConnector";
        }
        String serverName = attributes[0];
        String serverPort = Integer.toString(Integer.decode(attributes[1]) + portOffset);
        String timeout = attributes[2];
        String keepAlive = attributes[3];
        String password = attributes[4];
        String user = attributes[5];
        SettingsStore store = new SettingsStore();
        SshSettings sshSettings = new SshSettings();
        sshSettings.setHost(serverName);
        sshSettings.setPort(serverPort);
        sshSettings.setTimeout(timeout);
        sshSettings.setKeepalive(keepAlive);
        sshSettings.setPassword(password);
        sshSettings.setUser(user);
        sshSettings.save((ISettingsStore)store);
        store.put("Password", password);
        ITerminalConnector connector = TerminalConnectorExtension.makeTerminalConnector((String)connectorId);
        if (connector != null) {
            connector.makeSettingsPage();
            connector.load((ISettingsStore)store);
        }
        return connector;
    }
}

