/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.tests;

import java.util.LinkedList;
import org.eclipse.tcf.internal.debug.tests.ITCFTest;
import org.eclipse.tcf.internal.debug.tests.TCFTestSuite;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IErrorReport;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IDiagnostics;

class TestEcho
implements ITCFTest,
IDiagnostics.DoneEcho {
    private final TCFTestSuite test_suite;
    private final IDiagnostics diag;
    private final LinkedList<String> msgs = new LinkedList();
    private int count = 0;
    private long start_time;

    TestEcho(TCFTestSuite test_suite, IChannel channel) {
        this.test_suite = test_suite;
        this.diag = (IDiagnostics)channel.getRemoteService(IDiagnostics.class);
    }

    public void start() {
        if (this.diag == null) {
            this.test_suite.done(this, null);
        } else {
            this.diag.not_implemented_command(new IDiagnostics.DoneNotImplementedCommand(){

                public void doneNotImplementedCommand(IToken token, Throwable error) {
                    if (!(error instanceof IErrorReport)) {
                        Exception x = new Exception("Invalid responce to unimplemented command", error);
                        TestEcho.this.test_suite.done(TestEcho.this, x);
                        return;
                    }
                    if (((IErrorReport)error).getErrorCode() != 25) {
                        TestEcho.this.test_suite.done(TestEcho.this, new Exception("Invalid error code in responce to unimplemented command"));
                        return;
                    }
                    TestEcho.this.start_time = System.currentTimeMillis();
                    int i = 0;
                    while (i < 32) {
                        TestEcho.this.sendMessage();
                        ++i;
                    }
                }
            });
        }
    }

    private void sendMessage() {
        StringBuffer buf = new StringBuffer();
        buf.append(Integer.toHexString(this.count));
        int i = 0;
        while (i < 64) {
            buf.append('-');
            buf.append((char)(1024 * i + this.count));
            ++i;
        }
        String s = buf.toString();
        this.msgs.add(s);
        this.diag.echo(s, (IDiagnostics.DoneEcho)this);
        ++this.count;
    }

    public void doneEcho(IToken token, Throwable error, String b) {
        String s = this.msgs.removeFirst();
        if (!this.test_suite.isActive(this)) {
            return;
        }
        if (error != null) {
            this.test_suite.done(this, error);
        } else if (!s.equals(b)) {
            this.test_suite.done(this, new Exception("Echo test failed: " + s + " != " + b));
        } else if (this.count < 1024) {
            this.sendMessage();
            if (this.count % 16 == 0 && System.currentTimeMillis() - this.start_time >= 4000L) {
                this.count = 1024;
            }
        } else if (this.msgs.isEmpty()) {
            this.test_suite.done(this, null);
        }
    }

    public boolean canResume(String id) {
        return true;
    }
}

