/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.tests;

import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.eclipse.tcf.internal.debug.tests.ITCFTest;
import org.eclipse.tcf.internal.debug.tests.RunControl;
import org.eclipse.tcf.internal.debug.tests.TCFTestSuite;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IErrorReport;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IBreakpoints;
import org.eclipse.tcf.services.IDiagnostics;
import org.eclipse.tcf.services.IExpressions;
import org.eclipse.tcf.services.IRunControl;
import org.eclipse.tcf.services.IStackTrace;
import org.eclipse.tcf.services.ISymbols;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TestExpressions
implements ITCFTest,
IRunControl.RunControlListener,
IExpressions.ExpressionsListener,
IBreakpoints.BreakpointsListener {
    private final TCFTestSuite test_suite;
    private final RunControl test_rc;
    private final IDiagnostics diag;
    private final IExpressions expr;
    private final ISymbols syms;
    private final IStackTrace stk;
    private final IRunControl rc;
    private final IBreakpoints bp;
    private final Random rnd = new Random();
    private String test_id;
    private String bp_id;
    private boolean bp_ok;
    private IDiagnostics.ISymbol sym_func3;
    private String test_ctx_id;
    private String process_id;
    private String thread_id;
    private boolean run_to_bp_done;
    private boolean loc_info_done;
    private boolean no_cpp;
    private boolean test_done;
    private boolean cancel_test_sent;
    private IRunControl.RunControlContext test_ctx;
    private IRunControl.RunControlContext thread_ctx;
    private String suspended_pc;
    private boolean waiting_suspend;
    private String[] stack_trace;
    private IStackTrace.StackTraceContext[] stack_frames;
    private String[] local_var_expr_ids;
    private final Map<String, String> global_var_ids = new HashMap<String, String>();
    private final Map<String, String> local_var_ids = new HashMap<String, String>();
    private final Map<String, SymbolLocation> global_var_location = new HashMap<String, SymbolLocation>();
    private final Map<String, SymbolLocation> local_var_location = new HashMap<String, SymbolLocation>();
    private final Map<String, IExpressions.Expression> expr_ctx = new HashMap<String, IExpressions.Expression>();
    private final Map<String, IExpressions.Value> expr_val = new HashMap<String, IExpressions.Value>();
    private final Map<String, ISymbols.Symbol> expr_sym = new HashMap<String, ISymbols.Symbol>();
    private final Map<String, String[]> expr_chld = new HashMap<String, String[]>();
    private final Set<String> expr_to_dispose = new HashSet<String>();
    private int timer = 0;
    private static String[] global_var_names = new String[]{"tcf_test_char", "tcf_test_short", "tcf_test_long", "tcf_cpp_test_bool"};
    private static String[] test_expressions = new String[]{"func2_local1", "func2_local2", "func2_local3", "func2_local1 == func2_local1", "func2_local1 != func2_local2", "1.34 == 1.34", "1.34 != 1.35", "1 ? 1 : 0", "!func2_local1 ? 0 : 1", "(0 || 0) == 0", "(0 || func2_local1) == 1", "(func2_local1 || 0) == 1", "(func2_local1 || func2_local1) == 1", "(0 && 0) == 0", "(0 && func2_local1) == 0", "(func2_local1 && 0) == 0", "(func2_local1 && func2_local1) == 1", "(func2_local1 | func2_local2) == 3", "(func2_local1 & func2_local2) == 0", "(func2_local1 ^ func2_local2) == 3", "(func2_local1 < func2_local2)", "(func2_local1 <= func2_local2)", "!(func2_local1 > func2_local2)", "!(func2_local1 >= func2_local2)", "(func2_local1 < 1.1)", "(func2_local1 <= 1.1)", "!(func2_local1 > 1.1)", "!(func2_local1 >= 1.1)", "(func2_local2 << 2) == 8", "(func2_local2 >> 1) == 1", "+func2_local2 == 2", "-func2_local2 == -2", "(short)(int)(long)((char *)func2_local2 + 1) == 3", "((func2_local1 + func2_local2) * 2 - 2) / 2 == 2", "func2_local3.f_struct->f_struct->f_struct == &func2_local3", "(char *)func2_local3.f_struct", "(char[4])func2_local3.f_struct", "&((test_struct *)0)->f_float", "&((struct test_struct *)0)->f_float", "tcf_test_func3", "&tcf_test_func3", "tcf_test_array + 10", "*(tcf_test_array + 10) | 1", "&*(char *)(int *)0 == 0", "(bool)0 == false", "(bool)1 == true", "sizeof(bool) == sizeof true", "tcf_cpp_test_class::s_int == 1", "sizeof tcf_cpp_test_class::s_int == sizeof signed", "tcf_cpp_test_class::tcf_cpp_test_class_nested::s_int == 2", "tcf_cpp_test_class_extension::tcf_cpp_test_class_nested::s_int == 2", "enum_val1 == 1 && enum_val2 == 2 && enum_val3 == 3"};

    TestExpressions(TCFTestSuite test_suite, RunControl test_rc, IChannel channel) {
        this.test_suite = test_suite;
        this.test_rc = test_rc;
        this.diag = (IDiagnostics)channel.getRemoteService(IDiagnostics.class);
        this.expr = (IExpressions)channel.getRemoteService(IExpressions.class);
        this.syms = (ISymbols)channel.getRemoteService(ISymbols.class);
        this.stk = (IStackTrace)channel.getRemoteService(IStackTrace.class);
        this.rc = (IRunControl)channel.getRemoteService(IRunControl.class);
        this.bp = (IBreakpoints)channel.getRemoteService(IBreakpoints.class);
    }

    @Override
    public void start() {
        if (this.diag == null || this.expr == null || this.stk == null || this.rc == null || this.bp == null) {
            this.test_suite.done(this, null);
        } else {
            this.expr.addListener((IExpressions.ExpressionsListener)this);
            this.rc.addListener((IRunControl.RunControlListener)this);
            this.bp.addListener((IBreakpoints.BreakpointsListener)this);
            this.diag.getTestList(new IDiagnostics.DoneGetTestList(){

                public void doneGetTestList(IToken token, Throwable error, String[] list) {
                    if (!TestExpressions.this.test_suite.isActive(TestExpressions.this)) {
                        return;
                    }
                    if (error != null) {
                        TestExpressions.this.exit(error);
                    } else {
                        if (list.length > 0) {
                            TestExpressions.this.test_id = list[TestExpressions.this.rnd.nextInt(list.length)];
                            TestExpressions.this.runTest();
                            Protocol.invokeLater((long)100L, (Runnable)new Runnable(){

                                public void run() {
                                    if (!TestExpressions.this.test_suite.isActive(TestExpressions.this)) {
                                        return;
                                    }
                                    TestExpressions testExpressions = TestExpressions.this;
                                    testExpressions.timer = testExpressions.timer + 1;
                                    if (((TestExpressions)(this).TestExpressions.this).test_suite.cancel) {
                                        TestExpressions.this.exit(null);
                                    } else if (TestExpressions.this.timer < 600) {
                                        if (TestExpressions.this.test_done && !TestExpressions.this.cancel_test_sent) {
                                            TestExpressions.this.test_rc.cancel(TestExpressions.this.test_ctx_id);
                                            TestExpressions.this.cancel_test_sent = true;
                                        }
                                        Protocol.invokeLater((long)100L, (Runnable)this);
                                    } else if (TestExpressions.this.test_ctx_id == null) {
                                        TestExpressions.this.exit(new Error("Timeout waiting for reply of Diagnostics.runTest command"));
                                    } else {
                                        TestExpressions.this.exit(new Error("Missing 'contextRemoved' event for " + TestExpressions.this.test_ctx_id));
                                    }
                                }
                            });
                            return;
                        }
                        TestExpressions.this.exit(null);
                    }
                }
            });
        }
    }

    @Override
    public boolean canResume(String id) {
        if (this.test_ctx_id != null && this.thread_ctx == null) {
            return false;
        }
        if (this.thread_ctx != null && !this.test_done) {
            assert (this.thread_ctx.getID().equals(this.thread_id));
            IRunControl.RunControlContext ctx = this.test_rc.getContext(id);
            if (ctx == null) {
                return false;
            }
            String grp = ctx.getRCGroup();
            if (id.equals(this.thread_id) || grp != null && grp.equals(this.thread_ctx.getRCGroup())) {
                BigInteger pc1;
                if (this.run_to_bp_done) {
                    return false;
                }
                if (this.sym_func3 == null) {
                    return false;
                }
                if (this.suspended_pc == null) {
                    return false;
                }
                BigInteger pc0 = JSON.toBigInteger((Number)this.sym_func3.getValue());
                if (pc0.equals(pc1 = new BigInteger(this.suspended_pc))) {
                    return false;
                }
            }
        }
        return true;
    }

    private void runTest() {
        String id2;
        this.timer = 0;
        if (this.bp_id == null) {
            this.bp.set(null, new IBreakpoints.DoneCommand(){

                public void doneCommand(IToken token, Exception error) {
                    if (error != null) {
                        TestExpressions.this.exit(error);
                    } else {
                        TestExpressions.this.bp_id = "TestExpressionsBP";
                        TestExpressions.this.runTest();
                    }
                }
            });
            return;
        }
        if (!this.bp_ok) {
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("ID", this.bp_id);
            m.put("Enabled", Boolean.TRUE);
            m.put("Location", "tcf_test_func3");
            this.bp.set(new Map[]{m}, new IBreakpoints.DoneCommand(){

                public void doneCommand(IToken token, Exception error) {
                    if (error != null) {
                        TestExpressions.this.exit(error);
                    } else {
                        TestExpressions.this.bp_ok = true;
                        TestExpressions.this.runTest();
                    }
                }
            });
            return;
        }
        if (this.test_ctx_id == null) {
            this.diag.runTest(this.test_id, new IDiagnostics.DoneRunTest(){

                public void doneRunTest(IToken token, Throwable error, String id) {
                    if (error != null) {
                        TestExpressions.this.exit(error);
                    } else if (id == null) {
                        TestExpressions.this.exit(new Exception("Test context ID must not be null"));
                    } else if (TestExpressions.this.test_rc.getContext(id) == null) {
                        TestExpressions.this.exit(new Exception("Missing context added event"));
                    } else {
                        TestExpressions.this.test_ctx_id = id;
                        TestExpressions.this.runTest();
                    }
                }
            });
            return;
        }
        if (this.test_ctx == null) {
            this.rc.getContext(this.test_ctx_id, new IRunControl.DoneGetContext(){

                public void doneGetContext(IToken token, Exception error, IRunControl.RunControlContext ctx) {
                    if (error != null) {
                        TestExpressions.this.exit(error);
                    } else if (ctx == null) {
                        TestExpressions.this.exit(new Exception("Invalid test execution context"));
                    } else {
                        TestExpressions.this.test_ctx = ctx;
                        TestExpressions.this.process_id = TestExpressions.this.test_ctx.getProcessID();
                        if (TestExpressions.this.test_ctx.hasState()) {
                            TestExpressions.this.thread_id = TestExpressions.this.test_ctx_id;
                        }
                        TestExpressions.this.runTest();
                    }
                }
            });
            return;
        }
        if (this.thread_id == null) {
            this.rc.getChildren(this.process_id, new IRunControl.DoneGetChildren(){

                public void doneGetChildren(IToken token, Exception error, String[] ids) {
                    if (error != null) {
                        TestExpressions.this.exit(error);
                    } else if (ids == null || ids.length == 0) {
                        TestExpressions.this.exit(new Exception("Test process has no threads"));
                    } else if (ids.length != 1) {
                        TestExpressions.this.exit(new Exception("Test process has too many threads"));
                    } else {
                        TestExpressions.this.thread_id = ids[0];
                        TestExpressions.this.runTest();
                    }
                }
            });
            return;
        }
        if (this.thread_ctx == null) {
            this.rc.getContext(this.thread_id, new IRunControl.DoneGetContext(){

                public void doneGetContext(IToken token, Exception error, IRunControl.RunControlContext ctx) {
                    if (error != null) {
                        TestExpressions.this.exit(error);
                    } else if (ctx == null || !ctx.hasState()) {
                        TestExpressions.this.exit(new Exception("Invalid thread context"));
                    } else {
                        TestExpressions.this.thread_ctx = ctx;
                        TestExpressions.this.runTest();
                    }
                }
            });
            return;
        }
        if (this.suspended_pc == null) {
            this.thread_ctx.getState(new IRunControl.DoneGetState(){

                public void doneGetState(IToken token, Exception error, boolean suspended, String pc, String reason, Map<String, Object> params) {
                    if (error != null) {
                        TestExpressions.this.exit(new Exception("Cannot get context state", error));
                    } else if (!suspended) {
                        TestExpressions.this.waiting_suspend = true;
                    } else if (pc == null || pc.length() == 0 || pc.equals("0")) {
                        TestExpressions.this.exit(new Exception("Invalid context PC"));
                    } else {
                        TestExpressions.this.suspended_pc = pc;
                        TestExpressions.this.runTest();
                    }
                }
            });
            return;
        }
        if (this.sym_func3 == null) {
            this.diag.getSymbol(this.process_id, "tcf_test_func3", new IDiagnostics.DoneGetSymbol(){

                public void doneGetSymbol(IToken token, Throwable error, IDiagnostics.ISymbol symbol) {
                    if (error != null) {
                        TestExpressions.this.exit(error);
                    } else if (symbol == null) {
                        TestExpressions.this.exit(new Exception("Symbol must not be null: tcf_test_func3"));
                    } else {
                        TestExpressions.this.sym_func3 = symbol;
                        TestExpressions.this.runTest();
                    }
                }
            });
            return;
        }
        if (!this.run_to_bp_done) {
            BigInteger pc1;
            BigInteger pc0 = JSON.toBigInteger((Number)this.sym_func3.getValue());
            if (!pc0.equals(pc1 = new BigInteger(this.suspended_pc))) {
                this.waiting_suspend = true;
                return;
            }
            this.run_to_bp_done = true;
        }
        assert (this.test_done || !this.canResume(this.thread_id));
        if (this.stack_trace == null) {
            this.stk.getChildren(this.thread_id, new IStackTrace.DoneGetChildren(){

                public void doneGetChildren(IToken token, Exception error, String[] context_ids) {
                    if (error != null) {
                        TestExpressions.this.exit(error);
                    } else if (context_ids == null || context_ids.length < 2) {
                        TestExpressions.this.exit(new Exception("Invalid stack trace"));
                    } else {
                        TestExpressions.this.stack_trace = context_ids;
                        TestExpressions.this.runTest();
                    }
                }
            });
            return;
        }
        if (this.stack_frames == null) {
            this.stk.getContext(this.stack_trace, new IStackTrace.DoneGetContext(){

                public void doneGetContext(IToken token, Exception error, IStackTrace.StackTraceContext[] frames) {
                    if (error != null) {
                        TestExpressions.this.exit(error);
                    } else if (frames == null || frames.length != TestExpressions.this.stack_trace.length) {
                        TestExpressions.this.exit(new Exception("Invalid stack trace"));
                    } else {
                        TestExpressions.this.stack_frames = frames;
                        TestExpressions.this.runTest();
                    }
                }
            });
            return;
        }
        if (this.local_var_expr_ids == null) {
            this.expr.getChildren(this.stack_trace[this.stack_trace.length - 2], new IExpressions.DoneGetChildren(){

                public void doneGetChildren(IToken token, Exception error, String[] context_ids) {
                    if (error != null || context_ids == null) {
                        TestExpressions.this.local_var_expr_ids = new String[0];
                        TestExpressions.this.runTest();
                    } else {
                        TestExpressions.this.local_var_expr_ids = context_ids;
                        TestExpressions.this.runTest();
                    }
                }
            });
            return;
        }
        String[] stringArray = this.local_var_expr_ids;
        int n = this.local_var_expr_ids.length;
        int n2 = 0;
        while (n2 < n) {
            id2 = stringArray[n2];
            if (this.expr_ctx.get(id2) == null) {
                this.expr.getContext(id2, new IExpressions.DoneGetContext(){

                    public void doneGetContext(IToken token, Exception error, IExpressions.Expression ctx) {
                        if (error != null) {
                            TestExpressions.this.exit(error);
                        } else {
                            TestExpressions.this.expr_ctx.put(id2, ctx);
                            TestExpressions.this.local_var_ids.put(id2, ctx.getSymbolID());
                            TestExpressions.this.runTest();
                        }
                    }
                });
                return;
            }
            ++n2;
        }
        if (this.syms != null && this.local_var_expr_ids.length > 0) {
            stringArray = global_var_names;
            n = global_var_names.length;
            n2 = 0;
            while (n2 < n) {
                final String nm = stringArray[n2];
                if (!this.global_var_ids.containsKey(nm)) {
                    this.syms.find(this.process_id, (Number)new BigInteger(this.suspended_pc), nm, new ISymbols.DoneFind(){

                        public void doneFind(IToken token, Exception error, String symbol_id) {
                            if (error != null) {
                                if (nm.startsWith("tcf_cpp_") && error instanceof IErrorReport && ((IErrorReport)error).getErrorCode() == 22) {
                                    TestExpressions.this.global_var_ids.put(nm, null);
                                    TestExpressions.this.no_cpp = true;
                                    TestExpressions.this.runTest();
                                    return;
                                }
                                TestExpressions.this.exit(error);
                            } else if (symbol_id == null) {
                                TestExpressions.this.exit(new Exception("Invalid symbol ID"));
                            } else {
                                TestExpressions.this.global_var_ids.put(nm, symbol_id);
                                TestExpressions.this.runTest();
                            }
                        }
                    });
                    return;
                }
                ++n2;
            }
        }
        if (this.syms != null && !this.loc_info_done) {
            for (final String id2 : this.global_var_ids.values()) {
                if (id2 == null || this.global_var_location.get(id2) != null) continue;
                this.syms.getLocationInfo(id2, new ISymbols.DoneGetLocationInfo(){

                    public void doneGetLocationInfo(IToken token, Exception error, Map<String, Object> props) {
                        SymbolLocation l = new SymbolLocation();
                        l.error = error;
                        l.props = props;
                        TestExpressions.this.global_var_location.put(id2, l);
                        List cmds = (List)props.get("ValueCmds");
                        if (error != null) {
                            if (error instanceof IErrorReport && ((IErrorReport)error).getErrorCode() == 25) {
                                TestExpressions.this.runTest();
                                return;
                            }
                            TestExpressions.this.exit(error);
                        } else if (cmds == null || cmds.size() == 0) {
                            TestExpressions.this.exit(new Exception("Invalid symbol location info"));
                        } else {
                            TestExpressions.this.runTest();
                        }
                    }
                });
                return;
            }
            for (final String id2 : this.local_var_ids.values()) {
                if (id2 == null || this.local_var_location.get(id2) != null) continue;
                this.syms.getLocationInfo(id2, new ISymbols.DoneGetLocationInfo(){

                    public void doneGetLocationInfo(IToken token, Exception error, Map<String, Object> props) {
                        SymbolLocation l = new SymbolLocation();
                        l.error = error;
                        l.props = props;
                        TestExpressions.this.local_var_location.put(id2, l);
                        List cmds = (List)props.get("ValueCmds");
                        if (error != null) {
                            if (error instanceof IErrorReport && ((IErrorReport)error).getErrorCode() == 25) {
                                TestExpressions.this.runTest();
                                return;
                            }
                            TestExpressions.this.exit(error);
                        } else if (cmds == null || cmds.size() == 0) {
                            TestExpressions.this.exit(new Exception("Invalid symbol location info"));
                        } else {
                            TestExpressions.this.runTest();
                        }
                    }
                });
                return;
            }
            this.loc_info_done = true;
        }
        stringArray = test_expressions;
        n = test_expressions.length;
        int n3 = 0;
        while (n3 < n) {
            final String txt = stringArray[n3];
            if ((this.local_var_expr_ids.length != 0 || txt.indexOf("func2_local") < 0 && txt.indexOf("test_struct") < 0 && txt.indexOf("tcf_test_array") < 0 && txt.indexOf("(char *)") < 0 && txt.indexOf("enum_val") < 0) && (this.local_var_expr_ids.length != 0 && !this.no_cpp || txt.indexOf("tcf_cpp_test") < 0 && txt.indexOf("(bool)") < 0) && this.expr_ctx.get(txt) == null) {
                this.expr.create(this.stack_trace[this.stack_trace.length - 2], null, txt, new IExpressions.DoneCreate(){

                    public void doneCreate(IToken token, Exception error, IExpressions.Expression ctx) {
                        if (error != null) {
                            TestExpressions.this.exit(error);
                        } else {
                            TestExpressions.this.expr_to_dispose.add(ctx.getID());
                            TestExpressions.this.expr_ctx.put(txt, ctx);
                            TestExpressions.this.runTest();
                        }
                    }
                });
                return;
            }
            ++n3;
        }
        stringArray = this.local_var_expr_ids;
        n = this.local_var_expr_ids.length;
        n3 = 0;
        while (n3 < n) {
            id2 = stringArray[n3];
            if (this.expr_val.get(id2) == null) {
                this.expr.evaluate(id2, new IExpressions.DoneEvaluate(){

                    public void doneEvaluate(IToken token, Exception error, IExpressions.Value ctx) {
                        if (error != null) {
                            TestExpressions.this.exit(error);
                        } else {
                            TestExpressions.this.expr_val.put(id2, ctx);
                            TestExpressions.this.runTest();
                        }
                    }
                });
                return;
            }
            ++n3;
        }
        Iterator<String> iterator = this.expr_ctx.keySet().iterator();
        while (iterator.hasNext()) {
            id2 = iterator.next();
            if (this.expr_val.get(id2) != null) continue;
            this.expr.evaluate(this.expr_ctx.get(id2).getID(), new IExpressions.DoneEvaluate(){

                public void doneEvaluate(IToken token, Exception error, IExpressions.Value ctx) {
                    if (error != null) {
                        TestExpressions.this.exit(error);
                    } else {
                        TestExpressions.this.expr_val.put(id2, ctx);
                        byte[] arr = ctx.getValue();
                        boolean b = false;
                        byte[] byArray = arr;
                        int n = arr.length;
                        int n2 = 0;
                        while (n2 < n) {
                            byte x = byArray[n2];
                            if (x != 0) {
                                b = true;
                            }
                            ++n2;
                        }
                        if (!b) {
                            TestExpressions.this.exit(new Exception("Invalid value of expression \"" + id2 + "\""));
                        }
                        TestExpressions.this.runTest();
                    }
                }
            });
            return;
        }
        if (this.syms != null) {
            for (final String id2 : this.expr_val.keySet()) {
                IExpressions.Value v;
                String type_id;
                if (this.expr_sym.get(id2) != null || (type_id = (v = this.expr_val.get(id2)).getTypeID()) == null) continue;
                this.syms.getContext(type_id, new ISymbols.DoneGetContext(){

                    public void doneGetContext(IToken token, Exception error, ISymbols.Symbol ctx) {
                        if (error != null) {
                            TestExpressions.this.exit(error);
                        } else if (ctx == null) {
                            TestExpressions.this.exit(new Exception("Symbol.getContext returned null"));
                        } else {
                            TestExpressions.this.expr_sym.put(id2, ctx);
                            TestExpressions.this.runTest();
                        }
                    }
                });
                return;
            }
            iterator = this.expr_sym.keySet().iterator();
            while (iterator.hasNext()) {
                id2 = iterator.next();
                if (this.expr_chld.get(id2) != null) continue;
                ISymbols.Symbol sym = this.expr_sym.get(id2);
                this.syms.getChildren(sym.getID(), new ISymbols.DoneGetChildren(){

                    public void doneGetChildren(IToken token, Exception error, String[] context_ids) {
                        if (error != null) {
                            TestExpressions.this.exit(error);
                        } else {
                            if (context_ids == null) {
                                context_ids = new String[]{};
                            }
                            TestExpressions.this.expr_chld.put(id2, context_ids);
                            TestExpressions.this.runTest();
                        }
                    }
                });
                return;
            }
        }
        if ((iterator = this.expr_to_dispose.iterator()).hasNext()) {
            id2 = iterator.next();
            this.expr.dispose(id2, new IExpressions.DoneDispose(){

                public void doneDispose(IToken token, Exception error) {
                    if (error != null) {
                        TestExpressions.this.exit(error);
                    } else {
                        TestExpressions.this.expr_to_dispose.remove(id2);
                        TestExpressions.this.runTest();
                    }
                }
            });
            return;
        }
        this.test_done = true;
    }

    private void exit(Throwable x) {
        if (!this.test_suite.isActive(this)) {
            return;
        }
        this.expr.removeListener((IExpressions.ExpressionsListener)this);
        this.bp.removeListener((IBreakpoints.BreakpointsListener)this);
        this.rc.removeListener((IRunControl.RunControlListener)this);
        this.test_suite.done(this, x);
    }

    public void containerResumed(String[] context_ids) {
        String[] stringArray = context_ids;
        int n = context_ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            this.contextResumed(id);
            ++n2;
        }
    }

    public void containerSuspended(String context, String pc, String reason, Map<String, Object> params, String[] suspended_ids) {
        String[] stringArray = suspended_ids;
        int n = suspended_ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            this.contextSuspended(id, null, null, null);
            ++n2;
        }
    }

    public void contextAdded(IRunControl.RunControlContext[] contexts) {
    }

    public void contextChanged(IRunControl.RunControlContext[] contexts) {
    }

    public void contextException(String context, String msg) {
        if (this.test_done) {
            return;
        }
        IRunControl.RunControlContext ctx = this.test_rc.getContext(context);
        if (ctx != null) {
            String p = ctx.getParentID();
            String c = ctx.getCreatorID();
            if (!this.test_ctx_id.equals(c) && !this.test_ctx_id.equals(p)) {
                return;
            }
        }
        this.exit(new Exception("Context exception: " + msg));
    }

    public void contextRemoved(String[] context_ids) {
        String[] stringArray = context_ids;
        int n = context_ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (id.equals(this.test_ctx_id)) {
                if (this.test_done) {
                    this.bp.set(null, new IBreakpoints.DoneCommand(){

                        public void doneCommand(IToken token, Exception error) {
                            TestExpressions.this.exit(error);
                        }
                    });
                } else {
                    this.exit(new Exception("Test process exited too soon"));
                }
                return;
            }
            ++n2;
        }
    }

    public void contextResumed(String id) {
        if (id.equals(this.thread_id)) {
            if (this.run_to_bp_done && !this.test_done) {
                assert (this.thread_ctx != null);
                assert (!this.canResume(this.thread_id));
                this.exit(new Exception("Unexpected contextResumed event: " + id));
            }
            this.suspended_pc = null;
        }
    }

    public void contextSuspended(String id, String pc, String reason, Map<String, Object> params) {
        assert (id != null);
        if (id.equals(this.thread_id) && this.waiting_suspend) {
            this.suspended_pc = pc;
            this.waiting_suspend = false;
            this.runTest();
        }
    }

    public void valueChanged(String id) {
    }

    public void breakpointStatusChanged(String id, Map<String, Object> status) {
        if (id.equals(this.bp_id) && this.process_id != null && !this.test_done) {
            Collection list;
            String s = (String)status.get("Error");
            if (s != null) {
                this.exit(new Exception("Invalid BP status: " + s));
            }
            if ((list = (Collection)status.get("Instances")) == null) {
                return;
            }
            String err = null;
            for (Map map : list) {
                String ctx = (String)map.get("LocationContext");
                if (!this.process_id.equals(ctx) || map.get("Error") == null) continue;
                err = (String)map.get("Error");
            }
            if (err != null) {
                this.exit(new Exception("Invalid BP status: " + err));
            }
        }
    }

    public void contextAdded(Map<String, Object>[] bps) {
    }

    public void contextChanged(Map<String, Object>[] bps) {
    }

    private static class SymbolLocation {
        Exception error;
        Map<String, Object> props;

        private SymbolLocation() {
        }
    }
}

