/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.tests;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.eclipse.tcf.internal.debug.tests.ITCFTest;
import org.eclipse.tcf.internal.debug.tests.TCFTestSuite;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IProcesses;
import org.eclipse.tcf.services.IStreams;
import org.eclipse.tcf.services.ITerminals;

class TestTerminals
implements ITCFTest {
    private final TCFTestSuite test_suite;
    private final ITerminals terminals;
    private final IProcesses processes;
    private final IStreams streams;
    private final Random rnd = new Random();
    private final HashSet<String> stream_ids = new HashSet();
    private final StringBuffer stdout_buf = new StringBuffer();
    private final StringBuffer stderr_buf = new StringBuffer();
    private final HashSet<IToken> disconnect_cmds = new HashSet();
    private final List<String> echo_tx = new ArrayList<String>();
    private final List<Integer> echo_rx = new ArrayList<Integer>();
    private final int echo_cnt = 50;
    private IStreams.StreamsListener streams_listener;
    private IStreams.DoneRead stdout_read;
    private IStreams.DoneRead stderr_read;
    private String encoding;
    private ITerminals.TerminalContext terminal;
    private ITerminals.TerminalContext get_ctx;
    private Map<String, String> environment;
    private boolean delay_done;
    private Collection<Map<String, Object>> signal_list;
    private IToken get_signals_cmd;
    private IToken signal_cmd;
    private boolean signal_sent;
    private IToken unsubscribe_cmd;
    private boolean unsubscribe_done;
    private boolean exited;
    private boolean stdout_eos;
    private int time_out = 0;
    private final ITerminals.TerminalsListener listener = new ITerminals.TerminalsListener(){

        public void exited(String id, int exit_code) {
            if (TestTerminals.this.terminal != null && id.equals(TestTerminals.this.terminal.getID())) {
                TestTerminals.this.exited = true;
                if (!TestTerminals.this.signal_sent) {
                    TestTerminals.this.exit(new Exception("Terminal exited with code " + exit_code));
                } else {
                    TestTerminals.this.run();
                }
            }
        }

        public void winSizeChanged(String id, int w, int h) {
        }
    };
    private final IStreams.DoneDisconnect disconnect_done = new IStreams.DoneDisconnect(){

        public void doneDisconnect(IToken token, Exception error) {
            if (!$assertionsDisabled && !TestTerminals.this.disconnect_cmds.contains(token)) {
                throw new AssertionError();
            }
            TestTerminals.this.disconnect_cmds.remove(token);
            if (error != null) {
                TestTerminals.this.exit(error);
            }
            if (TestTerminals.this.disconnect_cmds.size() == 0 && TestTerminals.this.unsubscribe_done) {
                TestTerminals.this.exit(null);
            }
        }
    };

    TestTerminals(TCFTestSuite test_suite, IChannel channel) {
        this.test_suite = test_suite;
        this.terminals = (ITerminals)channel.getRemoteService(ITerminals.class);
        this.processes = (IProcesses)channel.getRemoteService(IProcesses.class);
        this.streams = (IStreams)channel.getRemoteService(IStreams.class);
    }

    public void start() {
        if (this.terminals == null || this.streams == null) {
            this.test_suite.done(this, null);
        } else {
            this.terminals.addListener(this.listener);
            this.run();
        }
    }

    private void run() {
        String id;
        int i;
        if (this.environment == null && this.processes != null) {
            this.processes.getEnvironment(new IProcesses.DoneGetEnvironment(){

                public void doneGetEnvironment(IToken token, Exception error, Map<String, String> environment) {
                    if (error != null) {
                        TestTerminals.this.exit(error);
                    } else if (environment == null) {
                        TestTerminals.this.exit(new Exception("Default process environment must not be null"));
                    } else {
                        TestTerminals.this.environment = environment;
                        TestTerminals.this.run();
                    }
                }
            });
            return;
        }
        if (this.streams_listener == null) {
            final IStreams.StreamsListener l = new IStreams.StreamsListener(){

                public void created(String stream_type, String stream_id, String context_id) {
                    if (!TestTerminals.this.terminals.getName().equals(stream_type)) {
                        TestTerminals.this.exit(new Exception("Invalid stream type in Streams.created event: " + stream_type));
                    } else if (stream_id == null || stream_id.length() == 0 || TestTerminals.this.stream_ids.contains(stream_id)) {
                        TestTerminals.this.exit(new Exception("Invalid stream ID in Streams.created event: " + stream_id));
                    } else if (TestTerminals.this.terminal != null) {
                        if (stream_id.equals(TestTerminals.this.terminal.getStdInID()) || stream_id.equals(TestTerminals.this.terminal.getStdOutID()) || stream_id.equals(TestTerminals.this.terminal.getStdErrID())) {
                            TestTerminals.this.exit(new Exception("Invalid stream ID in Streams.created event: " + stream_id));
                        } else {
                            TestTerminals.this.disconnect_cmds.add(TestTerminals.this.streams.disconnect(stream_id, TestTerminals.this.disconnect_done));
                        }
                    } else {
                        TestTerminals.this.stream_ids.add(stream_id);
                    }
                }

                public void disposed(String stream_type, String stream_id) {
                }
            };
            this.streams.subscribe(this.terminals.getName(), l, new IStreams.DoneSubscribe(){

                public void doneSubscribe(IToken token, Exception error) {
                    if (error != null) {
                        TestTerminals.this.exit(error);
                    } else {
                        TestTerminals.this.streams_listener = l;
                        TestTerminals.this.run();
                    }
                }
            });
            return;
        }
        if (this.terminal == null) {
            String[] stringArray = new String[3];
            stringArray[0] = "ansi";
            stringArray[1] = "vt100";
            String[] types = stringArray;
            String[] stringArray2 = new String[3];
            stringArray2[0] = "en_US";
            stringArray2[1] = "en_US.UTF-8";
            String[] langs = stringArray2;
            String[] env = null;
            if (this.environment != null && this.rnd.nextBoolean()) {
                int i2 = 0;
                env = new String[this.environment.size() + 1];
                for (String s : this.environment.keySet()) {
                    env[i2++] = String.valueOf(s) + "=" + this.environment.get(s);
                }
                env[i2++] = "TCF_FOO=BAR";
            }
            this.terminals.launch(types[this.rnd.nextInt(types.length)], langs[this.rnd.nextInt(langs.length)], env, new ITerminals.DoneLaunch(){

                public void doneLaunch(IToken token, Exception error, final ITerminals.TerminalContext terminal) {
                    if (error != null) {
                        TestTerminals.this.exit(error);
                    } else if (terminal == null) {
                        TestTerminals.this.exit(new Exception("Terminal context must not be null"));
                    } else if (terminal.getID() == null) {
                        TestTerminals.this.exit(new Exception("Terminal context ID must not be null"));
                    } else {
                        TestTerminals.this.terminal = terminal;
                        Iterator i = TestTerminals.this.stream_ids.iterator();
                        while (i.hasNext()) {
                            String stream_id = (String)i.next();
                            if (stream_id.equals(terminal.getStdInID()) || stream_id.equals(terminal.getStdOutID()) || stream_id.equals(terminal.getStdErrID())) continue;
                            i.remove();
                            TestTerminals.this.disconnect_cmds.add(TestTerminals.this.streams.disconnect(stream_id, TestTerminals.this.disconnect_done));
                        }
                        Protocol.invokeLater((long)100L, (Runnable)new Runnable(){

                            public void run() {
                                if (!TestTerminals.this.test_suite.isActive(TestTerminals.this)) {
                                    return;
                                }
                                TestTerminals testTerminals = TestTerminals.this;
                                testTerminals.time_out = testTerminals.time_out + 1;
                                if (((TestTerminals)(this).TestTerminals.this).test_suite.cancel) {
                                    TestTerminals.this.exit(null);
                                } else if (TestTerminals.this.time_out < 200) {
                                    Protocol.invokeLater((long)100L, (Runnable)this);
                                } else if (!TestTerminals.this.signal_sent) {
                                    TestTerminals.this.exit(new Error("Timeout waiting for terminal reply. Context: " + terminal.getID()));
                                } else if (!TestTerminals.this.exited) {
                                    TestTerminals.this.exit(new Error("Timeout waiting for 'Terminals.exited' event. Context: " + terminal.getID()));
                                } else {
                                    TestTerminals.this.exit(new Error("Timeout waiting for end-of-stream. Context: " + terminal.getID()));
                                }
                            }
                        });
                        TestTerminals.this.run();
                    }
                }
            });
            return;
        }
        if (this.get_ctx == null) {
            this.terminals.getContext(this.terminal.getID(), new ITerminals.DoneGetContext(){

                public void doneGetContext(IToken token, Exception error, ITerminals.TerminalContext terminal) {
                    if (error != null) {
                        TestTerminals.this.exit(error);
                    } else if (terminal == null) {
                        TestTerminals.this.exit(new Exception("Terminal context must not be null"));
                    } else if (terminal.getID() == null) {
                        TestTerminals.this.exit(new Exception("Terminal context ID must not be null"));
                    } else if (!TestTerminals.this.terminal.getProperties().equals(terminal.getProperties())) {
                        TestTerminals.this.exit(new Exception("Invalid result of Terminal.getContext"));
                    } else {
                        TestTerminals.this.get_ctx = terminal;
                        TestTerminals.this.run();
                    }
                }
            });
            return;
        }
        if (this.signal_list == null && this.processes != null && this.terminal.getProcessID() != null) {
            assert (this.get_signals_cmd == null);
            this.get_signals_cmd = this.processes.getSignalList(this.terminal.getProcessID(), new IProcesses.DoneGetSignalList(){

                public void doneGetSignalList(IToken token, Exception error, Collection<Map<String, Object>> list) {
                    if (!$assertionsDisabled && TestTerminals.this.get_signals_cmd != token) {
                        throw new AssertionError();
                    }
                    TestTerminals.this.get_signals_cmd = null;
                    if (error != null) {
                        TestTerminals.this.exit(error);
                    } else if (list == null) {
                        TestTerminals.this.exit(new Exception("Signal list must not be null"));
                    } else {
                        TestTerminals.this.signal_list = list;
                        TestTerminals.this.run();
                    }
                }
            });
            return;
        }
        if (this.encoding == null) {
            String lang = this.terminal.getEncoding();
            if (lang == null && this.environment != null) {
                lang = this.environment.get("LC_ALL");
            }
            if (lang == null && this.environment != null) {
                lang = this.environment.get("LANG");
            }
            if (lang == null) {
                lang = "en_US.UTF-8";
            }
            i = lang.indexOf(46);
            int j = lang.indexOf(64);
            this.encoding = i < 0 ? "UTF-8" : (j < i ? lang.substring(i + 1) : lang.substring(i + 1, j));
        }
        if (this.stdout_read == null) {
            id = this.terminal.getStdOutID();
            if (id == null) {
                this.exit(new Exception("stdout stream ID is null"));
                return;
            }
            this.stdout_read = new IStreams.DoneRead(){

                public void doneRead(IToken token, Exception error, int lost_size, byte[] data, boolean eos) {
                    if (error != null) {
                        TestTerminals.this.exit(error);
                    } else if (lost_size > 0) {
                        TestTerminals.this.exit(new Exception("Lost bytes in terminal stream"));
                    } else {
                        try {
                            boolean run = false;
                            if (data != null) {
                                TestTerminals.this.stdout_buf.append(new String(data, TestTerminals.this.encoding));
                                if (TestTerminals.this.echo_tx.size() > TestTerminals.this.echo_rx.size()) {
                                    int i;
                                    String s = (String)TestTerminals.this.echo_tx.get(TestTerminals.this.echo_rx.size());
                                    String p = "\n" + s.substring(0, 12);
                                    int n = 0;
                                    if (TestTerminals.this.echo_rx.size() > 0) {
                                        n = (Integer)TestTerminals.this.echo_rx.get(TestTerminals.this.echo_rx.size() - 1);
                                    }
                                    if ((i = TestTerminals.this.stdout_buf.indexOf(p, n)) >= 0 && TestTerminals.this.stdout_buf.length() >= i + s.length() + 4) {
                                        TestTerminals.this.time_out = 0;
                                        TestTerminals.this.echo_rx.add(i + 1);
                                        run = true;
                                    }
                                }
                            }
                            if (!eos) {
                                TestTerminals.this.streams.read(id, 4096, (IStreams.DoneRead)this);
                            } else {
                                TestTerminals.this.stdout_eos = true;
                                run = true;
                            }
                            if (run) {
                                TestTerminals.this.run();
                            }
                        }
                        catch (Exception x) {
                            TestTerminals.this.exit(x);
                        }
                    }
                }
            };
            this.streams.read(id, 4096, this.stdout_read);
        }
        if (this.stderr_read == null && this.terminal.getStdErrID() != null) {
            id = this.terminal.getStdErrID();
            this.stderr_read = new IStreams.DoneRead(){

                public void doneRead(IToken token, Exception error, int lost_size, byte[] data, boolean eos) {
                    if (error != null) {
                        TestTerminals.this.exit(error);
                    } else if (lost_size > 0) {
                        TestTerminals.this.exit(new Exception("Lost bytes in terminal stream"));
                    } else {
                        try {
                            if (data != null) {
                                TestTerminals.this.stderr_buf.append(new String(data, TestTerminals.this.encoding));
                            }
                            if (!eos) {
                                TestTerminals.this.streams.read(id, 4096, (IStreams.DoneRead)this);
                            }
                        }
                        catch (Exception x) {
                            TestTerminals.this.exit(x);
                        }
                    }
                }
            };
            int n = this.rnd.nextInt(4) + 1;
            int i3 = 0;
            while (i3 < n) {
                this.streams.read(id, 4096, this.stderr_read);
                ++i3;
            }
        }
        if (!this.delay_done) {
            final int n = this.stdout_buf.length();
            Protocol.invokeLater((long)this.rnd.nextInt(250), (Runnable)new Runnable(){

                public void run() {
                    if (n > 1 && TestTerminals.this.stdout_buf.length() == n && TestTerminals.this.stdout_buf.charAt(n - 1) != '\n') {
                        TestTerminals.this.delay_done = true;
                    }
                    TestTerminals.this.run();
                }
            });
            return;
        }
        if (this.echo_tx.size() < 50 && this.echo_rx.size() == this.echo_tx.size()) {
            try {
                StringBuffer bf = new StringBuffer();
                i = 0;
                while (i < 256) {
                    bf.append((char)(65 + this.rnd.nextInt(26)));
                    bf.append((char)(97 + this.rnd.nextInt(26)));
                    ++i;
                }
                String s = bf.toString();
                this.echo_tx.add(s);
                s = "echo " + s + '\n';
                byte[] buf = s.getBytes(this.encoding);
                this.streams.write(this.terminal.getStdInID(), buf, 0, buf.length, new IStreams.DoneWrite(){

                    public void doneWrite(IToken token, Exception error) {
                        if (error != null) {
                            TestTerminals.this.exit(error);
                        } else {
                            TestTerminals.this.run();
                        }
                    }
                });
            }
            catch (Exception x) {
                this.exit(x);
            }
            return;
        }
        if (!this.exited && !this.stdout_eos && this.echo_rx.size() < 50) {
            return;
        }
        if (!this.signal_sent) {
            assert (!this.exited);
            if (this.signal_cmd == null) {
                int code = 0;
                if (this.signal_list != null && this.rnd.nextBoolean()) {
                    Number n;
                    String nm;
                    for (Map<String, Object> m : this.signal_list) {
                        nm = (String)m.get("Name");
                        if (nm == null || !nm.equals("SIGKILL") || (n = (Number)m.get("Code")) == null) continue;
                        code = n.intValue();
                    }
                    if (code == 0) {
                        for (Map<String, Object> m : this.signal_list) {
                            nm = (String)m.get("Name");
                            if (nm == null || !nm.equals("SIGTERM") || (n = (Number)m.get("Code")) == null) continue;
                            code = n.intValue();
                        }
                    }
                }
                this.signal_cmd = code > 0 ? this.processes.signal(this.terminal.getProcessID(), (long)code, new IProcesses.DoneCommand(){

                    public void doneCommand(IToken token, Exception error) {
                        if (!$assertionsDisabled && TestTerminals.this.signal_cmd != token) {
                            throw new AssertionError();
                        }
                        TestTerminals.this.signal_cmd = null;
                        if (error != null) {
                            TestTerminals.this.exit(error);
                        } else {
                            TestTerminals.this.signal_sent = true;
                            TestTerminals.this.run();
                        }
                    }
                }) : this.terminals.exit(this.terminal.getID(), new ITerminals.DoneCommand(){

                    public void doneCommand(IToken token, Exception error) {
                        if (!$assertionsDisabled && TestTerminals.this.signal_cmd != token) {
                            throw new AssertionError();
                        }
                        TestTerminals.this.signal_cmd = null;
                        if (error != null) {
                            TestTerminals.this.exit(error);
                        } else {
                            TestTerminals.this.signal_sent = true;
                            TestTerminals.this.run();
                        }
                    }
                });
            }
            return;
        }
        if (this.exited && this.stdout_eos) {
            if (!this.unsubscribe_done) {
                if (this.unsubscribe_cmd == null) {
                    this.unsubscribe_cmd = this.streams.unsubscribe(this.terminals.getName(), this.streams_listener, new IStreams.DoneUnsubscribe(){

                        public void doneUnsubscribe(IToken token, Exception error) {
                            TestTerminals.this.unsubscribe_done = true;
                            if (error != null) {
                                TestTerminals.this.exit(error);
                            } else {
                                TestTerminals.this.run();
                            }
                        }
                    });
                }
                return;
            }
            for (String stream_id : this.stream_ids) {
                this.disconnect_cmds.add(this.streams.disconnect(stream_id, this.disconnect_done));
            }
            this.stream_ids.clear();
            this.checkTerminalOutput(this.stdout_buf);
            this.checkTerminalOutput(this.stderr_buf);
            if (this.echo_rx.size() < 50) {
                this.exit(new Exception("Terminal exited before test finished"));
            } else {
                int n = 0;
                for (int i4 : this.echo_rx) {
                    String r;
                    String s;
                    if ((s = this.echo_tx.get(n++)).equals(r = this.stdout_buf.substring(i4, i4 + s.length()))) continue;
                    this.exit(new Exception("Invalid reply: " + r + "\nExpected: " + s));
                }
            }
        }
    }

    private void checkTerminalOutput(StringBuffer bf) {
        if (bf.indexOf("Cannot start") >= 0) {
            this.exit(new Exception("Unexpected terminal output:\n" + bf));
        }
    }

    private void exit(Throwable x) {
        if (!this.test_suite.isActive(this)) {
            return;
        }
        if (this.terminals != null) {
            this.terminals.removeListener(this.listener);
        }
        this.test_suite.done(this, x);
    }

    public boolean canResume(String id) {
        return true;
    }
}

