/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.commands;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.IRequest;
import org.eclipse.debug.core.commands.IDebugCommandHandler;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IEnabledStateRequest;
import org.eclipse.tcf.internal.debug.model.TCFContextState;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.internal.debug.ui.model.TCFRunnable;
import org.eclipse.tcf.services.IRunControl;
import org.eclipse.tcf.util.TCFDataCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class StepCommand
implements IDebugCommandHandler {
    private static final int MAX_ACTION_CNT = 4;
    protected final TCFModel model;

    public StepCommand(TCFModel model) {
        this.model = model;
    }

    protected abstract boolean canExecute(IRunControl.RunControlContext var1);

    protected abstract void execute(IDebugCommandRequest var1, IRunControl.RunControlContext var2, boolean var3, Runnable var4);

    private boolean getContextSet(boolean exec, Object[] elements, Set<IRunControl.RunControlContext> set, Runnable done) {
        int i = 0;
        while (i < elements.length) {
            TCFNode node = null;
            node = elements[i] instanceof TCFNode ? (TCFNode)elements[i] : this.model.getRootNode();
            while (node != null && !node.isDisposed()) {
                IRunControl.RunControlContext ctx = null;
                if (node instanceof TCFNodeExecContext) {
                    TCFDataCache<IRunControl.RunControlContext> cache = ((TCFNodeExecContext)node).getRunContext();
                    if (!cache.validate(done)) {
                        return false;
                    }
                    ctx = (IRunControl.RunControlContext)cache.getData();
                }
                if (ctx == null) {
                    node = node.getParent();
                    continue;
                }
                if (!this.canExecute(ctx)) break;
                int action_cnt = this.model.getLaunch().getContextActionsCount(ctx.getID());
                if (exec && action_cnt >= 4) break;
                if (action_cnt > 0) {
                    set.add(ctx);
                    break;
                }
                if (ctx.isContainer()) {
                    TCFNodeExecContext.ChildrenStateInfo s = new TCFNodeExecContext.ChildrenStateInfo();
                    if (!((TCFNodeExecContext)node).hasSuspendedChildren(s, done)) {
                        return false;
                    }
                    if (s.suspended || s.not_active) {
                        set.add(ctx);
                    }
                }
                if (!ctx.hasState()) break;
                TCFDataCache<TCFContextState> state_cache = ((TCFNodeExecContext)node).getState();
                if (!state_cache.validate(done)) {
                    return false;
                }
                TCFContextState state_data = (TCFContextState)state_cache.getData();
                if (state_data == null || !state_data.is_suspended) break;
                set.add(ctx);
                break;
            }
            ++i;
        }
        return true;
    }

    public final void canExecute(final IEnabledStateRequest monitor) {
        new TCFRunnable((IRequest)monitor){

            public void run() {
                if (this.done) {
                    return;
                }
                if (!monitor.isCanceled()) {
                    HashSet set = new HashSet();
                    if (!StepCommand.this.getContextSet(false, monitor.getElements(), set, this)) {
                        return;
                    }
                    monitor.setEnabled(set.size() > 0);
                    monitor.setStatus(Status.OK_STATUS);
                }
                this.done();
            }
        };
    }

    public final boolean execute(final IDebugCommandRequest monitor) {
        new TCFRunnable((IRequest)monitor){

            public void run() {
                if (this.done) {
                    return;
                }
                HashSet set = new HashSet();
                if (!StepCommand.this.getContextSet(true, monitor.getElements(), set, this)) {
                    return;
                }
                if (set.size() == 0) {
                    monitor.setStatus(Status.OK_STATUS);
                    monitor.done();
                } else {
                    final HashSet<1> wait_list = new HashSet<1>();
                    for (IRunControl.RunControlContext ctx : set) {
                        Runnable done = new Runnable(){

                            public void run() {
                                wait_list.remove(this);
                                if (wait_list.isEmpty()) {
                                    monitor.done();
                                }
                            }
                        };
                        wait_list.add(done);
                        StepCommand.this.execute(monitor, ctx, !StepCommand.this.model.isInstructionSteppingEnabled(), done);
                    }
                }
            }
        };
        return true;
    }
}

