/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.launch;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.debug.ui.ITCFLaunchContext;
import org.eclipse.tcf.internal.debug.ui.Activator;
import org.eclipse.tcf.internal.debug.ui.launch.TCFLaunchContext;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCFLaunchShortcut
implements ILaunchShortcut {
    private static final String LAUNCH_CONFIGURATION_TYPE_ID = "org.eclipse.tcf.debug.LaunchConfigurationType";

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            int count;
            IStructuredSelection ss = (IStructuredSelection)selection;
            Object obj = ss.getFirstElement();
            ITCFLaunchContext context = TCFLaunchContext.getLaunchContext(obj);
            IProject project = context.getProject(obj);
            IPath path = context.getPath(obj);
            ILaunchConfiguration config = null;
            List<ILaunchConfiguration> list = this.searchConfigurations(project, path);
            if (list != null && (config = (count = list.size()) == 0 ? this.createConfiguration(project, path) : (count == 1 ? list.get(0) : this.chooseConfiguration(list))) != null) {
                DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
            }
        }
    }

    public void launch(IEditorPart editor, String mode) {
    }

    private List<ILaunchConfiguration> searchConfigurations(IProject project, IPath path) {
        try {
            ILaunchConfiguration[] configs;
            ArrayList<ILaunchConfiguration> list = new ArrayList<ILaunchConfiguration>();
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType type = manager.getLaunchConfigurationType(LAUNCH_CONFIGURATION_TYPE_ID);
            ILaunchConfiguration[] iLaunchConfigurationArray = configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(type);
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                if (config.getAttribute("org.eclipse.tcf.debug.LocalProgramFile", "").equals(path.toOSString()) && config.getAttribute("org.eclipse.tcf.debug.ProjectName", "").equals(project.getName())) {
                    list.add(config);
                }
                ++n2;
            }
            return list;
        }
        catch (CoreException x) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error searching available launch configurations", (String)x.getStatus().getMessage());
            return null;
        }
    }

    private ILaunchConfiguration chooseConfiguration(List<ILaunchConfiguration> list) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(list.toArray());
        dialog.setTitle("TCF Launch Configuration");
        dialog.setMessage("&Select existing configuration:");
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    private ILaunchConfiguration createConfiguration(IProject project, IPath path) {
        ILaunchConfiguration config = null;
        ILaunchConfigurationWorkingCopy wc = null;
        try {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType type = manager.getLaunchConfigurationType(LAUNCH_CONFIGURATION_TYPE_ID);
            wc = type.newInstance(null, manager.generateLaunchConfigurationName("TCF Local Host " + path.lastSegment()));
            wc.setAttribute("org.eclipse.tcf.debug.LocalProgramFile", path.toOSString());
            wc.setAttribute("org.eclipse.tcf.debug.ProjectName", project.getName());
            config = wc.doSave();
        }
        catch (CoreException x) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Cannot create launch configuration", (String)x.getStatus().getMessage());
        }
        return config;
    }

    private Shell getShell() {
        Shell shell = null;
        IWorkbenchWindow window = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            shell = window.getShell();
        }
        return shell;
    }
}

