/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.ui.internal.handler;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.te.launch.core.lm.LaunchConfigHelper;
import org.eclipse.tcf.te.launch.core.lm.LaunchManager;
import org.eclipse.tcf.te.launch.ui.activator.UIPlugin;
import org.eclipse.tcf.te.launch.ui.model.LaunchNode;
import org.eclipse.tcf.te.launch.ui.nls.Messages;
import org.eclipse.tcf.te.ui.jface.dialogs.OptionalMessageDialog;
import org.eclipse.ui.handlers.HandlerUtil;

public class LaunchDialogHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object element;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof LaunchNode) {
            this.doLaunch((LaunchNode)((Object)element));
        }
        return null;
    }

    protected void doLaunch(LaunchNode node) {
        if (node != null && node.getLaunchConfiguration() != null) {
            String[] modes = LaunchConfigHelper.getLaunchConfigTypeModes((ILaunchConfigurationType)node.getLaunchConfigurationType(), (boolean)false);
            ArrayList<String> modeLabels = new ArrayList<String>();
            int defaultIndex = 0;
            String[] stringArray = modes;
            int n = modes.length;
            int n2 = 0;
            while (n2 < n) {
                String mode = stringArray[n2];
                if (LaunchManager.getInstance().validate(node.getLaunchConfiguration(), mode)) {
                    ILaunchMode launchMode = DebugPlugin.getDefault().getLaunchManager().getLaunchMode(mode);
                    modeLabels.add(launchMode.getLabel());
                    if (mode.equals("debug")) {
                        defaultIndex = modeLabels.size() - 1;
                    }
                }
                ++n2;
            }
            if (modeLabels.size() >= 1) {
                modeLabels.add(IDialogConstants.CANCEL_LABEL);
                OptionalMessageDialog dialog = new OptionalMessageDialog(UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.LaunchDialogHandler_dialog_title, null, NLS.bind((String)Messages.LaunchDialogHandler_dialog_message, (Object)node.getLaunchConfigurationType().getName(), (Object)node.getLaunchConfiguration().getName()), 3, modeLabels.toArray(new String[modeLabels.size()]), defaultIndex, null, null);
                int result = dialog.open();
                if (result >= 256) {
                    DebugUITools.launch((ILaunchConfiguration)node.getLaunchConfiguration(), (String)modes[result - 256]);
                }
            }
        }
    }
}

