/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.processes;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.utils.StatusHelper;

public abstract class ProcessLauncher
implements Runnable {
    private ICallback callback;
    private IProgressMonitor progress;
    private Throwable error;

    public ProcessLauncher(IProgressMonitor progress, ICallback callback, int ticksToUse) {
        this.callback = callback;
        this.progress = progress != null ? new SubProgressMonitor(progress, ticksToUse) : new NullProgressMonitor();
        this.setError(null);
    }

    public Throwable getError() {
        return this.error;
    }

    public void setError(Throwable error) {
        this.error = error;
    }

    protected void progressBeginTask(String taskName, int ticks) throws OperationCanceledException {
        this.progressCancelCheck();
        this.progress.beginTask(taskName, ticks);
    }

    protected void progressCancelCheck() throws OperationCanceledException {
        if (this.progress.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected void progressWorked(int ticks) throws OperationCanceledException {
        this.progressCancelCheck();
        this.progress.worked(ticks);
    }

    protected void progressSubtask(String subTask) throws OperationCanceledException {
        this.progressCancelCheck();
        this.progress.subTask(subTask);
    }

    protected void progressDone() {
        this.progress.done();
    }

    @Override
    public final void run() {
        Throwable error;
        block10: {
            error = null;
            try {
                try {
                    this.launch();
                }
                catch (Throwable throwable) {
                    error = throwable;
                    if (error == null) {
                        error = this.getError();
                    }
                    break block10;
                }
            }
            catch (Throwable throwable) {
                if (error == null) {
                    error = this.getError();
                }
                throw throwable;
            }
            if (error == null) {
                error = this.getError();
            }
        }
        if (this.callback != null) {
            this.callback.done(this, StatusHelper.getStatus(error));
        }
        if (error instanceof Error && !(error instanceof AssertionError)) {
            throw (Error)error;
        }
    }

    public abstract void launch() throws Throwable;
}

