/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.callbacks;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.core.interfaces.IChannelManager;
import org.eclipse.tcf.te.tcf.filesystem.core.activator.CorePlugin;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.callbacks.CallbackBase;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.callbacks.RefreshStateDoneStat;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.exceptions.TCFFileSystemException;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;

public class RefreshStateDoneOpenChannel
extends CallbackBase
implements IChannelManager.DoneOpenChannel {
    FSTreeNode node;
    ICallback callback;

    public RefreshStateDoneOpenChannel(FSTreeNode node, ICallback callback) {
        this.node = node;
        this.callback = callback;
    }

    public void doneOpenChannel(Throwable error, IChannel channel) {
        IPeer peer = this.node.peerNode.getPeer();
        if (error != null) {
            String message = this.getErrorMessage(error);
            Status status = new Status(4, CorePlugin.getUniqueIdentifier(), message, error);
            this.invokeCallback((IStatus)status);
        } else {
            IFileSystem service = (IFileSystem)channel.getRemoteService(IFileSystem.class);
            if (service != null) {
                String path = this.node.getLocation(true);
                service.stat(path, (IFileSystem.DoneStat)new RefreshStateDoneStat(this.node, channel, this.callback));
            } else {
                Tcf.getChannelManager().closeChannel(channel);
                String message = NLS.bind((String)Messages.Operation_NoFileSystemError, (Object)peer.getID());
                Status status = new Status(4, CorePlugin.getUniqueIdentifier(), message, (Throwable)new TCFFileSystemException(message));
                this.invokeCallback((IStatus)status);
            }
        }
    }

    private void invokeCallback(IStatus status) {
        if (this.callback != null) {
            this.callback.done((Object)this, status);
        }
    }
}

