/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.JobExecutor;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpRename;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.handlers.RenameCallback;
import org.eclipse.tcf.te.tcf.filesystem.ui.nls.Messages;
import org.eclipse.tcf.te.ui.dialogs.RenameDialog;
import org.eclipse.ui.handlers.HandlerUtil;

public class RenameFilesHandler
extends AbstractHandler {
    private static TreeViewer currentViewer;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection sel = (IStructuredSelection)HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (!sel.isEmpty()) {
            FSTreeNode node = (FSTreeNode)sel.getFirstElement();
            boolean inPlaceEditor = UIPlugin.isInPlaceEditor();
            if (inPlaceEditor) {
                Control control;
                if (currentViewer != null && !(control = currentViewer.getControl()).isDisposed()) {
                    currentViewer.editElement((Object)node, 0);
                }
            } else {
                Shell shell = HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
                RenameDialog dialog = this.createRenameDialog(shell, node);
                int ok = dialog.open();
                if (ok == 0) {
                    String newName = dialog.getNewName();
                    JobExecutor executor = new JobExecutor((ICallback)new RenameCallback());
                    executor.execute((IOperation)new OpRename(node, newName));
                }
            }
        }
        return null;
    }

    private RenameDialog createRenameDialog(Shell shell, FSTreeNode node) {
        String[] names = this.getUsedNames(node);
        String title = node.isFile() ? Messages.RenameFilesHandler_TitleRenameFile : (node.isDirectory() ? Messages.RenameFilesHandler_TitleRenameFolder : Messages.RenameFilesHandler_TitleRename);
        String formatRegex = node.isWindowsNode() ? "[^(\\?|\\\\|/|:|\\*|<|>|\\|)]+" : "[^/]+";
        String error = node.isWindowsNode() ? Messages.FSRenamingAssistant_WinIllegalCharacters : Messages.FSRenamingAssistant_UnixIllegalCharacters;
        String prompt = Messages.RenameFilesHandler_RenamePromptMessage;
        String usedError = Messages.FSRenamingAssistant_NameAlreadyExists;
        String label = Messages.RenameFilesHandler_PromptNewName;
        return new RenameDialog(shell, title, prompt, usedError, error, label, node.name, formatRegex, names, null);
    }

    private String[] getUsedNames(FSTreeNode folder) {
        ArrayList<String> usedNames = new ArrayList<String>();
        List nodes = folder.getParent().getChildren();
        for (FSTreeNode node : nodes) {
            usedNames.add(node.name);
        }
        return usedNames.toArray(new String[usedNames.size()]);
    }

    public static void setCurrentViewer(TreeViewer viewer) {
        currentViewer = viewer;
    }
}

