/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.operations;

import java.util.List;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.OpClipboard;
import org.eclipse.tcf.te.tcf.filesystem.core.model.FSTreeNode;
import org.eclipse.ui.PlatformUI;

public class FsClipboard
extends OpClipboard {
    private Clipboard clipboard = new Clipboard(PlatformUI.getWorkbench().getDisplay());

    public void cutFiles(List<FSTreeNode> files) {
        super.cutFiles(files);
        this.clearSystemClipboard();
    }

    public void copyFiles(List<FSTreeNode> files) {
        super.copyFiles(files);
        this.clearSystemClipboard();
    }

    public void clear() {
        super.clear();
        this.clearSystemClipboard();
    }

    void clearSystemClipboard() {
        if (Display.getCurrent() != null) {
            this.clipboard.clearContents();
        } else {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    FsClipboard.this.clearSystemClipboard();
                }
            });
        }
    }

    public void dispose() {
        if (Display.getCurrent() != null) {
            if (!this.clipboard.isDisposed()) {
                try {
                    this.clipboard.dispose();
                }
                catch (SWTException sWTException) {}
            }
        } else {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    FsClipboard.this.dispose();
                }
            });
        }
    }

    public Clipboard getSystemClipboard() {
        return this.clipboard;
    }
}

