/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.launch.core.steps.iterators;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.tcf.te.launch.core.persistence.filetransfer.FileTransfersPersistenceDelegate;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.services.interfaces.filetransfer.IFileTransferItem;
import org.eclipse.tcf.te.runtime.stepper.StepperAttributeUtil;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IFullQualifiedId;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepContext;
import org.eclipse.tcf.te.tcf.launch.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.launch.core.steps.iterators.AbstractTcfLaunchStepGroupIterator;

public class FileTransferIterator
extends AbstractTcfLaunchStepGroupIterator {
    private IFileTransferItem[] items = null;
    private int iteration = -1;

    public void initialize(IStepContext context, IPropertiesContainer data, IFullQualifiedId fullQualifiedId, IProgressMonitor monitor) {
        this.items = FileTransfersPersistenceDelegate.getFileTransfers((ILaunchConfiguration)this.getLaunchConfiguration(context));
        this.iteration = 0;
    }

    public int getNumIterations() {
        return this.items != null ? this.items.length : 0;
    }

    public boolean hasNext(IStepContext context, IPropertiesContainer data, IFullQualifiedId fullQualifiedId, IProgressMonitor monitor) {
        return this.iteration < this.getNumIterations();
    }

    public void next(IStepContext context, IPropertiesContainer data, IFullQualifiedId fullQualifiedId, IProgressMonitor monitor) throws CoreException {
        if (this.iteration < 0) {
            throw new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), "iterator not initialized"));
        }
        if (this.iteration >= this.getNumIterations()) {
            throw new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), "no more iterations"));
        }
        StepperAttributeUtil.setProperty((String)"org.eclipse.tcf.te.launch.file_transfer", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data, (Object)this.items[this.iteration++]);
    }
}

