/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.model;

import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorModel;
import org.eclipse.tcf.te.tcf.locator.nodes.LocatorModel;

public final class Model {
    static volatile ILocatorModel locatorModel;

    public static ILocatorModel getModel() {
        return Model.getModel(false);
    }

    public static ILocatorModel getModel(boolean shutdown) {
        if (locatorModel == null && !shutdown) {
            if (Protocol.isDispatchThread()) {
                Model.initialize();
            } else {
                Protocol.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Model.initialize();
                    }
                });
            }
        }
        return locatorModel;
    }

    protected static void initialize() {
        Assert.isTrue((boolean)Protocol.isDispatchThread());
        if (locatorModel != null) {
            return;
        }
        locatorModel = new LocatorModel();
        locatorModel.startScanner(5000L, 120000L);
    }

    public static void dispose() {
        if (locatorModel == null) {
            return;
        }
        if (Protocol.isDispatchThread()) {
            locatorModel.dispose();
        } else {
            Protocol.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    locatorModel.dispose();
                }
            });
        }
        locatorModel = null;
    }
}

