/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.ILocator;
import org.eclipse.tcf.te.runtime.utils.net.IPAddressUtil;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.core.listeners.interfaces.IChannelStateChangeListener;
import org.eclipse.tcf.te.tcf.locator.Scanner;
import org.eclipse.tcf.te.tcf.locator.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.locator.interfaces.IModelListener;
import org.eclipse.tcf.te.tcf.locator.interfaces.IScanner;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelLookupService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelPeerNodeQueryService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelRefreshService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelUpdateService;
import org.eclipse.tcf.te.tcf.locator.listener.ChannelStateChangeListener;
import org.eclipse.tcf.te.tcf.locator.listener.LocatorListener;
import org.eclipse.tcf.te.tcf.locator.services.LocatorModelLookupService;
import org.eclipse.tcf.te.tcf.locator.services.LocatorModelPeerNodeQueryService;
import org.eclipse.tcf.te.tcf.locator.services.LocatorModelRefreshService;
import org.eclipse.tcf.te.tcf.locator.services.LocatorModelUpdateService;

public class LocatorModel
extends PlatformObject
implements ILocatorModel {
    private final UUID uniqueId = UUID.randomUUID();
    private boolean disposed = false;
    private final Map<String, IPeerModel> peers = new HashMap<String, IPeerModel>();
    private final Map<String, List<IPeerModel>> peerChildren = new HashMap<String, List<IPeerModel>>();
    private IScanner scanner = null;
    private ILocator.LocatorListener locatorListener = null;
    private IChannelStateChangeListener channelStateChangeListener = null;
    private final List<IModelListener> modelListener = new ArrayList<IModelListener>();
    private final ILocatorModelRefreshService refreshService = new LocatorModelRefreshService(this);
    private final ILocatorModelLookupService lookupService = new LocatorModelLookupService(this);
    private final ILocatorModelUpdateService updateService = new LocatorModelUpdateService(this);
    private final ILocatorModelPeerNodeQueryService queryService = new LocatorModelPeerNodeQueryService(this);

    public LocatorModel() {
        this.channelStateChangeListener = new ChannelStateChangeListener(this);
        Tcf.addChannelStateChangeListener((IChannelStateChangeListener)this.channelStateChangeListener);
    }

    @Override
    public void addListener(IModelListener listener) {
        Assert.isNotNull((Object)listener);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorModel")) {
            CoreBundleActivator.getTraceHandler().trace("LocatorModel.addListener( " + listener + " )", "trace/locatorModel", (Object)this);
        }
        if (!this.modelListener.contains(listener)) {
            this.modelListener.add(listener);
        }
    }

    @Override
    public void removeListener(IModelListener listener) {
        Assert.isNotNull((Object)listener);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorModel")) {
            CoreBundleActivator.getTraceHandler().trace("LocatorModel.removeListener( " + listener + " )", "trace/locatorModel", (Object)this);
        }
        this.modelListener.remove(listener);
    }

    @Override
    public IModelListener[] getListener() {
        return this.modelListener.toArray(new IModelListener[this.modelListener.size()]);
    }

    @Override
    public void dispose() {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorModel")) {
            CoreBundleActivator.getTraceHandler().trace("LocatorModel.dispose()", "trace/locatorModel", (Object)this);
        }
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        final IModelListener[] listeners = this.getListener();
        if (listeners.length > 0) {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    IModelListener[] iModelListenerArray = listeners;
                    int n = listeners.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IModelListener listener = iModelListenerArray[n2];
                        listener.locatorModelDisposed(LocatorModel.this);
                        ++n2;
                    }
                }
            });
        }
        this.modelListener.clear();
        if (this.locatorListener != null) {
            Protocol.getLocator().removeListener(this.locatorListener);
            this.locatorListener = null;
        }
        if (this.channelStateChangeListener != null) {
            Tcf.removeChannelStateChangeListener((IChannelStateChangeListener)this.channelStateChangeListener);
            this.channelStateChangeListener = null;
        }
        if (this.scanner != null) {
            this.stopScanner();
            this.scanner = null;
        }
        this.peers.clear();
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public IPeerModel[] getPeers() {
        return this.peers.values().toArray(new IPeerModel[this.peers.values().size()]);
    }

    @Override
    public List<IPeerModel> getChildren(String parentPeerID) {
        List<IPeerModel> children;
        Assert.isNotNull((Object)parentPeerID);
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorModel")) {
            CoreBundleActivator.getTraceHandler().trace("LocatorModel.getChildren( " + parentPeerID + " )", "trace/locatorModel", (Object)this);
        }
        if ((children = this.peerChildren.get(parentPeerID)) == null) {
            children = Collections.emptyList();
        }
        return Collections.unmodifiableList(children);
    }

    @Override
    public void setChildren(String parentPeerID, List<IPeerModel> children) {
        Assert.isNotNull((Object)parentPeerID);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorModel")) {
            CoreBundleActivator.getTraceHandler().trace("LocatorModel.setChildren( " + parentPeerID + ", " + children + " )", "trace/locatorModel", (Object)this);
        }
        if (children == null || children.size() == 0) {
            this.peerChildren.remove(parentPeerID);
        } else {
            this.peerChildren.put(parentPeerID, new ArrayList<IPeerModel>(children));
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isAssignableFrom(ILocator.LocatorListener.class)) {
            return this.locatorListener;
        }
        if (adapter.isAssignableFrom(IScanner.class)) {
            return this.scanner;
        }
        if (adapter.isAssignableFrom(ILocatorModelRefreshService.class)) {
            return this.refreshService;
        }
        if (adapter.isAssignableFrom(ILocatorModelLookupService.class)) {
            return this.lookupService;
        }
        if (adapter.isAssignableFrom(ILocatorModelUpdateService.class)) {
            return this.updateService;
        }
        if (adapter.isAssignableFrom(ILocatorModelPeerNodeQueryService.class)) {
            return this.queryService;
        }
        if (adapter.isAssignableFrom(Map.class)) {
            return this.peers;
        }
        return super.getAdapter(adapter);
    }

    public int hashCode() {
        return this.uniqueId.hashCode();
    }

    public final boolean equals(Object obj) {
        if (obj instanceof LocatorModel) {
            return this.uniqueId.equals(((LocatorModel)obj).uniqueId);
        }
        return super.equals(obj);
    }

    @Override
    public <V extends ILocatorModelService> V getService(Class<V> serviceInterface) {
        Assert.isNotNull(serviceInterface);
        return (V)((ILocatorModelService)this.getAdapter(serviceInterface));
    }

    public void checkLocatorListener() {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)Protocol.getLocator());
        if (this.locatorListener == null) {
            this.locatorListener = this.doCreateLocatorListener(this);
            Protocol.getLocator().addListener(this.locatorListener);
        }
    }

    protected ILocator.LocatorListener doCreateLocatorListener(ILocatorModel model) {
        Assert.isNotNull((Object)model);
        return new LocatorListener(model);
    }

    @Override
    public IScanner getScanner() {
        if (this.scanner == null) {
            this.scanner = new Scanner(this);
        }
        return this.scanner;
    }

    @Override
    public void startScanner(long delay, long schedule) {
        IScanner scanner;
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorModel")) {
            CoreBundleActivator.getTraceHandler().trace("LocatorModel.startScanner( " + delay + ", " + schedule + " )", "trace/locatorModel", (Object)this);
        }
        if ((scanner = this.getScanner()) != null) {
            HashMap<String, Object> config = new HashMap<String, Object>(scanner.getConfiguration());
            config.put("schedule", schedule);
            scanner.setConfiguration(config);
        }
        if (scanner instanceof Job) {
            Job job = (Job)scanner;
            job.setSystem(true);
            job.setPriority(50);
            job.schedule(delay);
        }
    }

    @Override
    public void stopScanner() {
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorModel")) {
            CoreBundleActivator.getTraceHandler().trace("LocatorModel.stopScanner()", "trace/locatorModel", (Object)this);
        }
        if (this.scanner != null) {
            this.scanner.terminate();
            this.scanner = null;
        }
    }

    @Override
    public IPeerModel validatePeerNodeForAdd(IPeerModel node) {
        Assert.isNotNull((Object)node);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        IPeer peer = node.getPeer();
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorModel")) {
            CoreBundleActivator.getTraceHandler().trace("LocatorModel.validatePeerNodeForAdd( " + (peer != null ? peer.getID() : null) + " )", "trace/locatorModel", (Object)this);
        }
        IPeerModel result = node;
        boolean isFilterByAgentId = Platform.getPreferencesService().getBoolean(CoreBundleActivator.getUniqueIdentifier(), "te.tcf.locator.core.model.filter.agentid", false, null);
        if (isFilterByAgentId) {
            IPeerModel[] previousNodes;
            String agentId = peer.getAgentID();
            IPeerModel[] iPeerModelArray = previousNodes = agentId != null ? this.getService(ILocatorModelLookupService.class).lkupPeerModelByAgentId(agentId) : new IPeerModel[]{};
            if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorModel")) {
                CoreBundleActivator.getTraceHandler().trace("LocatorModel.validatePeerNodeForAdd: agentId=" + agentId + ", Matching peer nodes " + (previousNodes.length > 0 ? "found (" + previousNodes.length + ")" : "not found --> DONE"), "trace/locatorModel", (Object)this);
            }
            IPeerModel[] iPeerModelArray2 = previousNodes;
            int n = previousNodes.length;
            int n2 = 0;
            while (n2 < n) {
                IPeerModel previousNode = iPeerModelArray2[n2];
                IPeer previousPeer = previousNode.getPeer();
                if (previousPeer != null) {
                    String previousPeerPort;
                    String loopback = IPAddressUtil.getInstance().getIPv4LoopbackAddress();
                    String canonical = IPAddressUtil.getInstance().getCanonicalAddress();
                    String peerIP = (String)peer.getAttributes().get("Host");
                    String previousPeerIP = (String)previousPeer.getAttributes().get("Host");
                    String peerPort = (String)peer.getAttributes().get("Port");
                    if (peerPort == null || "".equals(peerPort)) {
                        peerPort = "1534";
                    }
                    if ((previousPeerPort = (String)previousPeer.getAttributes().get("Port")) == null || "".equals(previousPeerPort)) {
                        previousPeerPort = "1534";
                    }
                    if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorModel")) {
                        CoreBundleActivator.getTraceHandler().trace("LocatorModel.validatePeerNodeForAdd: loopback=" + loopback + ", canonical=" + canonical + ", peerIP=" + peerIP + ", previousPeerIP=" + previousPeerIP + ", peerPort=" + peerPort + ", previousPeerPort=" + previousPeerPort, "trace/locatorModel", (Object)this);
                    }
                    if (peerPort.equals(previousPeerPort)) {
                        if (loopback != null && loopback.equals(peerIP) && !loopback.equals(previousPeerIP)) {
                            this.peers.remove(previousNode.getPeerId());
                            this.fireListener(previousNode, false);
                            if (!CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorModel")) break;
                            CoreBundleActivator.getTraceHandler().trace("LocatorModel.validatePeerNodeForAdd: Previous peer node replaced (loopback overwrite)", "trace/locatorModel", (Object)this);
                            break;
                        }
                        if (!(canonical == null || !canonical.equals(peerIP) || canonical.equals(previousPeerIP) || loopback != null && loopback.equals(previousPeerIP))) {
                            this.peers.remove(previousNode.getPeerId());
                            this.fireListener(previousNode, false);
                            if (!CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorModel")) break;
                            CoreBundleActivator.getTraceHandler().trace("LocatorModel.validatePeerNodeForAdd: Previous peer node replaced (canonical overwrite)", "trace/locatorModel", (Object)this);
                            break;
                        }
                        result = null;
                        if (!CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorModel")) break;
                        CoreBundleActivator.getTraceHandler().trace("LocatorModel.validatePeerNodeForAdd: Previous peer node kept, new peer node dropped", "trace/locatorModel", (Object)this);
                        break;
                    }
                    if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorModel")) {
                        CoreBundleActivator.getTraceHandler().trace("LocatorModel.validatePeerNodeForAdd: Previous peer node kept, new peer node added (Port mismatch)", "trace/locatorModel", (Object)this);
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    @Override
    public IPeerModel validateChildPeerNodeForAdd(IPeerModel node) {
        IPeerModel parent;
        Assert.isNotNull((Object)node);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorModel")) {
            CoreBundleActivator.getTraceHandler().trace("LocatorModel.validateChildPeerNodeForAdd( " + node.getPeerId() + " )", "trace/locatorModel", (Object)this);
        }
        if ((parent = (IPeerModel)node.getParent(IPeerModel.class)) == null) {
            return null;
        }
        return this.validateChildPeerNodeForAdd(parent, node);
    }

    protected IPeerModel validateChildPeerNodeForAdd(IPeerModel parent, IPeerModel node) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)node);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorModel")) {
            CoreBundleActivator.getTraceHandler().trace("LocatorModel.validateChildPeerNodeForAdd( " + parent.getPeerId() + ", " + node.getPeerId() + " )", "trace/locatorModel", (Object)this);
        }
        if (this.doValidateChildPeerNodeForAdd(parent, node) == null) {
            return null;
        }
        if (parent.getParent(IPeerModel.class) != null) {
            IPeerModel[] children;
            IPeerModel parentParentNode = (IPeerModel)parent.getParent(IPeerModel.class);
            if (this.doValidateChildPeerNodeForAdd(parentParentNode, node) == null) {
                return null;
            }
            List<IPeerModel> childrenList = this.getChildren(parentParentNode.getPeerId());
            IPeerModel[] iPeerModelArray = children = childrenList.toArray(new IPeerModel[childrenList.size()]);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IPeerModel parentParentChild = iPeerModelArray[n2];
                if (node.equals(parentParentChild) || parent.equals(parentParentChild)) {
                    return null;
                }
                if (this.doValidateChildPeerNodeForAdd(parentParentChild, node) == null) {
                    return null;
                }
                ++n2;
            }
        }
        return node;
    }

    protected IPeerModel doValidateChildPeerNodeForAdd(IPeerModel parent, IPeerModel node) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)node);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled(0, "trace/locatorModel")) {
            CoreBundleActivator.getTraceHandler().trace("LocatorModel.doValidateChildPeerNodeForAdd( " + parent.getPeerId() + ", " + node.getPeerId() + " )", "trace/locatorModel", (Object)this);
        }
        if (this.getService(ILocatorModelLookupService.class).lkupPeerModelById(node.getPeerId()) != null) {
            return null;
        }
        IPeer peer = node.getPeer();
        String parentAgentID = parent.getPeer().getAgentID();
        if (parentAgentID != null && parentAgentID.equals(peer.getAgentID())) {
            return null;
        }
        if (peer.getAttributes().get("Host") != null && IPAddressUtil.getInstance().isLocalHost((String)peer.getAttributes().get("Host"))) {
            return null;
        }
        Map parentPeerAttributes = parent.getPeer().getAttributes();
        if (parentPeerAttributes.get("Host") != null && ((String)parentPeerAttributes.get("Host")).equals(peer.getAttributes().get("Host"))) {
            String port;
            String parentPort = (String)parentPeerAttributes.get("Port");
            if (parentPort == null) {
                parentPort = "1534";
            }
            if ((port = (String)peer.getAttributes().get("Port")) == null) {
                port = "1534";
            }
            if (parentPort.equals(port)) {
                return null;
            }
        }
        return node;
    }

    protected void fireListener(final IPeerModel peer, final boolean added) {
        Assert.isNotNull((Object)peer);
        final IModelListener[] listeners = this.getListener();
        if (listeners.length > 0) {
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    IModelListener[] iModelListenerArray = listeners;
                    int n = listeners.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IModelListener listener = iModelListenerArray[n2];
                        listener.locatorModelChanged(LocatorModel.this, peer, added);
                        ++n2;
                    }
                }
            });
        }
    }
}

