/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.core.callbacks;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IProcesses;
import org.eclipse.tcf.services.ISysMonitor;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.processes.core.callbacks.CallbackMonitor;
import org.eclipse.tcf.te.tcf.processes.core.callbacks.RefreshDoneGetChildren;
import org.eclipse.tcf.te.tcf.processes.core.model.ProcessTreeNode;

public class QueryDoneGetContext
implements ISysMonitor.DoneGetContext,
IProcesses.DoneGetContext {
    String contextId;
    IChannel channel;
    ProcessTreeNode parentNode;
    CallbackMonitor monitor;
    ProcessTreeNode childNode;
    IProcesses.ProcessContext pContext;
    ISysMonitor.SysMonitorContext sContext;
    volatile boolean sysMonitorDone;
    volatile boolean processesDone;

    public QueryDoneGetContext(String contextId, IChannel channel, CallbackMonitor monitor, ProcessTreeNode parentNode) {
        this.contextId = contextId;
        this.channel = channel;
        this.parentNode = parentNode;
        this.monitor = monitor;
        this.sysMonitorDone = false;
        this.processesDone = false;
    }

    public void doneGetContext(IToken token, Exception error, ISysMonitor.SysMonitorContext context) {
        if (error == null && context != null) {
            this.sContext = context;
        }
        this.sysMonitorDone = true;
        this.refreshChildren();
    }

    private void refreshChildren() {
        if (this.sysMonitorDone && this.processesDone) {
            if (this.sContext != null) {
                this.childNode = new ProcessTreeNode(this.parentNode, this.sContext);
                this.childNode.setProcessContext(this.pContext);
            } else if (this.pContext != null) {
                this.childNode = new ProcessTreeNode(this.parentNode, this.pContext);
                this.childNode.setSysMonitorContext(this.sContext);
            }
            if (this.childNode != null) {
                this.parentNode.addChild(this.childNode);
                this.childNode.queryStarted();
                ISysMonitor service = (ISysMonitor)this.channel.getRemoteService(ISysMonitor.class);
                if (service != null) {
                    ConcurrentLinkedQueue<ProcessTreeNode> queue = new ConcurrentLinkedQueue<ProcessTreeNode>();
                    service.getChildren(this.childNode.id, (ISysMonitor.DoneGetChildren)new RefreshDoneGetChildren((ICallback)new Callback(){

                        protected void internalDone(Object caller, IStatus status) {
                            QueryDoneGetContext.this.doCallback(caller, status);
                        }
                    }, queue, this.channel, service, this.childNode));
                }
            } else {
                this.doCallback(this, Status.OK_STATUS);
            }
        }
    }

    public void doneGetContext(IToken token, Exception error, IProcesses.ProcessContext context) {
        if (error == null && context != null) {
            this.pContext = context;
        }
        this.processesDone = true;
        this.refreshChildren();
    }

    protected void doCallback(Object caller, IStatus status) {
        this.monitor.unlock(this.contextId, status);
    }
}

