/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.controls;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tcf.te.runtime.interfaces.IDisposable;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.ui.dialogs.NameValuePairDialog;
import org.eclipse.tcf.te.ui.forms.parts.TablePart;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;
import org.eclipse.tcf.te.ui.tables.TableViewerComparator;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PeerAttributesTablePart
extends TablePart
implements IDisposable {
    final List<TableNode> nodes = new ArrayList<TableNode>();
    private List<String> bannedNames;
    boolean readOnly;

    public PeerAttributesTablePart() {
        super(new String[]{Messages.PeerAttributesTablePart_button_new, Messages.PeerAttributesTablePart_button_edit, Messages.PeerAttributesTablePart_button_remove});
    }

    public void dispose() {
    }

    protected void configureTableViewer(final TableViewer viewer) {
        super.configureTableViewer(viewer);
        if (viewer != null && viewer.getTable() != null && !viewer.getTable().isDisposed()) {
            Table table = viewer.getTable();
            new TableColumn(table, 0).setText(Messages.PeerAttributesTablePart_column_name);
            new TableColumn(table, 0).setText(Messages.PeerAttributesTablePart_column_value);
            TableLayout tableLayout = new TableLayout();
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40, true));
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(60, true));
            table.setLayout((Layout)tableLayout);
            table.setHeaderVisible(true);
            table.setLinesVisible(true);
            viewer.setColumnProperties(new String[]{Messages.PeerAttributesTablePart_column_name, Messages.PeerAttributesTablePart_column_value});
            CellEditor[] cellEditors = new CellEditor[viewer.getColumnProperties().length];
            cellEditors[0] = new TextCellEditor((Composite)table);
            ((Text)cellEditors[0].getControl()).setTextLimit(250);
            cellEditors[1] = new TextCellEditor((Composite)table);
            ((Text)cellEditors[1].getControl()).setTextLimit(250);
            viewer.setCellEditors(cellEditors);
            viewer.setCellModifier(new ICellModifier(){

                public boolean canModify(Object element, String property) {
                    return element instanceof TableNode && !PeerAttributesTablePart.this.readOnly;
                }

                public Object getValue(Object element, String property) {
                    String value = null;
                    if (element instanceof TableNode) {
                        if (Messages.PeerAttributesTablePart_column_name.equals(property)) {
                            value = ((TableNode)((Object)element)).name;
                        } else if (Messages.PeerAttributesTablePart_column_value.equals(property)) {
                            value = ((TableNode)((Object)element)).value;
                        }
                    }
                    return value;
                }

                public void modify(Object element, String property, Object value) {
                    if (element instanceof TableItem) {
                        element = ((TableItem)element).getData();
                    }
                    if (element instanceof TableNode) {
                        if (Messages.PeerAttributesTablePart_column_name.equals(property)) {
                            ((TableNode)((Object)element)).name = value != null ? value.toString() : "";
                        } else if (Messages.PeerAttributesTablePart_column_value.equals(property)) {
                            ((TableNode)((Object)element)).value = value != null ? value.toString() : "";
                        }
                        viewer.setInput(PeerAttributesTablePart.this.nodes);
                        PeerAttributesTablePart.this.onTableModified();
                    }
                }
            });
            viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
            viewer.setComparator((ViewerComparator)new TableViewerComparator((Viewer)viewer, (ITableLabelProvider)viewer.getLabelProvider()));
            viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    PeerAttributesTablePart.this.updateButtons();
                }
            });
        }
    }

    public void createControl(Composite parent, int style, int span, FormToolkit toolkit) {
        super.createControl(parent, style, span, toolkit);
        this.nodes.clear();
        this.getTableViewer().setInput(this.nodes);
        this.updateButtons();
    }

    protected void onButtonSelected(Button button) {
        Assert.isNotNull((Object)button);
        if (Messages.PeerAttributesTablePart_button_new.equals(button.getText())) {
            this.onNewPressed();
        } else if (Messages.PeerAttributesTablePart_button_edit.equals(button.getText())) {
            this.onEditPressed();
        } else if (Messages.PeerAttributesTablePart_button_remove.equals(button.getText())) {
            this.onRemovePressed();
        }
    }

    protected void updateButtons() {
        Object element;
        ISelection selection;
        int selectionCount = this.getTableViewer().getTable().getSelectionCount();
        SWTControlUtil.setEnabled((Control)this.getButton(Messages.PeerAttributesTablePart_button_new), (!this.readOnly ? 1 : 0) != 0);
        boolean banned = false;
        if (selectionCount == 1 && (selection = this.getTableViewer().getSelection()) instanceof IStructuredSelection && !selection.isEmpty() && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof TableNode && this.bannedNames != null) {
            banned = this.bannedNames.contains(((TableNode)((Object)element)).name);
        }
        SWTControlUtil.setEnabled((Control)this.getButton(Messages.PeerAttributesTablePart_button_edit), (selectionCount == 1 && !this.readOnly && !banned ? 1 : 0) != 0);
        SWTControlUtil.setEnabled((Control)this.getButton(Messages.PeerAttributesTablePart_button_remove), (selectionCount == 1 && !this.readOnly && !banned ? 1 : 0) != 0);
    }

    protected void onNewPressed() {
        this.doEditTableNode(null);
    }

    protected void onEditPressed() {
        ISelection selection = this.getTableViewer().getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            this.doEditTableNode((TableNode)((Object)((IStructuredSelection)selection).getFirstElement()));
        }
    }

    protected void onRemovePressed() {
        ISelection selection = this.getTableViewer().getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            TableNode node = (TableNode)((Object)((IStructuredSelection)selection).getFirstElement());
            int index = this.nodes.indexOf((Object)node);
            this.nodes.remove((Object)node);
            this.getTableViewer().setInput(this.nodes);
            if (index < this.nodes.size()) {
                this.getTableViewer().setSelection((ISelection)new StructuredSelection((Object)this.nodes.get(index)));
            }
            this.updateButtons();
            this.onTableModified();
        }
    }

    protected void doEditTableNode(TableNode node) {
        boolean addMode = node == null;
        String name = node != null ? node.name : "";
        String value = node != null ? node.value : "";
        HashSet<String> usedNames = new HashSet<String>(PeerAttributesTablePart.convertList2Map(this.nodes).keySet());
        if (this.bannedNames != null) {
            for (String bannedName : this.bannedNames) {
                usedNames.add(bannedName);
            }
        }
        usedNames.remove(name);
        String dialogTitle = addMode ? Messages.PeerAttributesTablePart_add_dialogTitle : Messages.PeerAttributesTablePart_edit_dialogTitle;
        String title = addMode ? Messages.PeerAttributesTablePart_add_title : Messages.PeerAttributesTablePart_edit_title;
        String message = addMode ? Messages.PeerAttributesTablePart_add_message : Messages.PeerAttributesTablePart_edit_message;
        NameValuePairDialog dialog = new NameValuePairDialog(this.getViewer().getControl().getShell(), dialogTitle, title, message, new String[]{Messages.PeerAttributesTablePart_column_name, Messages.PeerAttributesTablePart_column_value}, new String[]{name, value}, usedNames);
        if (dialog.open() == 0) {
            String[] pair = dialog.getNameValuePair();
            if (addMode) {
                node = new TableNode();
                this.nodes.add(node);
            }
            Assert.isNotNull((Object)((Object)node));
            node.name = pair[0];
            node.value = pair[1];
            this.getTableViewer().setInput(this.nodes);
            this.getTableViewer().setSelection((ISelection)new StructuredSelection((Object)node));
            this.onTableModified();
        }
    }

    protected void onTableModified() {
    }

    private static Map<String, String> convertList2Map(List<TableNode> list) {
        Assert.isNotNull(list);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (TableNode node : list) {
            map.put(node.name, node.value);
        }
        return map;
    }

    public Map<String, String> getAttributes() {
        return PeerAttributesTablePart.convertList2Map(this.nodes);
    }

    public void setAttributes(Map<String, String> attributes) {
        this.nodes.clear();
        if (attributes != null && !attributes.isEmpty()) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                TableNode node = new TableNode();
                node.name = entry.getKey();
                node.value = entry.getValue();
                this.nodes.add(node);
            }
        }
        this.getTableViewer().setInput(this.nodes);
    }

    public final void setBannedNames(String[] bannedNames) {
        this.bannedNames = bannedNames != null ? Arrays.asList(bannedNames) : null;
    }

    public final String[] getBannedNames() {
        return this.bannedNames != null ? this.bannedNames.toArray(new String[this.bannedNames.size()]) : new String[]{};
    }

    public final void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.updateButtons();
    }

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    protected static class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String text = null;
            if (element instanceof TableNode) {
                switch (columnIndex) {
                    case 0: {
                        text = ((TableNode)((Object)element)).name;
                        break;
                    }
                    case 1: {
                        text = ((TableNode)((Object)element)).value;
                    }
                }
            }
            return text != null ? text : "";
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }
    }

    protected static class TableNode
    extends PlatformObject {
        public String name = "";
        public String value = "";

        protected TableNode() {
        }
    }
}

