/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelLookupService;
import org.eclipse.tcf.te.tcf.locator.model.Model;
import org.eclipse.tcf.te.tcf.ui.help.IContextHelpIds;
import org.eclipse.tcf.te.tcf.ui.navigator.LabelProviderDelegate;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.ui.jface.dialogs.CustomTitleAreaDialog;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;

public class AgentSelectionDialog
extends CustomTitleAreaDialog {
    final String[] services;
    private TableViewer viewer;
    private ISelection selection;

    public AgentSelectionDialog(String[] services) {
        this(null, services);
    }

    public AgentSelectionDialog(Shell parent, String[] services) {
        super(parent, IContextHelpIds.AGENT_SELECTION_DIALOG);
        this.services = services != null && services.length > 0 ? services : null;
    }

    protected boolean isResizable() {
        return true;
    }

    protected boolean supportsMultiSelection() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite top = (Composite)super.createDialogArea(parent);
        this.setDialogTitle(this.getDialogTitle());
        this.setTitle(this.getTitle());
        this.setDefaultMessage(this.getDefaultMessage(), 0);
        this.viewer = new TableViewer(top, (this.supportsMultiSelection() ? 2 : 4) | 0x800);
        Table table = this.viewer.getTable();
        new TableColumn(table, 16384);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        table.setLayout((Layout)tableLayout);
        GridData layoutData = new GridData(4, 4, true, true);
        table.setLayoutData((Object)layoutData);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        LabelProviderDelegate labelProvider = new LabelProviderDelegate(){

            @Override
            public Image decorateImage(Image image, Object element) {
                return image;
            }
        };
        this.viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)labelProvider, (ILabelDecorator)labelProvider));
        this.configureTableViewer(this.viewer);
        ILocatorModelLookupService service = (ILocatorModelLookupService)this.getModel().getService(ILocatorModelLookupService.class);
        ArrayList<IPeerModel> nodes = new ArrayList<IPeerModel>();
        if (service != null) {
            nodes.addAll(Arrays.asList(service.lkupPeerModelBySupportedServices(null, this.services)));
        }
        this.viewer.setInput(nodes.size() > 0 ? nodes.toArray(new IPeerModel[nodes.size()]) : null);
        return top;
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonBar = super.createButtonBar(parent);
        Button okButton = this.getButton(0);
        SWTControlUtil.setEnabled((Control)okButton, (this.viewer.getInput() != null && ((IPeerModel[])this.viewer.getInput()).length > 0 ? 1 : 0) != 0);
        return buttonBar;
    }

    protected void configureTableViewer(TableViewer viewer) {
        Assert.isNotNull((Object)viewer);
    }

    protected String getDialogTitle() {
        return Messages.AgentSelectionDialog_dialogTitle;
    }

    protected String getTitle() {
        return Messages.AgentSelectionDialog_title;
    }

    protected String getDefaultMessage() {
        return Messages.AgentSelectionDialog_message;
    }

    protected ILocatorModel getModel() {
        return Model.getModel();
    }

    public ISelection getSelection() {
        return this.selection;
    }

    protected void okPressed() {
        this.selection = this.viewer.getSelection();
        super.okPressed();
    }

    protected void cancelPressed() {
        this.selection = null;
        super.cancelPressed();
    }
}

