/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.editor.sections;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tcf.core.TransientPeer;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IURIPersistenceService;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.locator.ScannerRunnable;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelUpdateService;
import org.eclipse.tcf.te.tcf.locator.nodes.PeerRedirector;
import org.eclipse.tcf.te.tcf.ui.controls.CustomTransportPanel;
import org.eclipse.tcf.te.tcf.ui.controls.PipeTransportPanel;
import org.eclipse.tcf.te.tcf.ui.controls.TcpTransportPanel;
import org.eclipse.tcf.te.tcf.ui.editor.controls.TransportSectionTypeControl;
import org.eclipse.tcf.te.tcf.ui.editor.controls.TransportSectionTypePanelControl;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.ui.controls.BaseDialogPageControl;
import org.eclipse.tcf.te.ui.controls.interfaces.IWizardConfigurationPanel;
import org.eclipse.tcf.te.ui.forms.parts.AbstractSection;
import org.eclipse.tcf.te.ui.interfaces.data.IDataExchangeNode;
import org.eclipse.tcf.te.ui.interfaces.data.IDataExchangeNode3;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;
import org.eclipse.tcf.te.ui.views.editor.pages.AbstractEditorPage;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class TransportSection
extends AbstractSection {
    private TransportSectionTypeControl transportTypeControl = null;
    TransportSectionTypePanelControl transportTypePanelControl = null;
    IPeerModel od;
    final IPropertiesContainer odc = new PropertiesContainer();
    final IPropertiesContainer wc = new PropertiesContainer();

    public TransportSection(IManagedForm form, Composite parent) {
        super(form, parent, 128);
        this.createClient(this.getSection(), form.getToolkit());
    }

    public void dispose() {
        super.dispose();
        if (this.transportTypeControl != null) {
            this.transportTypeControl.dispose();
            this.transportTypeControl = null;
        }
        if (this.transportTypePanelControl != null) {
            this.transportTypePanelControl.dispose();
            this.transportTypePanelControl = null;
        }
    }

    public Object getAdapter(Class adapter) {
        if (TransportSectionTypeControl.class.equals((Object)adapter)) {
            return this.transportTypeControl;
        }
        if (TransportSectionTypePanelControl.class.equals((Object)adapter)) {
            return this.transportTypePanelControl;
        }
        return super.getAdapter(adapter);
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        Assert.isNotNull((Object)section);
        Assert.isNotNull((Object)toolkit);
        section.setText(Messages.TransportSection_title);
        section.setDescription(Messages.TransportSection_description);
        section.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite client = this.createClientContainer((Composite)section, 2, toolkit);
        Assert.isNotNull((Object)client);
        section.setClient((Control)client);
        this.transportTypeControl = new TransportSectionTypeControl(this);
        this.transportTypeControl.setFormToolkit(toolkit);
        this.transportTypeControl.setupPanel(client);
        this.createEmptySpace(client, 2, toolkit);
        this.transportTypePanelControl = new TransportSectionTypePanelControl(this);
        TcpTransportPanel tcpTransportPanel = new TcpTransportPanel((BaseDialogPageControl)this.transportTypePanelControl);
        this.transportTypePanelControl.addConfigurationPanel("TCP", (IWizardConfigurationPanel)tcpTransportPanel);
        this.transportTypePanelControl.addConfigurationPanel("SSL", (IWizardConfigurationPanel)tcpTransportPanel);
        this.transportTypePanelControl.addConfigurationPanel("PIPE", (IWizardConfigurationPanel)new PipeTransportPanel((BaseDialogPageControl)this.transportTypePanelControl));
        this.transportTypePanelControl.addConfigurationPanel("Custom", (IWizardConfigurationPanel)new CustomTransportPanel((BaseDialogPageControl)this.transportTypePanelControl));
        this.transportTypePanelControl.setupPanel(client, this.transportTypeControl.getTransportTypes(), toolkit);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.horizontalSpan = 2;
        this.transportTypePanelControl.getPanel().setLayoutData((Object)layoutData);
        toolkit.adapt(this.transportTypePanelControl.getPanel());
        this.transportTypePanelControl.showConfigurationPanel(this.transportTypeControl.getSelectedTransportType());
        this.updateEnablement();
        this.setIsUpdating(false);
    }

    public void setActive(boolean active) {
        Object node;
        if (active && this.getManagedForm().getContainer() instanceof AbstractEditorPage && !((AbstractEditorPage)this.getManagedForm().getContainer()).isDirty() && (node = ((AbstractEditorPage)this.getManagedForm().getContainer()).getEditorInputNode()) instanceof IPeerModel) {
            this.setupData((IPeerModel)node);
        }
    }

    public void setupData(final IPeerModel node) {
        String transportType;
        this.od = node;
        this.odc.clearProperties();
        this.wc.clearProperties();
        if (node == null) {
            return;
        }
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                TransportSection.this.odc.setProperty("TransportName", (Object)node.getPeer().getTransportName());
                if (TransportSection.this.transportTypePanelControl != null) {
                    PropertiesContainer src = new PropertiesContainer();
                    Map properties = node.getPeer().getAttributes();
                    for (Map.Entry entry : properties.entrySet()) {
                        src.setProperty((String)entry.getKey(), entry.getValue());
                    }
                    String[] stringArray = TransportSection.this.transportTypePanelControl.getConfigurationPanelIds();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String id = stringArray[n2];
                        IWizardConfigurationPanel panel = TransportSection.this.transportTypePanelControl.getConfigurationPanel(id);
                        if (panel instanceof IDataExchangeNode3) {
                            ((IDataExchangeNode3)panel).copyData((IPropertiesContainer)src, TransportSection.this.odc);
                        }
                        ++n2;
                    }
                }
                TransportSection.this.wc.setProperties(TransportSection.this.odc.getProperties());
            }
        });
        if (this.transportTypeControl != null && (transportType = this.wc.getStringProperty("TransportName")) != null && !"".equals(transportType)) {
            this.transportTypeControl.setSelectedTransportType(transportType);
            if (this.transportTypePanelControl != null) {
                this.transportTypePanelControl.showConfigurationPanel(transportType);
                IWizardConfigurationPanel panel = this.transportTypePanelControl.getConfigurationPanel(transportType);
                if (panel instanceof IDataExchangeNode) {
                    ((IDataExchangeNode)panel).setupData(this.wc);
                }
            }
        }
        this.updateEnablement();
    }

    public void extractData(final IPeerModel node) {
        IWizardConfigurationPanel panel;
        if (node == null) {
            return;
        }
        final ArrayList<String> removed = new ArrayList<String>();
        Set currentKeySet = this.wc.getProperties().keySet();
        String oldTransportType = this.wc.getStringProperty("TransportName");
        if (oldTransportType != null && (panel = this.transportTypePanelControl.getConfigurationPanel(oldTransportType)) instanceof IDataExchangeNode3) {
            ((IDataExchangeNode3)panel).removeData(this.wc);
        }
        String transportType = this.transportTypeControl.getSelectedTransportType();
        this.wc.setProperty("TransportName", (Object)transportType);
        IWizardConfigurationPanel panel2 = this.transportTypePanelControl.getConfigurationPanel(transportType);
        if (panel2 instanceof IDataExchangeNode) {
            ((IDataExchangeNode)panel2).extractData(this.wc);
        }
        if (this.odc.equals(this.wc)) {
            return;
        }
        Set newKeySet = this.wc.getProperties().keySet();
        for (String key : currentKeySet) {
            if (newKeySet.contains(key)) continue;
            removed.add(key);
        }
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                IPeer oldPeer = node.getPeer();
                HashMap<String, String> attributes = new HashMap<String, String>(oldPeer.getAttributes());
                for (String key : removed) {
                    attributes.remove(key);
                }
                for (String key : TransportSection.this.wc.getProperties().keySet()) {
                    String value = TransportSection.this.wc.getStringProperty(key);
                    if (value != null) {
                        attributes.put(key, value);
                        continue;
                    }
                    attributes.remove(key);
                }
                IChannel channel = Tcf.getChannelManager().getChannel(oldPeer);
                if (channel != null) {
                    channel.close();
                }
                PeerRedirector newPeer = oldPeer instanceof PeerRedirector ? new PeerRedirector(((PeerRedirector)oldPeer).getParent(), attributes) : new TransientPeer(attributes);
                boolean changed = node.setChangeEventsEnabled(false);
                node.setProperty("instance", (Object)newPeer);
                node.setProperty("state", -1);
                node.setProperty("dns.name.transient", null);
                node.setProperty("dns.lastIP.transient", null);
                node.setProperty("dns.skip.transient", null);
                ILocatorModelUpdateService service = (ILocatorModelUpdateService)node.getModel().getService(ILocatorModelUpdateService.class);
                service.updatePeerServices(node, null, null);
                if (changed) {
                    node.setChangeEventsEnabled(true);
                }
            }
        });
    }

    public boolean isValid() {
        if (!this.isUpdating()) {
            return true;
        }
        boolean valid = super.isValid();
        if (this.transportTypeControl != null) {
            valid &= this.transportTypeControl.isValid();
            if (this.transportTypeControl.getMessageType() > this.getMessageType()) {
                this.setMessage(this.transportTypeControl.getMessage(), this.transportTypeControl.getMessageType());
            }
        }
        if (this.transportTypePanelControl != null) {
            valid &= this.transportTypePanelControl.isValid();
            if (this.transportTypePanelControl.getMessageType() > this.getMessageType()) {
                this.setMessage(this.transportTypePanelControl.getMessage(), this.transportTypePanelControl.getMessageType());
            }
        }
        return valid;
    }

    public void commit(boolean onSave) {
        boolean needsSaving = this.isDirty();
        super.commit(onSave);
        if (!onSave || !needsSaving) {
            return;
        }
        this.extractData(this.od);
        if (!this.odc.equals(this.wc)) {
            try {
                IURIPersistenceService uRIPersistenceService = (IURIPersistenceService)ServiceManager.getInstance().getService(IURIPersistenceService.class);
                if (uRIPersistenceService == null) {
                    throw new IOException("Persistence service instance unavailable.");
                }
                uRIPersistenceService.write((Object)this.od.getPeer(), null);
            }
            catch (IOException iOException) {}
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    TransportSection.this.od.fireChangeEvent("properties", null, (Object)TransportSection.this.od.getProperties());
                    TransportSection.this.od.fireChangeEvent("editor.refreshTab", (Object)Boolean.FALSE, (Object)Boolean.TRUE);
                }
            });
            ScannerRunnable runnable = new ScannerRunnable(null, this.od);
            Protocol.invokeLater((Runnable)runnable);
        }
    }

    public void dataChanged(TypedEvent e) {
        if (!this.isUpdating()) {
            return;
        }
        boolean isDirty = false;
        if (this.transportTypeControl != null) {
            IWizardConfigurationPanel panel;
            String value;
            String transportType = this.transportTypeControl.getSelectedTransportType();
            isDirty = "".equals(transportType) ? (isDirty |= (value = this.odc.getStringProperty("TransportName")) != null && !"".equals(value.trim())) : (isDirty |= !this.odc.isProperty("TransportName", (Object)transportType));
            if (this.transportTypePanelControl != null && (panel = this.transportTypePanelControl.getConfigurationPanel(transportType)) != null) {
                isDirty |= panel.dataChanged(this.odc, e);
            }
        }
        this.markDirty(isDirty);
    }

    protected void updateEnablement() {
        final Object input = this.getManagedForm().getInput();
        final AtomicBoolean isStatic = new AtomicBoolean();
        final AtomicBoolean isRemote = new AtomicBoolean();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (input instanceof IPeerModel) {
                    String value = (String)((IPeerModel)input).getPeer().getAttributes().get("static.transient");
                    isStatic.set(value != null && Boolean.parseBoolean(value.trim()));
                    value = (String)((IPeerModel)input).getPeer().getAttributes().get("remote.transient");
                    isRemote.set(value != null && Boolean.parseBoolean(value.trim()));
                }
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeAndWait((Runnable)runnable);
        }
        if (this.transportTypeControl != null) {
            IWizardConfigurationPanel panel;
            SWTControlUtil.setEnabled((Control)this.transportTypeControl.getEditFieldControl(), (isStatic.get() && !isRemote.get() ? 1 : 0) != 0);
            if (this.transportTypePanelControl != null && (panel = this.transportTypePanelControl.getConfigurationPanel(this.transportTypeControl.getSelectedTransportType())) != null) {
                panel.setEnabled(isStatic.get() && !isRemote.get());
            }
        }
    }
}

