/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.navigator.dnd;

import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.ui.views.Managers;
import org.eclipse.tcf.te.ui.views.ViewsUtil;
import org.eclipse.tcf.te.ui.views.interfaces.ICategory;
import org.eclipse.tcf.te.ui.views.interfaces.IRoot;
import org.eclipse.ui.navigator.CommonDropAdapter;

public class CommonDnD {
    public static boolean isDraggable(IStructuredSelection selection) {
        Object[] objects;
        if (selection.isEmpty()) {
            return false;
        }
        Object[] objectArray = objects = selection.toArray();
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (!CommonDnD.isDraggableObject(object)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean isDraggableObject(Object object) {
        return object instanceof IPeerModel;
    }

    public static boolean dropLocalSelection(CommonDropAdapter dropAdapter, Object target, int operations, IStructuredSelection selection) {
        if (target instanceof ICategory) {
            ICategory hovered = (ICategory)target;
            if ("org.eclipse.tcf.te.ui.views.category.favorites".equals(hovered.getId()) || "org.eclipse.tcf.te.ui.views.category.mytargets".equals(hovered.getId())) {
                for (Object element : selection) {
                    if (!CommonDnD.isDraggableObject(element)) continue;
                    Managers.getCategoryManager().add(hovered.getId(), ((IPeerModel)element).getPeerId());
                }
                ViewsUtil.refresh((String)"org.eclipse.tcf.te.ui.views.View");
            }
        } else if (target instanceof IRoot) {
            for (Object element : selection) {
                TreePath[] pathes;
                if (!CommonDnD.isDraggableObject(element)) continue;
                TreePath[] treePathArray = pathes = selection instanceof TreeSelection ? ((TreeSelection)selection).getPathsFor(element) : null;
                if (pathes == null || pathes.length <= 0) continue;
                TreePath[] treePathArray2 = pathes;
                int n = pathes.length;
                int n2 = 0;
                while (n2 < n) {
                    TreePath path = treePathArray2[n2];
                    ICategory category = null;
                    TreePath parentPath = path.getParentPath();
                    while (parentPath != null) {
                        if (parentPath.getLastSegment() instanceof ICategory) {
                            category = (ICategory)parentPath.getLastSegment();
                            break;
                        }
                        parentPath = parentPath.getParentPath();
                    }
                    if (category != null) {
                        Managers.getCategoryManager().remove(category.getId(), ((IPeerModel)element).getPeerId());
                    }
                    ++n2;
                }
            }
            ViewsUtil.refresh((String)"org.eclipse.tcf.te.ui.views.View");
        }
        return false;
    }

    public static boolean validateLocalSelectionDrop(CommonDropAdapter dropAdapter, Object target, int operation, TransferData transferType) {
        int overrideOperation = -1;
        boolean valid = false;
        if ((operation & 2) == 0) {
            overrideOperation = 2;
        }
        LocalSelectionTransfer transfer = LocalSelectionTransfer.getTransfer();
        IStructuredSelection selection = (IStructuredSelection)transfer.getSelection();
        if (target instanceof ICategory) {
            ICategory category = (ICategory)target;
            if (!"org.eclipse.tcf.te.ui.views.category.neighborhood".equals(category.getId())) {
                boolean allow = true;
                for (Object element : selection) {
                    if (!CommonDnD.isDraggableObject(element)) {
                        allow = false;
                        break;
                    }
                    if (!Managers.getCategoryManager().belongsTo(category.getId(), ((IPeerModel)element).getPeerId())) continue;
                    allow = false;
                    break;
                }
                valid = allow;
                if (("org.eclipse.tcf.te.ui.views.category.favorites".equals(category.getId()) || "org.eclipse.tcf.te.ui.views.category.mytargets".equals(category.getId())) && (operation & 4) == 0) {
                    overrideOperation = 4;
                }
            }
        } else if (target instanceof IRoot) {
            boolean allow = true;
            block1: for (Object element : selection) {
                TreePath[] pathes;
                if (!CommonDnD.isDraggableObject(element)) {
                    allow = false;
                    break;
                }
                TreePath[] treePathArray = pathes = selection instanceof TreeSelection ? ((TreeSelection)selection).getPathsFor(element) : null;
                if (pathes == null || pathes.length <= 0) continue;
                TreePath[] treePathArray2 = pathes;
                int n = pathes.length;
                int n2 = 0;
                while (n2 < n) {
                    TreePath path = treePathArray2[n2];
                    ICategory category = null;
                    TreePath parentPath = path.getParentPath();
                    while (parentPath != null) {
                        if (parentPath.getLastSegment() instanceof ICategory) {
                            category = (ICategory)parentPath.getLastSegment();
                            break;
                        }
                        parentPath = parentPath.getParentPath();
                    }
                    if (category == null || "org.eclipse.tcf.te.ui.views.category.neighborhood".equals(category.getId())) {
                        allow = false;
                        continue block1;
                    }
                    ++n2;
                }
            }
            valid = allow;
        }
        if (dropAdapter != null) {
            if (!valid) {
                dropAdapter.overrideOperation(0);
            } else if (overrideOperation != -1) {
                dropAdapter.overrideOperation(overrideOperation);
            }
        }
        return valid;
    }
}

