/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.terminals.serial.types;

import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.ui.terminals.internal.SettingsStore;
import org.eclipse.tcf.te.ui.terminals.types.AbstractConnectorType;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalConnectorExtension;
import org.eclipse.tm.internal.terminal.serial.SerialSettings;

public class SerialConnectorType
extends AbstractConnectorType {
    public ITerminalConnector createTerminalConnector(IPropertiesContainer properties) {
        Assert.isNotNull((Object)properties);
        String connectorId = properties.getStringProperty("tm.terminal.connector.id");
        String port = properties.getStringProperty("serial.device");
        String baud = properties.getStringProperty("serial.baudrate");
        String timeout = properties.getStringProperty("timeout");
        String databits = properties.getStringProperty("serial.databits");
        String stopbits = properties.getStringProperty("serial.stopbits");
        String parity = properties.getStringProperty("serial.parity");
        String flowcontrol = properties.getStringProperty("serial.flowcontrol");
        return this.createSerialConnector(connectorId, new String[]{port, baud, timeout, databits, stopbits, parity, flowcontrol}, 0);
    }

    protected ITerminalConnector createSerialConnector(String connectorId, String[] attributes, int portOffset) {
        Assert.isNotNull((Object)attributes);
        if (connectorId == null) {
            connectorId = "org.eclipse.tm.internal.terminal.serial.SerialConnector";
        }
        String port = attributes[0];
        String baud = attributes[1];
        String timeout = attributes[2];
        String databits = attributes[3];
        String stopbits = attributes[4];
        String parity = attributes[5];
        String flowcontrol = attributes[6];
        SettingsStore store = new SettingsStore();
        SerialSettings serialSettings = new SerialSettings();
        serialSettings.setSerialPort(port);
        serialSettings.setBaudRate(baud);
        serialSettings.setTimeout(timeout);
        serialSettings.setDataBits(databits);
        serialSettings.setStopBits(stopbits);
        serialSettings.setParity(parity);
        serialSettings.setFlowControl(flowcontrol);
        serialSettings.save((ISettingsStore)store);
        ITerminalConnector connector = TerminalConnectorExtension.makeTerminalConnector((String)connectorId);
        if (connector != null) {
            connector.makeSettingsPage();
            connector.load((ISettingsStore)store);
        }
        return connector;
    }
}

