/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.trees;

import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tcf.te.ui.activator.UIPlugin;
import org.eclipse.tcf.te.ui.nls.Messages;

public class Pending {
    private static final int FRAME_INTERVAL = 100;
    TreeViewer viewer;
    Display display;
    boolean animating;
    int frame;

    public Pending(TreeViewer viewer) {
        this.viewer = viewer;
        this.display = viewer.getTree().getDisplay();
        this.animating = true;
        this.frame = 0;
    }

    public void startAnimation() {
        if (Display.getCurrent() == null) {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    Pending.this.startAnimation();
                }
            });
        } else {
            this.display.timerExec(100, new Runnable(){

                @Override
                public void run() {
                    Pending.this.viewer.update((Object)Pending.this, null);
                    if (Pending.this.animating) {
                        Pending.this.startAnimation();
                    }
                }
            });
        }
    }

    public String getText() {
        return Messages.Pending_Label;
    }

    public Image getImage() {
        Image img = null;
        Image[] pendingImages = UIPlugin.getDefault().getPendingImages();
        if (pendingImages != null && pendingImages.length > 0) {
            img = pendingImages[this.frame++];
            this.frame %= pendingImages.length;
        }
        return img;
    }

    public void stopAnimation() {
        this.animating = false;
    }
}

