/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.cdt.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeStackFrame;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.WorkbenchJob;

public class EvaluationContextManager
implements IWindowListener,
IDebugContextListener {
    private static final String DEBUGGER_ACTIVE = "org.eclipse.cdt.debug.ui.debuggerActive";
    protected static EvaluationContextManager fgManager;

    protected EvaluationContextManager() {
    }

    public static void startup() {
        WorkbenchJob job = new WorkbenchJob(""){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (fgManager == null) {
                    fgManager = new EvaluationContextManager();
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                    if (window != null) {
                        fgManager.windowActivated(window);
                    }
                    workbench.addWindowListener((IWindowListener)fgManager);
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(20);
        job.setSystem(true);
        job.schedule();
    }

    public void windowActivated(IWorkbenchWindow window) {
        IDebugContextService service = DebugUITools.getDebugContextManager().getContextService(window);
        service.addDebugContextListener((IDebugContextListener)this);
        this.selectionChanged(service.getActiveContext());
    }

    public void windowDeactivated(IWorkbenchWindow window) {
        DebugUITools.getDebugContextManager().getContextService(window).removeDebugContextListener((IDebugContextListener)this);
    }

    public void windowOpened(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
    }

    public void debugContextChanged(DebugContextEvent event) {
        this.selectionChanged(event.getContext());
    }

    private void selectionChanged(ISelection selection) {
        Object element;
        IStructuredSelection ss;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && ((element = ss.getFirstElement()) instanceof TCFNodeExecContext || element instanceof TCFNodeStackFrame)) {
            System.setProperty(DEBUGGER_ACTIVE, Boolean.toString(true));
            return;
        }
        System.setProperty(DEBUGGER_ACTIVE, Boolean.toString(false));
    }
}

