/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.cdt.ui.commands;

import java.math.BigInteger;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.tcf.internal.cdt.ui.commands.AddWatchpointDialog;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddWatchpointHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        AddWatchpointDialog dlg = new AddWatchpointDialog(HandlerUtil.getActiveShell((ExecutionEvent)event));
        if (selection instanceof ITextSelection) {
            String expr = ((ITextSelection)selection).getText();
            dlg.setExpression(expr);
        }
        if (dlg.open() == 0) {
            this.addWatchpoint(dlg.getWriteAccess(), dlg.getReadAccess(), dlg.getExpression(), dlg.getMemorySpace(), dlg.getRange());
        }
        return null;
    }

    private void addWatchpoint(boolean write, boolean read, String expression, String memorySpace, BigInteger range) {
        IWorkspaceRoot resource = ResourcesPlugin.getWorkspace().getRoot();
        try {
            CDIDebugModel.createWatchpoint((String)"", (IResource)resource, (boolean)write, (boolean)read, (String)expression, (String)memorySpace, (BigInteger)range, (boolean)true, (int)0, (String)"", (boolean)true);
        }
        catch (CoreException ce) {
            CDebugUIPlugin.errorDialog((String)"Cannot add watchpoint.", (Throwable)ce);
        }
    }
}

