/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.cdt.ui.commands;

import java.util.concurrent.ExecutionException;
import org.eclipse.cdt.debug.core.model.IReverseToggleHandler;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IEnabledStateRequest;
import org.eclipse.tcf.internal.cdt.ui.Activator;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.util.TCFTask;

public class TCFReverseToggleCommand
implements IReverseToggleHandler {
    public void canExecute(IEnabledStateRequest request) {
        request.setEnabled(true);
        request.done();
    }

    public boolean execute(final IDebugCommandRequest request) {
        if (request.getElements().length != 0 && request.getElements()[0] instanceof TCFNode) {
            final TCFNode node = (TCFNode)request.getElements()[0];
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    boolean enabled = node.getModel().isReverseDebugEnabled();
                    node.getModel().setReverseDebugEnabled(!enabled);
                    request.done();
                }
            });
        } else {
            request.done();
        }
        return true;
    }

    public boolean toggleNeedsUpdating() {
        return true;
    }

    public boolean isReverseToggled(Object context) {
        if (context instanceof TCFNode) {
            final TCFNode node = (TCFNode)context;
            try {
                return (Boolean)new TCFTask<Boolean>(){

                    public void run() {
                        this.done(node.getModel().isReverseDebugEnabled());
                    }
                }.get();
            }
            catch (InterruptedException e) {
                Activator.log(e);
                return false;
            }
            catch (ExecutionException e) {
                Activator.log(e);
                return false;
            }
        }
        return false;
    }
}

