/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.services.remote;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.tcf.core.Command;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IErrorReport;
import org.eclipse.tcf.protocol.IService;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.services.IMemory;

public class MemoryProxy
implements IMemory {
    private final IChannel channel;
    private final Map<IMemory.MemoryListener, IChannel.IEventListener> listeners = new HashMap<IMemory.MemoryListener, IChannel.IEventListener>();

    public MemoryProxy(IChannel channel) {
        this.channel = channel;
    }

    @Override
    public void addListener(final IMemory.MemoryListener listener) {
        IChannel.IEventListener l = new IChannel.IEventListener(){

            @Override
            public void event(String name, byte[] data) {
                block10: {
                    try {
                        Object[] args = JSON.parseSequence(data);
                        if (name.equals("contextAdded")) {
                            if (!$assertionsDisabled && args.length != 1) {
                                throw new AssertionError();
                            }
                            listener.contextAdded(MemoryProxy.this.toContextArray(args[0]));
                            break block10;
                        }
                        if (name.equals("contextChanged")) {
                            if (!$assertionsDisabled && args.length != 1) {
                                throw new AssertionError();
                            }
                            listener.contextChanged(MemoryProxy.this.toContextArray(args[0]));
                            break block10;
                        }
                        if (name.equals("contextRemoved")) {
                            if (!$assertionsDisabled && args.length != 1) {
                                throw new AssertionError();
                            }
                            listener.contextRemoved(MemoryProxy.this.toStringArray(args[0]));
                            break block10;
                        }
                        if (name.equals("memoryChanged")) {
                            if (!$assertionsDisabled && args.length != 2) {
                                throw new AssertionError();
                            }
                            listener.memoryChanged((String)args[0], MemoryProxy.this.toAddrArray(args[1]), MemoryProxy.this.toSizeArray(args[1]));
                            break block10;
                        }
                        throw new IOException("Memory service: unknown event: " + name);
                    }
                    catch (Throwable x) {
                        MemoryProxy.this.channel.terminate(x);
                    }
                }
            }
        };
        this.channel.addEventListener(this, l);
        this.listeners.put(listener, l);
    }

    @Override
    public void removeListener(IMemory.MemoryListener listener) {
        IChannel.IEventListener l = this.listeners.remove(listener);
        if (l != null) {
            this.channel.removeEventListener(this, l);
        }
    }

    @Override
    public IToken getContext(String context_id, final IMemory.DoneGetContext done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"getContext", (Object[])new Object[]{context_id}){

            @Override
            public void done(Exception error, Object[] args) {
                MemContext ctx = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    if (args[1] != null) {
                        ctx = new MemContext((Map)args[1]);
                    }
                }
                done.doneGetContext(this.token, error, ctx);
            }
        }.token;
    }

    @Override
    public IToken getChildren(String parent_context_id, final IMemory.DoneGetChildren done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"getChildren", (Object[])new Object[]{parent_context_id}){

            @Override
            public void done(Exception error, Object[] args) {
                String[] arr = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    arr = MemoryProxy.this.toStringArray(args[1]);
                }
                done.doneGetChildren(this.token, error, arr);
            }
        }.token;
    }

    @Override
    public String getName() {
        return "Memory";
    }

    private IMemory.MemoryContext[] toContextArray(Object o) {
        Collection c = (Collection)o;
        if (c == null) {
            return new IMemory.MemoryContext[0];
        }
        int n = 0;
        IMemory.MemoryContext[] ctx = new IMemory.MemoryContext[c.size()];
        Iterator i = c.iterator();
        while (i.hasNext()) {
            ctx[n++] = new MemContext((Map)i.next());
        }
        return ctx;
    }

    private long[] toSizeArray(Object o) {
        Collection c = (Collection)o;
        if (c == null) {
            return null;
        }
        long[] a = new long[c.size()];
        int n = 0;
        for (Map m : c) {
            Number sz = (Number)m.get("size");
            long l = a[n++] = sz == null ? 0L : sz.longValue();
        }
        return a;
    }

    private Number[] toAddrArray(Object o) {
        Collection c = (Collection)o;
        if (c == null) {
            return null;
        }
        Number[] a = new Number[c.size()];
        int n = 0;
        for (Map m : c) {
            a[n++] = (Number)m.get("addr");
        }
        return a;
    }

    private String[] toStringArray(Object o) {
        if (o == null) {
            return null;
        }
        Collection c = (Collection)o;
        return c.toArray(new String[c.size()]);
    }

    private class MemContext
    implements IMemory.MemoryContext {
        private final Map<String, Object> props;

        MemContext(Map<String, Object> props) {
            this.props = props;
        }

        @Override
        public String getID() {
            return (String)this.props.get("ID");
        }

        @Override
        public String getParentID() {
            return (String)this.props.get("ParentID");
        }

        @Override
        public int getAddressSize() {
            Number n = (Number)this.props.get("AddressSize");
            if (n == null) {
                return 0;
            }
            return n.intValue();
        }

        @Override
        public String getProcessID() {
            return (String)this.props.get("ProcessID");
        }

        @Override
        public boolean isBigEndian() {
            Boolean n = (Boolean)this.props.get("BigEndian");
            if (n == null) {
                return false;
            }
            return n;
        }

        @Override
        public Collection<String> getAccessTypes() {
            return (Collection)this.props.get("AccessTypes");
        }

        @Override
        public Number getEndBound() {
            return (Number)this.props.get("EndBound");
        }

        @Override
        public String getName() {
            return (String)this.props.get("Name");
        }

        @Override
        public Number getStartBound() {
            return (Number)this.props.get("StartBound");
        }

        @Override
        public Map<String, Object> getProperties() {
            return this.props;
        }

        @Override
        public IToken fill(final Number addr, int word_size, byte[] value, int size, int mode, final IMemory.DoneMemory done) {
            return new MemoryCommand((MemoryProxy)MemoryProxy.this, (String)"fill", (Object[])new Object[]{this.getID(), addr, Integer.valueOf((int)word_size), Integer.valueOf((int)size), Integer.valueOf((int)mode), (Object)value}){

                @Override
                public void done(Exception error, Object[] args) {
                    IMemory.MemoryError e = null;
                    if (error != null) {
                        e = new IMemory.MemoryError(error.getMessage());
                    } else {
                        if (!$assertionsDisabled && args.length != 2) {
                            throw new AssertionError();
                        }
                        e = this.toMemoryError(addr, args[0], args[1]);
                    }
                    done.doneMemory(this.token, e);
                }
            }.token;
        }

        @Override
        public IToken get(final Number addr, int word_size, final byte[] buf, final int offs, final int size, int mode, final IMemory.DoneMemory done) {
            return new MemoryCommand((MemoryProxy)MemoryProxy.this, (String)"get", (Object[])new Object[]{this.getID(), addr, Integer.valueOf((int)word_size), Integer.valueOf((int)size), Integer.valueOf((int)mode)}){

                @Override
                public void done(Exception error, Object[] args) {
                    IMemory.MemoryError e = null;
                    if (error != null) {
                        e = new IMemory.MemoryError(error.getMessage());
                    } else {
                        if (!$assertionsDisabled && args.length != 3) {
                            throw new AssertionError();
                        }
                        JSON.toByteArray(buf, offs, size, args[0]);
                        e = this.toMemoryError(addr, args[1], args[2]);
                    }
                    done.doneMemory(this.token, e);
                }
            }.token;
        }

        @Override
        public IToken set(final Number addr, int word_size, byte[] buf, int offs, int size, int mode, final IMemory.DoneMemory done) {
            return new MemoryCommand((MemoryProxy)MemoryProxy.this, (String)"set", (Object[])new Object[]{this.getID(), addr, Integer.valueOf((int)word_size), Integer.valueOf((int)size), Integer.valueOf((int)mode), new JSON.Binary((byte[])buf, (int)offs, (int)size)}){

                @Override
                public void done(Exception error, Object[] args) {
                    IMemory.MemoryError e = null;
                    if (error != null) {
                        e = new IMemory.MemoryError(error.getMessage());
                    } else {
                        if (!$assertionsDisabled && args.length != 2) {
                            throw new AssertionError();
                        }
                        e = this.toMemoryError(addr, args[0], args[1]);
                    }
                    done.doneMemory(this.token, e);
                }
            }.token;
        }

        public String toString() {
            return "[Memory Context " + this.props.toString() + "]";
        }
    }

    private abstract class MemoryCommand
    extends Command {
        MemoryCommand(String cmd, Object[] args) {
            super(MemoryProxy.this.channel, MemoryProxy.this, cmd, args);
        }

        IMemory.MemoryError toMemoryError(Number addr, Object data, Object ranges) {
            if (data == null) {
                return null;
            }
            Map map = (Map)data;
            Integer code = (Integer)map.get("Code");
            MemoryErrorReport e = new MemoryErrorReport("TCF command exception:\nCommand: " + this.getCommandString(0) + "\nException: " + MemoryCommand.toErrorString(data) + "\nError code: " + code, map, addr, ranges);
            Object caused_by = map.get("CausedBy");
            if (caused_by != null) {
                e.initCause(this.toError(caused_by, false));
            }
            return e;
        }
    }

    private class MemoryErrorReport
    extends IMemory.MemoryError
    implements IMemory.ErrorOffset,
    IErrorReport {
        private static final long serialVersionUID = 796525409870265390L;
        private final Map<String, Object> attrs;
        private final Range[] ranges;

        MemoryErrorReport(String msg, Map<String, Object> attrs, Number addr, Object ranges) {
            super(msg);
            this.attrs = attrs;
            Collection c = (Collection)ranges;
            Range[] rangeArray = this.ranges = c == null ? null : new Range[c.size()];
            if (c != null) {
                int n = 0;
                BigInteger addr_bi = JSON.toBigInteger(addr);
                for (Map m : c) {
                    Range r = new Range();
                    Number x = (Number)m.get("addr");
                    BigInteger y = JSON.toBigInteger(x);
                    r.offs = y.subtract(addr_bi).intValue();
                    r.size = ((Number)m.get("size")).intValue();
                    r.stat = ((Number)m.get("stat")).intValue();
                    r.msg = Command.toErrorString(m.get("msg"));
                    assert (r.offs >= 0);
                    assert (r.size >= 0);
                    this.ranges[n++] = r;
                }
                Arrays.sort(this.ranges);
            }
        }

        @Override
        public int getErrorCode() {
            Number n = (Number)this.attrs.get("Code");
            if (n == null) {
                return 0;
            }
            return n.intValue();
        }

        @Override
        public int getAltCode() {
            Number n = (Number)this.attrs.get("AltCode");
            if (n == null) {
                return 0;
            }
            return n.intValue();
        }

        @Override
        public String getAltOrg() {
            return (String)this.attrs.get("AltOrg");
        }

        @Override
        public Map<String, Object> getAttributes() {
            return this.attrs;
        }

        @Override
        public String getMessage(int offset) {
            if (this.ranges == null) {
                return null;
            }
            int l = 0;
            int h = this.ranges.length - 1;
            while (l <= h) {
                int n = l + h >>> 1;
                Range r = this.ranges[n];
                if (r.offs > offset) {
                    h = n - 1;
                    continue;
                }
                if (offset >= r.offs + r.size) {
                    l = n + 1;
                    continue;
                }
                return r.msg;
            }
            return null;
        }

        @Override
        public int getStatus(int offset) {
            if (this.ranges == null) {
                return 1;
            }
            int l = 0;
            int h = this.ranges.length - 1;
            while (l <= h) {
                int n = l + h >>> 1;
                Range r = this.ranges[n];
                if (r.offs > offset) {
                    h = n - 1;
                    continue;
                }
                if (offset >= r.offs + r.size) {
                    l = n + 1;
                    continue;
                }
                return r.stat;
            }
            return 1;
        }
    }

    private static class Range
    implements Comparable<Range> {
        int offs;
        int size;
        int stat;
        String msg;

        private Range() {
        }

        public boolean equals(Object o) {
            if (o instanceof Range) {
                return this.compareTo((Range)o) == 0;
            }
            return false;
        }

        @Override
        public int compareTo(Range o) {
            if (this.offs < o.offs) {
                return -1;
            }
            if (this.offs > o.offs) {
                return 1;
            }
            return 0;
        }
    }
}

