/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.tests;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.tcf.core.Command;
import org.eclipse.tcf.core.ErrorReport;
import org.eclipse.tcf.internal.debug.tests.ITCFTest;
import org.eclipse.tcf.internal.debug.tests.TCFTestSuite;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IErrorReport;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IDiagnostics;

class TestEchoERR
implements ITCFTest,
IDiagnostics.DoneEchoERR {
    private final TCFTestSuite test_suite;
    private final IDiagnostics diag;
    private final Number[] numbers = new Number[]{1, 4, new BigDecimal("0.5")};
    private final String[] strings = new String[]{"", "abc", "a\u1134c", "a\u0003c"};
    private final String[] formats = new String[]{"", "{0}", "{0,number}", "{0,number,integer}", "{0,number,percent}", "{1}", "{0} abcde {1}", "{1} '' {0}", "{1} 'abcde{}' {1}"};
    private final LinkedList<ErrorReport> list = new LinkedList();

    TestEchoERR(TCFTestSuite test_suite, IChannel channel) {
        this.test_suite = test_suite;
        this.diag = (IDiagnostics)channel.getRemoteService(IDiagnostics.class);
    }

    @Override
    public void start() {
        Number[] numberArray = this.numbers;
        int n = this.numbers.length;
        int n2 = 0;
        while (n2 < n) {
            Number n3 = numberArray[n2];
            String[] stringArray = this.strings;
            int n4 = this.strings.length;
            int n5 = 0;
            while (n5 < n4) {
                String s = stringArray[n5];
                String[] stringArray2 = this.formats;
                int n6 = this.formats.length;
                int n7 = 0;
                while (n7 < n6) {
                    String f = stringArray2[n7];
                    ArrayList<Object> params = new ArrayList<Object>();
                    params.add(n3);
                    params.add(s);
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("Time", new Long(System.currentTimeMillis()));
                    map.put("Code", new Integer(1));
                    map.put("Format", f);
                    map.put("Params", params);
                    map.put(s, s);
                    ErrorReport e = new ErrorReport("TCF error", map);
                    this.list.add(e);
                    this.diag.echoERR((Throwable)e, (IDiagnostics.DoneEchoERR)this);
                    ++n7;
                }
                ++n5;
            }
            ++n2;
        }
    }

    public void doneEchoERR(IToken token, Throwable error, Throwable error_obj, String error_msg) {
        ErrorReport e = this.list.removeFirst();
        if (!this.test_suite.isActive(this)) {
            return;
        }
        Map map0 = e.getAttributes();
        Map map1 = null;
        if (error_obj instanceof IErrorReport) {
            map1 = ((IErrorReport)error_obj).getAttributes();
        }
        String msg = Command.toErrorString((Object)map0);
        if (error instanceof IErrorReport && ((IErrorReport)error).getErrorCode() == 25) {
            this.test_suite.done(this, null);
        } else if (error != null) {
            this.test_suite.done(this, error);
        } else if (!map0.equals(map1)) {
            this.test_suite.done(this, new Exception("Invalid error report attributes"));
        } else if (!msg.equals(error_msg)) {
            this.test_suite.done(this, new Exception("Invalid error report text"));
        } else if (this.list.size() == 0) {
            this.test_suite.done(this, null);
        }
    }

    @Override
    public boolean canResume(String id) {
        return true;
    }
}

