/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.ui.internal.properties;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.tcf.te.launch.core.persistence.filetransfer.FileTransfersPersistenceDelegate;
import org.eclipse.tcf.te.launch.ui.model.LaunchNode;
import org.eclipse.tcf.te.launch.ui.nls.Messages;
import org.eclipse.tcf.te.launch.ui.properties.BaseTitledSection;
import org.eclipse.tcf.te.launch.ui.tabs.filetransfers.FileTransferContentProvider;
import org.eclipse.tcf.te.runtime.services.interfaces.filetransfer.IFileTransferItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class FileTransferPropertiesSection
extends BaseTitledSection {
    private IFileTransferItem[] items;
    private TableViewer viewer;

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Table table = this.getWidgetFactory().createTable(this.composite, 67586);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        data.bottom = new FormAttachment(100, -4);
        table.setLayoutData((Object)data);
        TableColumn column = new TableColumn(table, 16384);
        column.setText(Messages.FileTransferSection_host_column);
        column.setWidth(200);
        column = new TableColumn(table, 0x1000000);
        column.setWidth(30);
        column = new TableColumn(table, 16384);
        column.setText(Messages.FileTransferSection_target_column);
        column.setWidth(200);
        column = new TableColumn(table, 16384);
        column.setText(Messages.FileTransferSection_options_column);
        column.setWidth(100);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer = new TableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new FileTransferContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new FileTransferLabelProvider());
    }

    @Override
    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        Assert.isTrue((boolean)(input instanceof LaunchNode));
        ILaunchConfiguration node = ((LaunchNode)((Object)input)).getLaunchConfiguration();
        ArrayList<IFileTransferItem> list = new ArrayList<IFileTransferItem>();
        for (IFileTransferItem item : Arrays.asList(FileTransfersPersistenceDelegate.getFileTransfers((ILaunchConfiguration)node))) {
            if (!item.isEnabled()) continue;
            list.add(item);
        }
        this.items = list.toArray(new IFileTransferItem[list.size()]);
    }

    @Override
    public void refresh() {
        if (this.viewer != null) {
            this.viewer.setInput((Object)this.items);
        }
    }

    @Override
    protected String getText() {
        return Messages.FileTransferSection_title;
    }

    protected static class FileTransferLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected FileTransferLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ((IFileTransferItem)element).getHostPath().toOSString();
                }
                case 1: {
                    return ((IFileTransferItem)element).getDirection() == 2 ? Messages.FileTransferSection_toHost_text : Messages.FileTransferSection_toTarget_text;
                }
                case 2: {
                    return ((IFileTransferItem)element).getTargetPath().toPortableString();
                }
                case 3: {
                    return ((IFileTransferItem)element).getOptions();
                }
            }
            return "";
        }
    }
}

