/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.stepper.stepper;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.concurrent.util.ExecutorsUtil;
import org.eclipse.tcf.te.runtime.interfaces.IConditionTester;
import org.eclipse.tcf.te.runtime.interfaces.ISharedConstants;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.stepper.FullQualifiedId;
import org.eclipse.tcf.te.runtime.stepper.StepperManager;
import org.eclipse.tcf.te.runtime.stepper.activator.CoreBundleActivator;
import org.eclipse.tcf.te.runtime.stepper.extensions.StepExecutor;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IFullQualifiedId;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStep;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepContext;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepExecutor;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepGroup;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepGroupIterator;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepGroupable;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepper;
import org.eclipse.tcf.te.runtime.stepper.nls.Messages;
import org.eclipse.tcf.te.runtime.utils.StatusHelper;

public class Stepper
implements IStepper {
    private boolean initialized = false;
    private boolean finished = false;
    private IPropertiesContainer data = null;
    private IFullQualifiedId fullQualifiedId = null;
    private IProgressMonitor monitor = null;
    private IStepContext context = null;
    private boolean cancelable = true;
    private String stepGroupId = null;
    private String name = null;

    public Stepper() {
    }

    public Stepper(String name) {
        this.name = name;
    }

    @Override
    public String getId() {
        return this.getClass().getName();
    }

    @Override
    public String getLabel() {
        return this.name != null && this.name.trim().length() > 0 ? this.name.trim() : this.getId();
    }

    protected String getStepGroupId() {
        return this.stepGroupId;
    }

    protected IStepGroup getStepGroup(String id) {
        Assert.isNotNull((Object)id);
        CoreBundleActivator.getTraceHandler().trace("SingleContextStepper#getStepGroup: id = '" + id + "'", 0, "trace/stepping", 2, (Object)this);
        return StepperManager.getInstance().getStepGroupExtManager().getStepGroup(id, false);
    }

    protected IStepExecutor doCreateStepExecutor(IStep step, String secondaryId, IFullQualifiedId fullQualifiedStepId) {
        Assert.isNotNull((Object)step);
        Assert.isNotNull((Object)fullQualifiedStepId);
        return new StepExecutor();
    }

    @Override
    public final void initialize(IStepContext context, String stepGroupId, IPropertiesContainer data, IProgressMonitor monitor) throws IllegalStateException {
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)stepGroupId);
        Assert.isNotNull((Object)data);
        if (this.isInitialized()) {
            throw new IllegalStateException("Stepper instance already initialized!");
        }
        this.context = context;
        this.stepGroupId = stepGroupId;
        this.data = data;
        this.monitor = monitor != null ? monitor : new NullProgressMonitor();
        this.fullQualifiedId = new FullQualifiedId("StepContext", context.getId(), context.getSecondaryId());
        this.finished = false;
        this.onInitialize(this.data, this.fullQualifiedId, this.monitor);
        this.setInitialized();
        CoreBundleActivator.getTraceHandler().trace("Stepper#initialize: data = " + data, 0, "trace/stepping", 2, (Object)this);
    }

    protected void onInitialize(IPropertiesContainer data, IFullQualifiedId fullQualifiedId, IProgressMonitor monitor) {
        Assert.isNotNull((Object)data);
        Assert.isNotNull((Object)monitor);
    }

    protected final void setInitialized() {
        this.initialized = true;
    }

    @Override
    public final boolean isInitialized() {
        return this.initialized;
    }

    protected final void setCancelable(boolean cancelable) {
        this.cancelable = cancelable;
    }

    protected final boolean isCancelable() {
        return this.cancelable;
    }

    protected IStepContext getContext() {
        return this.context;
    }

    protected String getContextId() {
        return this.context != null ? this.context.getId() : null;
    }

    protected final IPropertiesContainer getData() {
        return this.isInitialized() ? this.data : null;
    }

    protected final IFullQualifiedId getFullQualifiedId() {
        return this.fullQualifiedId;
    }

    protected final IProgressMonitor getMonitor() {
        return this.isInitialized() ? this.monitor : null;
    }

    protected final void setFinished() {
        this.finished = true;
    }

    @Override
    public final boolean isFinished() {
        return this.finished;
    }

    @Override
    public void cleanup() {
        if (this.getMonitor() != null) {
            this.getMonitor().done();
        }
        this.context = null;
        this.data = null;
        this.monitor = null;
        this.fullQualifiedId = null;
        this.finished = false;
        this.initialized = false;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(this.getClass().getSimpleName());
        buffer.append(" (" + this.getLabel() + ")");
        buffer.append(": ");
        buffer.append("id = " + this.getId());
        return buffer.toString();
    }

    @Override
    public final void execute() throws CoreException {
        long startTime = System.currentTimeMillis();
        CoreBundleActivator.getTraceHandler().trace("Stepper#execute: *** ENTERED", 0, "trace/stepping", 2, (Object)this);
        CoreBundleActivator.getTraceHandler().trace(" [" + ISharedConstants.TIME_FORMAT.format(new Date(startTime)) + "]" + " ***", 0, "profile/stepping", 2, (Object)this);
        try {
            if (!this.isInitialized()) {
                throw new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), Messages.Stepper_error_initializeNotCalled));
            }
            ArrayList<IStatus> statusContainer = new ArrayList<IStatus>();
            this.internalExecute(statusContainer);
            if (!statusContainer.isEmpty()) {
                IStatus status = null;
                if (statusContainer.size() > 1) {
                    MultiStatus multiStatus = new MultiStatus(CoreBundleActivator.getUniqueIdentifier(), 0, NLS.bind((String)Messages.Stepper_multiStatus_finishedWithWarnings, (Object)this.getLabel()), null);
                    for (IStatus subStatus : statusContainer) {
                        multiStatus.merge(subStatus);
                    }
                    status = multiStatus;
                } else {
                    status = (IStatus)statusContainer.get(0);
                }
                throw new CoreException(status);
            }
        }
        finally {
            this.setFinished();
            long endTime = System.currentTimeMillis();
            CoreBundleActivator.getTraceHandler().trace("Stepper#execute: *** DONE", 0, "trace/stepping", 2, (Object)this);
            CoreBundleActivator.getTraceHandler().trace(" [" + ISharedConstants.TIME_FORMAT.format(new Date(endTime)) + " , delay = " + (endTime - startTime) + " ms]" + " ***", 0, "profile/stepping", 2, (Object)this);
        }
    }

    protected void internalExecute(List<IStatus> statusContainer) throws CoreException {
        Assert.isNotNull(statusContainer);
        String stepGroupId = this.getStepGroupId();
        if (stepGroupId == null) {
            throw new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), NLS.bind((String)Messages.Stepper_error_missingStepGroupId, (Object)this.getLabel())));
        }
        IStepGroup stepGroup = this.getStepGroup(stepGroupId);
        if (stepGroup == null) {
            throw new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), NLS.bind((String)Messages.Stepper_error_missingStepGroup, (Object)stepGroupId)));
        }
        this.getMonitor().beginTask(stepGroup.getLabel(), this.calculateTotalWork(stepGroup));
        IFullQualifiedId fullQualifiedId = this.getFullQualifiedId().createChildId("Stepper", this.getId(), null);
        fullQualifiedId = fullQualifiedId.createChildId("StepGroup", stepGroup.getId(), null);
        this.executeStepGroup(stepGroup, statusContainer, new ArrayList<ExecutedContextStep>(), fullQualifiedId);
    }

    private void executeStepGroup(IStepGroup stepGroup, List<IStatus> statusContainer, List<ExecutedContextStep> executedSteps, IFullQualifiedId fullQualifiedGroupId) throws CoreException {
        Assert.isNotNull((Object)stepGroup);
        Assert.isNotNull(statusContainer);
        Assert.isNotNull(executedSteps);
        Assert.isNotNull((Object)fullQualifiedGroupId);
        if (this.isCancelable() && this.getMonitor().isCanceled()) {
            this.rollback(executedSteps, Status.CANCEL_STATUS, this.getMonitor());
            throw new CoreException(StatusHelper.getStatus((Throwable)new OperationCanceledException()));
        }
        CoreBundleActivator.getTraceHandler().trace("Stepper#executeStepGroup: step group: '" + stepGroup.getLabel() + "'", 0, "trace/stepping", 2, (Object)this);
        IStepGroupable[] groupables = stepGroup.getSteps(this.getContext());
        IStepGroupIterator iterator = stepGroup.getStepGroupIterator();
        IFullQualifiedId fullQualifiedIterationId = fullQualifiedGroupId;
        int iteration = 0;
        if (iterator != null) {
            iterator.initialize(this.getContext(), this.getData(), fullQualifiedGroupId, this.getMonitor());
        }
        boolean next = iterator == null || iterator.hasNext(this.getContext(), this.getData(), fullQualifiedGroupId, this.getMonitor());
        while (next) {
            if (iterator != null) {
                fullQualifiedIterationId = fullQualifiedGroupId.getParentId().createChildId("StepGroup", stepGroup.getId(), "" + iteration);
                iterator.next(this.getContext(), this.getData(), fullQualifiedIterationId, this.getMonitor());
            }
            IStepGroupable[] iStepGroupableArray = groupables;
            int n = groupables.length;
            int n2 = 0;
            while (n2 < n) {
                IStepGroupable groupable = iStepGroupableArray[n2];
                this.executeGroupable(groupable, statusContainer, executedSteps, fullQualifiedIterationId);
                ++n2;
            }
            ++iteration;
            boolean bl = next = iterator != null && iterator.hasNext(this.getContext(), this.getData(), fullQualifiedGroupId, this.getMonitor());
        }
    }

    private void executeGroupable(IStepGroupable groupable, List<IStatus> statusContainer, List<ExecutedContextStep> executedSteps, IFullQualifiedId fullQualifiedParentId) throws CoreException {
        block8: {
            Assert.isNotNull((Object)groupable);
            Assert.isNotNull(statusContainer);
            Assert.isNotNull(executedSteps);
            Assert.isNotNull((Object)fullQualifiedParentId);
            if (this.isCancelable() && this.getMonitor() != null && this.getMonitor().isCanceled()) {
                this.rollback(executedSteps, Status.CANCEL_STATUS, this.getMonitor());
                throw new CoreException(StatusHelper.getStatus((Throwable)new OperationCanceledException()));
            }
            if (groupable.isDisabled()) {
                CoreBundleActivator.getTraceHandler().trace("Stepper#executeGroupable: DROPPED DISABLED groupable: id = '" + groupable.getExtension().getId() + "'" + ", secondaryId = '" + groupable.getSecondaryId() + "'", 0, "trace/stepping", 2, (Object)this);
                return;
            }
            this.checkForDependenciesExecuted(groupable, executedSteps);
            if (groupable.getExtension() instanceof IStepGroup) {
                IFullQualifiedId id = fullQualifiedParentId.createChildId("StepGroup", groupable.getExtension().getId(), groupable.getSecondaryId());
                this.executeStepGroup((IStepGroup)groupable.getExtension(), statusContainer, executedSteps, id);
            } else if (groupable.getExtension() instanceof IStep) {
                IStep step = (IStep)groupable.getExtension();
                IFullQualifiedId id = fullQualifiedParentId.createChildId("Step", step.getId(), groupable.getSecondaryId());
                IStepExecutor executor = this.doCreateStepExecutor(step, groupable.getSecondaryId(), id);
                Assert.isNotNull((Object)executor);
                try {
                    executedSteps.add(new ExecutedContextStep(id, step));
                    executor.execute(step, id, this.getContext(), this.getData(), this.getMonitor());
                }
                catch (Exception e) {
                    CoreException coreException = this.normalizeStatus(e, statusContainer);
                    if (coreException == null) break block8;
                    if (this.isInitialized()) {
                        this.rollback(executedSteps, coreException.getStatus(), this.getMonitor());
                    }
                    throw coreException;
                }
            }
        }
    }

    protected void checkForDependenciesExecuted(IStepGroupable groupable, List<ExecutedContextStep> executedSteps) throws CoreException {
        Assert.isNotNull((Object)groupable);
        Assert.isNotNull(executedSteps);
        ArrayList<String> dependencies = new ArrayList<String>(Arrays.asList(groupable.getDependencies()));
        if (groupable.getExtension() instanceof IStep) {
            dependencies.addAll(Arrays.asList(((IStep)groupable.getExtension()).getDependencies()));
        }
        for (String dependency : dependencies) {
            String[] splitted = dependency.split("##", 2);
            String primaryId = splitted.length == 2 ? splitted[0] : dependency;
            boolean requiredStepExecuted = false;
            for (ExecutedContextStep step : executedSteps) {
                if (!step.step.getId().equals(primaryId)) continue;
                requiredStepExecuted = true;
                break;
            }
            if (requiredStepExecuted) continue;
            throw new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), MessageFormat.format(Messages.Stepper_error_requiredStepNotExecuted, NLS.bind((String)(groupable.getExtension() instanceof IStep ? Messages.Stepper_error_step : Messages.Stepper_error_stepGroup), (Object)groupable.getExtension().getId()), NLS.bind((String)Messages.Stepper_error_requiredStepOrGroup, (Object)dependency), "")));
        }
    }

    protected final void rollback(List<ExecutedContextStep> executedSteps, IStatus rollBackStatus, IProgressMonitor progress) {
        Assert.isNotNull(executedSteps);
        while (!executedSteps.isEmpty()) {
            ExecutedContextStep executedStep = executedSteps.remove(executedSteps.size() - 1);
            Callback callback = new Callback();
            progress.setTaskName("Rollback " + executedStep.step.getLabel());
            executedStep.step.rollback(this.getContext(), this.getData(), rollBackStatus, executedStep.id, progress, (ICallback)callback);
            ExecutorsUtil.waitAndExecute((long)60000L, (IConditionTester)callback.getDoneConditionTester(null));
        }
    }

    protected int calculateTotalWork(IStepGroup stepGroup) throws CoreException {
        IStepGroupable[] groupables;
        Assert.isNotNull((Object)stepGroup);
        int totalWork = 0;
        IStepGroupable[] iStepGroupableArray = groupables = stepGroup.getSteps(this.getContext());
        int n = groupables.length;
        int n2 = 0;
        while (n2 < n) {
            int work;
            IStepGroupable groupable = iStepGroupableArray[n2];
            int n3 = groupable.getExtension() instanceof IStep ? ((IStep)groupable.getExtension()).getTotalWork(this.getContext(), this.getData()) : (work = groupable.getExtension() instanceof IStepGroup ? this.calculateTotalWork((IStepGroup)groupable.getExtension()) : -1);
            if (work == -1) {
                totalWork = -1;
                break;
            }
            totalWork += work;
            ++n2;
        }
        return totalWork;
    }

    private CoreException normalizeStatus(Exception e, List<IStatus> statusContainer) {
        Assert.isNotNull(statusContainer);
        CoreException coreException = null;
        IStatus status = Status.OK_STATUS;
        if (e instanceof CoreException) {
            status = ((CoreException)((Object)e)).getStatus();
            coreException = (CoreException)((Object)e);
        } else if (e instanceof OperationCanceledException) {
            status = new Status(8, CoreBundleActivator.getUniqueIdentifier(), e.getLocalizedMessage(), (Throwable)e);
            coreException = new CoreException(status);
        } else if (e != null) {
            status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), e.getLocalizedMessage(), (Throwable)e);
            coreException = new CoreException(status);
        }
        if (status.getSeverity() == 0) {
            coreException = null;
        } else if (status.getSeverity() == 8) {
            if (this.isCancelable() && this.getMonitor() != null && !this.getMonitor().isCanceled()) {
                this.getMonitor().setCanceled(true);
            }
        } else if (status.getSeverity() == 2 || status.getSeverity() == 1) {
            statusContainer.add(status);
            coreException = null;
        } else if (status.getSeverity() == 4 && !statusContainer.isEmpty()) {
            MultiStatus multiStatus = new MultiStatus(status.getPlugin(), status.getCode(), NLS.bind((String)Messages.Stepper_multiStatus_finishedWithErrors, (Object)this.getLabel()), null);
            for (IStatus stat : statusContainer) {
                multiStatus.merge(stat);
            }
            coreException = new CoreException((IStatus)multiStatus);
        }
        return coreException;
    }

    protected final class ExecutedContextStep {
        final IFullQualifiedId id;
        final IStep step;

        public ExecutedContextStep(IFullQualifiedId id, IStep step) {
            this.id = id;
            this.step = step;
        }
    }
}

