/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.operations;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.tcf.filesystem.core.activator.CorePlugin;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.IOperation;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.exceptions.TCFException;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.operations.IOpExecutor;

public class JobExecutor
implements IOpExecutor {
    protected ICallback callback;

    public JobExecutor() {
        this(null);
    }

    public JobExecutor(ICallback callback) {
        this.callback = callback;
    }

    @Override
    public IStatus execute(final IOperation operation) {
        Job job = new Job(operation.getName()){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    monitor.setTaskName(operation.getName());
                    monitor.beginTask(operation.getName(), operation.getTotalWork());
                    operation.run(monitor);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (InvocationTargetException e) {
                    Throwable throwable = e.getTargetException();
                    if (throwable instanceof TCFException) {
                        int severity = ((TCFException)throwable).getSeverity();
                        Status status = new Status(severity, CorePlugin.getUniqueIdentifier(), throwable.getMessage(), throwable);
                        return status;
                    }
                    Status status = new Status(4, CorePlugin.getUniqueIdentifier(), throwable.getMessage(), throwable);
                    return status;
                }
                catch (InterruptedException interruptedException) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                JobExecutor.this.doCallback(operation, event);
            }
        });
        job.schedule();
        return Status.OK_STATUS;
    }

    void doCallback(IOperation operation, IJobChangeEvent event) {
        IStatus status = event.getResult();
        if (this.callback != null) {
            this.callback.done((Object)operation, status);
        }
    }
}

