/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.launch.cdt.utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.core.utils.text.StringUtil;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.concurrent.util.ExecutorsUtil;
import org.eclipse.tcf.te.runtime.interfaces.IConditionTester;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.processes.ProcessOutputReaderThread;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.runtime.services.filetransfer.FileTransferItem;
import org.eclipse.tcf.te.runtime.services.interfaces.filetransfer.IFileTransferItem;
import org.eclipse.tcf.te.runtime.utils.Host;
import org.eclipse.tcf.te.runtime.utils.net.IPAddressUtil;
import org.eclipse.tcf.te.tcf.core.streams.StreamsDataReceiver;
import org.eclipse.tcf.te.tcf.filesystem.core.services.FileTransferService;
import org.eclipse.tcf.te.tcf.launch.cdt.interfaces.IRemoteTEConfigurationConstants;
import org.eclipse.tcf.te.tcf.launch.cdt.nls.Messages;
import org.eclipse.tcf.te.tcf.launch.cdt.utils.ProcessStreamsProxy;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelLookupService;
import org.eclipse.tcf.te.tcf.locator.model.Model;
import org.eclipse.tcf.te.tcf.processes.core.interfaces.launcher.IProcessStreamsProxy;
import org.eclipse.tcf.te.tcf.processes.core.launcher.ProcessLauncher;

public class TEHelper {
    public static void remoteFileTransfer(IPeer peer, String localFilePath, String remoteFilePath, SubProgressMonitor monitor) {
        monitor.beginTask(String.valueOf(Messages.RemoteRunLaunchDelegate_2) + " " + localFilePath + " to " + remoteFilePath, 100);
        FileTransferItem item = new FileTransferItem((IPath)new Path(localFilePath), (IPath)new Path(remoteFilePath));
        item.setProperty("direction", 1);
        Callback callback = new Callback();
        FileTransferService.transfer((IPeer)peer, null, (IFileTransferItem)item, (IProgressMonitor)monitor, (ICallback)callback);
        ExecutorsUtil.waitAndExecute((long)0L, (IConditionTester)callback.getDoneConditionTester(null));
    }

    public static IPeerModel getPeer(final String peerId) {
        if (peerId != null) {
            final AtomicReference parent = new AtomicReference();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    parent.set(((ILocatorModelLookupService)Model.getModel().getService(ILocatorModelLookupService.class)).lkupPeerModelById(peerId));
                }
            };
            Protocol.invokeAndWait((Runnable)runnable);
            return (IPeerModel)parent.get();
        }
        return null;
    }

    public static IPeerModel getCurrentConnection(ILaunchConfiguration config) throws CoreException {
        String peerId = config.getAttribute(IRemoteTEConfigurationConstants.ATTR_REMOTE_CONNECTION, "");
        IPeerModel connection = TEHelper.getPeer(peerId);
        if (connection == null) {
            TEHelper.abort(Messages.RemoteRunLaunchDelegate_13, null, 150);
        }
        return connection;
    }

    public static ProcessLauncher launchCmd(IPeer peer, String command, StreamsDataReceiver.Listener listener, SubProgressMonitor monitor, ICallback callback) throws CoreException {
        String[] args;
        if (command != null && !command.trim().equals("") && (args = StringUtil.tokenize((String)command, (int)0, (boolean)true)).length > 0) {
            String cmd = args[0];
            String[] arguments = null;
            if (args.length > 1) {
                arguments = Arrays.copyOfRange(args, 1, args.length);
            }
            return TEHelper.launchCmd(peer, cmd, arguments, listener, monitor, callback);
        }
        return null;
    }

    public static ProcessLauncher launchCmd(IPeer peer, String remoteCommandPath, String arguments, StreamsDataReceiver.Listener listener, SubProgressMonitor monitor, ICallback callback) throws CoreException {
        String[] args = arguments != null && !"".equals(arguments.trim()) ? StringUtil.tokenize((String)arguments, (int)0, (boolean)true) : null;
        return TEHelper.launchCmd(peer, remoteCommandPath, args, listener, monitor, callback);
    }

    public static ProcessLauncher launchCmd(final IPeer peer, String remoteCommandPath, String[] args, StreamsDataReceiver.Listener listener, SubProgressMonitor monitor, ICallback callback) throws CoreException {
        if (remoteCommandPath != null && !remoteCommandPath.trim().equals("")) {
            monitor.beginTask(NLS.bind((String)Messages.RemoteRunLaunchDelegate_8, (Object)remoteCommandPath, (Object)args), 10);
            ProcessLauncher launcher = new ProcessLauncher();
            HashMap<String, Object> launchAttributes = new HashMap<String, Object>();
            launchAttributes.put("process.path", TEHelper.spaceEscapify(remoteCommandPath));
            launchAttributes.put("process.args", args);
            launchAttributes.put("localEcho", Boolean.FALSE);
            boolean outputConsole = true;
            if (outputConsole) {
                launchAttributes.put("process.associateConsole", Boolean.TRUE);
            }
            PropertiesContainer container = new PropertiesContainer();
            container.setProperties(launchAttributes);
            if (container.getProperty("lineSeparator") == null) {
                final AtomicBoolean isLocalhost = new AtomicBoolean();
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if ("TCP".equals(peer.getTransportName()) || "SSL".equals(peer.getTransportName())) {
                            isLocalhost.set(IPAddressUtil.getInstance().isLocalHost((String)peer.getAttributes().get("Host")));
                        }
                    }
                };
                if (Protocol.isDispatchThread()) {
                    runnable.run();
                } else {
                    Protocol.invokeAndWait((Runnable)runnable);
                }
                if (isLocalhost.get()) {
                    container.setProperty("lineSeparator", (Object)(Host.isWindowsHost() ? "\\r\\n" : "\\n"));
                }
            }
            if (listener != null) {
                container.setProperty("process.listener.output", (Object)new StreamsDataReceiver.Listener[]{listener});
            }
            launcher.launch(peer, (IPropertiesContainer)container, (ICallback)new Callback(callback){

                protected void internalDone(Object caller, IStatus status) {
                    if (!status.isOK()) {
                        System.out.println(status.getMessage());
                    }
                    super.internalDone(caller, status);
                }
            });
            monitor.done();
            return launcher;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String launchCmdReadOutput(IPeer peer, String remoteCommandPath, String[] args, SubProgressMonitor monitor, ICallback callback) throws CoreException {
        String output = null;
        if (remoteCommandPath != null && !remoteCommandPath.trim().equals("")) {
            Object lock;
            monitor.beginTask(NLS.bind((String)Messages.RemoteRunLaunchDelegate_8, (Object)remoteCommandPath, (Object)args), 10);
            ProcessStreamsProxy proxy = new ProcessStreamsProxy();
            ProcessLauncher launcher = new ProcessLauncher((IProcessStreamsProxy)proxy);
            HashMap<String, Object> launchAttributes = new HashMap<String, Object>();
            launchAttributes.put("process.path", TEHelper.spaceEscapify(remoteCommandPath));
            launchAttributes.put("process.args", args);
            launchAttributes.put("localEcho", Boolean.FALSE);
            launchAttributes.put("process.associateConsole", Boolean.TRUE);
            PropertiesContainer container = new PropertiesContainer();
            container.setProperties(launchAttributes);
            final boolean[] processDone = new boolean[]{false};
            launcher.launch(peer, (IPropertiesContainer)container, (ICallback)new Callback(callback){

                protected void internalDone(Object caller, IStatus status) {
                    super.internalDone(caller, status);
                    processDone[0] = true;
                }
            });
            Object object = lock = new Object();
            synchronized (object) {
                while (!processDone[0]) {
                    if (monitor.isCanceled()) break;
                }
                try {
                    lock.wait(300L);
                }
                catch (InterruptedException interruptedException) {}
            }
            ProcessOutputReaderThread reader = proxy.getOutputReader();
            while (!reader.isFinished()) {
                reader.waitForFinish();
            }
            output = reader.getOutput();
        }
        monitor.done();
        return output;
    }

    public static void abort(String message, Throwable exception, int code) throws CoreException {
        Status status;
        if (exception != null) {
            MultiStatus multiStatus = new MultiStatus("org.eclipse.cdt.launch.remote.te", code, message, exception);
            multiStatus.add((IStatus)new Status(4, "org.eclipse.cdt.launch.remote.te", code, exception.getLocalizedMessage(), exception));
            status = multiStatus;
        } else {
            status = new Status(4, "org.eclipse.cdt.launch.remote.te", code, message, null);
        }
        throw new CoreException((IStatus)status);
    }

    public static String spaceEscapify(String inputString) {
        if (inputString == null) {
            return null;
        }
        return inputString.replaceAll(" ", "\\\\ ");
    }
}

