/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.internal.services;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.services.AbstractService;
import org.eclipse.tcf.te.runtime.services.interfaces.IPropertiesAccessService;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;

public class PropertiesAccessService
extends AbstractService
implements IPropertiesAccessService {
    public Map<String, String> getTargetAddress(Object context) {
        final HashMap result = new HashMap();
        if (context instanceof IPeerModel) {
            final IPeerModel peerModel = (IPeerModel)context;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Map attributes = peerModel.getPeer().getAttributes();
                    String value = (String)attributes.get("Name");
                    if (value != null && !"".equals(value.trim())) {
                        result.put("name", value);
                    }
                    if ((value = (String)attributes.get("Host")) != null && !"".equals(value.trim())) {
                        result.put("address", value);
                    }
                    if ((value = (String)attributes.get("Port")) != null && !"".equals(value.trim())) {
                        result.put("port", value);
                    }
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
        }
        return !result.isEmpty() ? Collections.unmodifiableMap(result) : null;
    }

    public Object getProperty(Object context, final String key) {
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)key);
        final AtomicReference value = new AtomicReference();
        if (context instanceof IPeerModel) {
            final IPeerModel peerModel = (IPeerModel)context;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Object val = peerModel.getProperty(key);
                    value.set(val);
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
        }
        return value.get();
    }

    public boolean setProperty(Object context, final String key, final Object value) {
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)key);
        final AtomicBoolean result = new AtomicBoolean();
        if (context instanceof IPeerModel) {
            final IPeerModel peerModel = (IPeerModel)context;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    result.set(peerModel.setProperty(key, value));
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
        }
        return result.get();
    }

    public boolean isProperty(Object context, final String key, final Object value) {
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)key);
        final AtomicBoolean result = new AtomicBoolean();
        if (context instanceof IPeerModel) {
            final IPeerModel peerModel = (IPeerModel)context;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    result.set(peerModel.isProperty(key, value));
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
        }
        return result.get();
    }

    public Object getParent(Object context) {
        Assert.isNotNull((Object)context);
        final AtomicReference value = new AtomicReference();
        if (context instanceof IPeerModel) {
            final IPeerModel peerModel = (IPeerModel)context;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    value.set(peerModel.getParent());
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
        }
        return value.get();
    }
}

