/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelLookupService;
import org.eclipse.tcf.te.tcf.locator.model.Model;
import org.eclipse.tcf.te.tcf.ui.help.IContextHelpIds;
import org.eclipse.tcf.te.tcf.ui.navigator.DelegatingLabelProvider;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.ui.jface.dialogs.CustomTitleAreaDialog;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;

public class AgentSelectionDialog
extends CustomTitleAreaDialog {
    final String[] services;
    TableViewer viewer;
    Button showOnlyReachable;
    private ISelection selection;

    public AgentSelectionDialog(String[] services) {
        this(null, services);
    }

    public AgentSelectionDialog(Shell parent, String[] services) {
        super(parent, IContextHelpIds.AGENT_SELECTION_DIALOG);
        this.services = services != null && services.length > 0 ? services : null;
    }

    protected boolean isResizable() {
        return true;
    }

    protected boolean supportsMultiSelection() {
        return true;
    }

    protected void createDialogAreaContent(Composite parent) {
        super.createDialogAreaContent(parent);
        this.setDialogTitle(this.getDialogTitle());
        this.setTitle(this.getTitle());
        this.setDefaultMessage(this.getDefaultMessage(), 0);
        this.viewer = new TableViewer(parent, (this.supportsMultiSelection() ? 2 : 4) | 0x800);
        Table table = this.viewer.getTable();
        new TableColumn(table, 16384);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        table.setLayout((Layout)tableLayout);
        GridData layoutData = new GridData(4, 4, true, true);
        table.setLayoutData((Object)layoutData);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        DelegatingLabelProvider labelProvider = new DelegatingLabelProvider(){

            @Override
            public Image decorateImage(Image image, Object element) {
                return image;
            }
        };
        this.viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)labelProvider, (ILabelDecorator)labelProvider));
        this.createFilterButtons(parent);
        this.configureTableViewer(this.viewer);
        ILocatorModelLookupService service = (ILocatorModelLookupService)this.getModel().getService(ILocatorModelLookupService.class);
        ArrayList<IPeerModel> nodes = new ArrayList<IPeerModel>();
        if (service != null) {
            nodes.addAll(Arrays.asList(service.lkupPeerModelBySupportedServices(null, this.services)));
        }
        this.viewer.setInput(nodes.size() > 0 ? nodes.toArray(new IPeerModel[nodes.size()]) : null);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!AgentSelectionDialog.this.viewer.getSelection().isEmpty()) {
                    AgentSelectionDialog.this.okPressed();
                }
            }
        });
    }

    protected void createFilterButtons(Composite parent) {
        Assert.isNotNull((Object)parent);
        this.showOnlyReachable = new Button(parent, 32);
        SWTControlUtil.setText((Control)this.showOnlyReachable, (String)this.getShowOnlyReachableLabel());
        SWTControlUtil.setSelection((Button)this.showOnlyReachable, (boolean)true);
        this.showOnlyReachable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AgentSelectionDialog.this.viewer.refresh();
                AgentSelectionDialog.this.updateEnablement(AgentSelectionDialog.this.viewer);
            }
        });
    }

    protected String getShowOnlyReachableLabel() {
        return Messages.AgentSelectionDialog_button_showOnlyReachable;
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonBar = super.createButtonBar(parent);
        this.updateEnablement(this.viewer);
        return buttonBar;
    }

    protected void updateEnablement(TableViewer viewer) {
        Assert.isNotNull((Object)viewer);
        Button okButton = this.getButton(0);
        SWTControlUtil.setEnabled((Control)okButton, (viewer.getTable().getItems().length > 0 ? 1 : 0) != 0);
    }

    protected void configureTableViewer(TableViewer viewer) {
        Assert.isNotNull((Object)viewer);
        viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, final Object element) {
                if (element instanceof IPeerModel) {
                    final AtomicInteger state = new AtomicInteger(-1);
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            state.set(((IPeerModel)element).getIntProperty("state"));
                        }
                    };
                    if (Protocol.isDispatchThread()) {
                        runnable.run();
                    } else {
                        Protocol.invokeAndWait((Runnable)runnable);
                    }
                    boolean isShowOnlyReachable = SWTControlUtil.getSelection((Button)AgentSelectionDialog.this.showOnlyReachable);
                    if (isShowOnlyReachable) {
                        return state.get() == 1 || state.get() == 0 || state.get() == 4;
                    }
                }
                return true;
            }
        });
    }

    protected String getDialogTitle() {
        return Messages.AgentSelectionDialog_dialogTitle;
    }

    protected String getTitle() {
        return Messages.AgentSelectionDialog_title;
    }

    protected String getDefaultMessage() {
        return Messages.AgentSelectionDialog_message;
    }

    protected ILocatorModel getModel() {
        return Model.getModel();
    }

    public ISelection getSelection() {
        return this.selection;
    }

    protected void okPressed() {
        this.selection = this.viewer.getSelection();
        super.okPressed();
    }

    protected void cancelPressed() {
        this.selection = null;
        super.cancelPressed();
    }
}

