/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.handler;

import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IURIPersistenceService;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.statushandler.StatusHandlerUtil;
import org.eclipse.tcf.te.tcf.core.peers.Peer;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelRefreshService;
import org.eclipse.tcf.te.tcf.locator.model.Model;
import org.eclipse.tcf.te.tcf.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.ui.help.IContextHelpIds;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.ui.views.Managers;
import org.eclipse.tcf.te.ui.views.interfaces.categories.ICategorizable;
import org.eclipse.ui.handlers.HandlerUtil;

public class OfflineCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        final ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection != null) {
            this.makeAvailableOffline(selection, (ICallback)new Callback(){

                protected void internalDone(Object caller, IStatus status) {
                    if (status.getSeverity() == 4) {
                        StatusHandlerUtil.handleStatus((IStatus)status, (Object)selection, null, (String)Messages.OfflineCommandHandler_error_title, (String)IContextHelpIds.MESSAGE_MAKEOFFLINE_FAILED, (Object)((Object)OfflineCommandHandler.this), null);
                    }
                    Protocol.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ILocatorModelRefreshService service = (ILocatorModelRefreshService)Model.getModel().getService(ILocatorModelRefreshService.class);
                            if (service != null) {
                                service.refresh(null);
                            }
                        }
                    });
                }
            });
        }
        return null;
    }

    public boolean canMakeAvailableOffline(ISelection selection) {
        Assert.isNotNull((Object)selection);
        boolean enabled = false;
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            enabled = true;
            for (Object element : (IStructuredSelection)selection) {
                if (!(element instanceof IPeerModel)) {
                    enabled = false;
                    break;
                }
                boolean isStatic = this.isStatic((IPeerModel)element);
                if (isStatic) {
                    enabled = false;
                }
                if (!enabled) break;
            }
        }
        return enabled;
    }

    private boolean isStatic(final IPeerModel node) {
        Assert.isNotNull((Object)node);
        final AtomicBoolean isStatic = new AtomicBoolean();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                isStatic.set(node.isStatic());
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeAndWait((Runnable)runnable);
        }
        return isStatic.get();
    }

    public void makeAvailableOffline(final ISelection selection, final ICallback callback) {
        Assert.isNotNull((Object)selection);
        Assert.isNotNull((Object)callback);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                IStatus status = Status.OK_STATUS;
                if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
                    for (Object element : (IStructuredSelection)selection) {
                        Assert.isTrue((boolean)(element instanceof IPeerModel));
                        IPeerModel node = (IPeerModel)element;
                        HashMap attrs = new HashMap();
                        attrs.putAll(node.getPeer().getAttributes());
                        attrs.remove("AgentID");
                        attrs.remove("ServiceManagerID");
                        attrs.remove("ServerManagerID");
                        attrs.remove("UserName");
                        attrs.remove("OSName");
                        try {
                            IURIPersistenceService service = (IURIPersistenceService)ServiceManager.getInstance().getService(IURIPersistenceService.class);
                            if (service == null) {
                                throw new IOException("Persistence service instance unavailable.");
                            }
                            service.write((Object)new Peer(attrs), null);
                            ICategorizable categorizable = (ICategorizable)node.getAdapter(ICategorizable.class);
                            if (categorizable == null) {
                                categorizable = (ICategorizable)Platform.getAdapterManager().getAdapter((Object)node, ICategorizable.class);
                            }
                            Assert.isNotNull((Object)categorizable);
                            Managers.getCategoryManager().remove("org.eclipse.tcf.te.ui.views.category.neighborhood", categorizable.getId());
                        }
                        catch (IOException e) {
                            status = new Status(4, UIPlugin.getUniqueIdentifier(), NLS.bind((String)Messages.OfflineCommandHandler_error_makeOffline_failed, (Object)node.getName(), (Object)e.getLocalizedMessage()), (Throwable)e);
                        }
                        if (status != null) break;
                    }
                }
                callback.done((Object)OfflineCommandHandler.this, status);
            }
        };
        Protocol.invokeLater((Runnable)runnable);
    }
}

