/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.internal.adapters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.concurrent.util.ExecutorsUtil;
import org.eclipse.tcf.te.runtime.interfaces.IConditionTester;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IURIPersistenceService;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.tcf.core.peers.Peer;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelLookupService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelRefreshService;
import org.eclipse.tcf.te.tcf.locator.model.Model;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.ui.dialogs.RenameDialog;
import org.eclipse.tcf.te.ui.views.ViewsUtil;
import org.eclipse.tcf.te.ui.views.interfaces.IEditorSaveAsAdapter;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;

public class EditorSaveAsAdapter
implements IEditorSaveAsAdapter {
    public boolean isSaveAsAllowed(IEditorInput input) {
        IPeerModel peerModel = (IPeerModel)input.getAdapter(IPeerModel.class);
        if (peerModel != null) {
            return peerModel.isStatic();
        }
        return false;
    }

    public Object doSaveAs(IEditorInput input) {
        IPeerModel model = (IPeerModel)input.getAdapter(IPeerModel.class);
        if (model != null) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            final HashMap<String, String> attrs = new HashMap<String, String>(model.getPeer().getAttributes());
            attrs.put("ID", UUID.randomUUID().toString());
            List<String> usedNames = this.getUsedNameList();
            String title = Messages.EditorSaveAsAdapter_title;
            String prompt = Messages.EditorSaveAsAdapter_message;
            String usedError = Messages.EditorSaveAsAdapter_nameInUse_error;
            String label = Messages.EditorSaveAsAdapter_label;
            RenameDialog dialog = new RenameDialog(shell, title, null, prompt, usedError, null, label, (String)attrs.get("Name"), null, usedNames.toArray(new String[usedNames.size()]), null);
            if (dialog.open() != 0) {
                return null;
            }
            attrs.put("Name", dialog.getNewName());
            attrs.remove("URI.transient");
            try {
                IURIPersistenceService persistenceService = (IURIPersistenceService)ServiceManager.getInstance().getService(IURIPersistenceService.class);
                if (persistenceService == null) {
                    throw new IOException("Persistence service instance unavailable.");
                }
                persistenceService.write((Object)new Peer(attrs), null);
                final AtomicReference newPeer = new AtomicReference();
                final Callback cb = new Callback(){

                    protected void internalDone(Object caller, IStatus status) {
                        IPeerModel peerNode = ((ILocatorModelLookupService)Model.getModel().getService(ILocatorModelLookupService.class)).lkupPeerModelById((String)attrs.get("ID"));
                        newPeer.set(peerNode);
                        if (peerNode != null) {
                            ViewsUtil.refresh((String)"org.eclipse.tcf.te.ui.views.View");
                            StructuredSelection selection = new StructuredSelection((Object)peerNode);
                            ViewsUtil.setSelection((String)"org.eclipse.tcf.te.ui.views.View", (ISelection)selection);
                        }
                    }
                };
                Protocol.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ILocatorModelRefreshService service = (ILocatorModelRefreshService)Model.getModel().getService(ILocatorModelRefreshService.class);
                        if (service != null) {
                            service.refresh((ICallback)cb);
                        }
                    }
                });
                ExecutorsUtil.waitAndExecute((long)0L, (IConditionTester)cb.getDoneConditionTester(null));
                return newPeer.get();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    protected List<String> getUsedNameList() {
        final ArrayList<String> usedNames = new ArrayList<String>();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                IPeerModel[] peers;
                IPeerModel[] iPeerModelArray = peers = Model.getModel().getPeers();
                int n = peers.length;
                int n2 = 0;
                while (n2 < n) {
                    IPeerModel peerModel = iPeerModelArray[n2];
                    if (peerModel.isStatic()) {
                        String name = peerModel.getPeer().getName();
                        Assert.isNotNull((Object)name);
                        if (!"".equals(name) && !usedNames.contains(name)) {
                            usedNames.add(name.trim().toUpperCase());
                        }
                    }
                    ++n2;
                }
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeAndWait((Runnable)runnable);
        }
        return usedNames;
    }
}

