/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.navigator.dnd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IURIPersistenceService;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.tcf.core.peers.Peer;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelLookupService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelRefreshService;
import org.eclipse.tcf.te.tcf.locator.model.Model;
import org.eclipse.tcf.te.ui.views.Managers;
import org.eclipse.tcf.te.ui.views.interfaces.ICategory;
import org.eclipse.tcf.te.ui.views.interfaces.IRoot;
import org.eclipse.tcf.te.ui.views.interfaces.categories.ICategorizable;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonNavigator;

public class CommonDnD {
    public static boolean isDraggable(IStructuredSelection selection) {
        Object[] objects;
        if (selection.isEmpty()) {
            return false;
        }
        Object[] objectArray = objects = selection.toArray();
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (!CommonDnD.isDraggableObject(object)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean isDraggableObject(Object object) {
        return object instanceof IPeerModel;
    }

    public static boolean dropLocalSelection(CommonDropAdapter dropAdapter, Object target, int operations, IStructuredSelection selection) {
        boolean result = false;
        boolean refreshModel = false;
        ICategory catToSelect = null;
        Peer elementToSelect = null;
        for (Object element : selection) {
            ICategory[] parentCategories;
            ICategorizable categorizable;
            if (!CommonDnD.isDraggableObject(element) || (categorizable = CommonDnD.getCategorizable(element)) == null || !CommonDnD.isDraggableObject(element) || (parentCategories = CommonDnD.getParentCategories(element, (ISelection)selection)).length == 0) continue;
            ICategory[] iCategoryArray = parentCategories;
            int n = parentCategories.length;
            int n2 = 0;
            while (n2 < n) {
                ICategory parentCategory = iCategoryArray[n2];
                if (target instanceof ICategory) {
                    ICategory category = (ICategory)target;
                    if (element instanceof IPeerModel && category.getId().equals(parentCategory.getId()) && ((IPeerModel)element).isStatic()) {
                        List<String> usedNames = CommonDnD.getUsedNames();
                        HashMap<String, String> attrs = new HashMap<String, String>(((IPeerModel)element).getPeer().getAttributes());
                        attrs.put("ID", UUID.randomUUID().toString());
                        attrs.remove("URI.transient");
                        int i = 0;
                        String baseName = (String)attrs.get("Name");
                        baseName = baseName.replaceAll("\\s*\\([\\d*]\\)$", "");
                        String name = String.valueOf(baseName) + " (" + i + ")";
                        while (usedNames.contains(name.toUpperCase())) {
                            name = String.valueOf(baseName) + " (" + ++i + ")";
                        }
                        attrs.put("Name", name);
                        Peer newPeer = new Peer(attrs);
                        IURIPersistenceService persistenceService = (IURIPersistenceService)ServiceManager.getInstance().getService(IURIPersistenceService.class);
                        if (persistenceService != null) {
                            try {
                                persistenceService.write((Object)newPeer, null);
                                refreshModel = true;
                                if (catToSelect == null || elementToSelect == null) {
                                    catToSelect = category;
                                    elementToSelect = newPeer;
                                }
                                result = true;
                            }
                            catch (Exception exception) {}
                        }
                    } else if (!Managers.getCategoryManager().isLinked(category.getId(), categorizable.getId()) && categorizable.isValid(ICategorizable.OPERATION.ADD, parentCategory, category)) {
                        Managers.getCategoryManager().add(category.getId(), categorizable.getId());
                        if (catToSelect == null || elementToSelect == null) {
                            catToSelect = category;
                            elementToSelect = (Peer)element;
                        }
                        result = true;
                    }
                } else if (target instanceof IRoot && Managers.getCategoryManager().isLinked(parentCategory.getId(), categorizable.getId())) {
                    Managers.getCategoryManager().remove(parentCategory.getId(), categorizable.getId());
                    catToSelect = parentCategory;
                    result = true;
                }
                ++n2;
            }
        }
        if (result) {
            final CommonNavigator cNav = CommonDnD.getCommonNavigator();
            if (refreshModel) {
                final ICategory finalCat = catToSelect;
                final Peer finalElement = elementToSelect;
                final IPeer finalNewPeer = elementToSelect instanceof IPeer ? (IPeer)elementToSelect : null;
                final ILocatorModelRefreshService service = (ILocatorModelRefreshService)Model.getModel().getService(ILocatorModelRefreshService.class);
                if (service != null) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            service.refresh((ICallback)new Callback(){

                                protected void internalDone(Object caller, IStatus status) {
                                    ILocatorModelLookupService service;
                                    Object peerModel = null;
                                    if (finalNewPeer != null && (service = (ILocatorModelLookupService)Model.getModel().getService(ILocatorModelLookupService.class)) != null) {
                                        peerModel = service.lkupPeerModelById(finalNewPeer.getID());
                                    }
                                    CommonDnD.refresh(cNav, finalCat, peerModel != null ? peerModel : finalElement);
                                }
                            });
                        }
                    };
                    if (Protocol.isDispatchThread()) {
                        runnable.run();
                    } else {
                        Protocol.invokeLater((Runnable)runnable);
                    }
                } else {
                    CommonDnD.refresh(cNav, catToSelect, elementToSelect);
                }
            } else {
                CommonDnD.refresh(cNav, catToSelect, elementToSelect);
            }
        }
        return result;
    }

    protected static void refresh(final CommonNavigator cNav, final ICategory category, final Object element) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                cNav.getCommonViewer().refresh();
                if (category != null) {
                    cNav.getCommonViewer().setSelection((ISelection)new StructuredSelection((Object)category), true);
                    cNav.getCommonViewer().expandToLevel((Object)category, 1);
                }
                if (element != null) {
                    cNav.getCommonViewer().setSelection((ISelection)new TreeSelection(new TreePath(new Object[]{category, element})), true);
                }
            }
        };
        if (PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
        }
    }

    protected static CommonNavigator getCommonNavigator() {
        final AtomicReference viewPart = new AtomicReference();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null) {
                    try {
                        viewPart.set(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.tcf.te.ui.views.View"));
                    }
                    catch (Exception exception) {}
                }
            }
        };
        if (PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().getDisplay().syncExec(runnable);
        }
        return viewPart.get() instanceof CommonNavigator ? (CommonNavigator)viewPart.get() : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean validateLocalSelectionDrop(CommonDropAdapter dropAdapter, Object target, int operation, TransferData transferType) {
        int overrideOperation = -1;
        boolean valid = false;
        LocalSelectionTransfer transfer = LocalSelectionTransfer.getTransfer();
        IStructuredSelection selection = (IStructuredSelection)transfer.getSelection();
        boolean allow = true;
        boolean link = false;
        boolean copy = false;
        Iterator iterator = selection.iterator();
        block0: while (allow && iterator.hasNext()) {
            Object element = iterator.next();
            if (!CommonDnD.isDraggableObject(element)) {
                allow = false;
                break;
            }
            ICategorizable categorizable = CommonDnD.getCategorizable(element);
            if (categorizable == null || !CommonDnD.isDraggableObject(element)) {
                allow = false;
                break;
            }
            ICategory[] parentCategories = CommonDnD.getParentCategories(element, (ISelection)selection);
            if (parentCategories.length == 0) {
                allow = false;
            }
            ICategory[] iCategoryArray = parentCategories;
            int n = parentCategories.length;
            int n2 = 0;
            while (n2 < n) {
                block13: {
                    ICategory parentCategory;
                    block14: {
                        parentCategory = iCategoryArray[n2];
                        if (!(target instanceof ICategory)) break block14;
                        ICategory category = (ICategory)target;
                        if (!link && element instanceof IPeerModel && category.getId().equals(parentCategory.getId()) && ((IPeerModel)element).isStatic()) {
                            overrideOperation = 1;
                            copy = true;
                            break block13;
                        } else if (!copy && !Managers.getCategoryManager().isLinked(category.getId(), categorizable.getId()) && categorizable.isValid(ICategorizable.OPERATION.ADD, parentCategory, category)) {
                            overrideOperation = 4;
                            link = true;
                            break block13;
                        } else {
                            allow = false;
                            continue block0;
                        }
                    }
                    if (target instanceof IRoot) {
                        overrideOperation = 16;
                        if (!Managers.getCategoryManager().isLinked(parentCategory.getId(), categorizable.getId())) {
                            allow = false;
                            continue block0;
                        }
                    }
                }
                ++n2;
            }
        }
        valid = allow;
        if (dropAdapter == null) return valid;
        if (!valid) {
            dropAdapter.overrideOperation(0);
            return valid;
        }
        if (overrideOperation != -1) {
            dropAdapter.overrideOperation(overrideOperation);
            return valid;
        }
        dropAdapter.overrideOperation(operation);
        return valid;
    }

    protected static ICategory[] getParentCategories(Object element, ISelection selection) {
        TreePath[] pathes;
        ArrayList<ICategory> candidates = new ArrayList<ICategory>();
        TreePath[] treePathArray = pathes = selection instanceof TreeSelection ? ((TreeSelection)selection).getPathsFor(element) : null;
        if (pathes != null && pathes.length > 0) {
            TreePath[] treePathArray2 = pathes;
            int n = pathes.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath path = treePathArray2[n2];
                TreePath parentPath = path.getParentPath();
                while (parentPath != null) {
                    if (parentPath.getLastSegment() instanceof ICategory && !candidates.contains(parentPath.getLastSegment())) {
                        candidates.add((ICategory)parentPath.getLastSegment());
                        break;
                    }
                    parentPath = parentPath.getParentPath();
                }
                ++n2;
            }
        }
        return candidates.toArray(new ICategory[candidates.size()]);
    }

    protected static ICategorizable getCategorizable(Object element) {
        ICategorizable categorizable;
        ICategorizable iCategorizable = categorizable = element instanceof IAdaptable ? (ICategorizable)((IAdaptable)element).getAdapter(ICategorizable.class) : null;
        if (categorizable == null) {
            categorizable = (ICategorizable)Platform.getAdapterManager().getAdapter(element, ICategorizable.class);
        }
        return categorizable;
    }

    protected static List<String> getUsedNames() {
        final ArrayList<String> usedNames = new ArrayList<String>();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                IPeerModel[] peers;
                IPeerModel[] iPeerModelArray = peers = Model.getModel().getPeers();
                int n = peers.length;
                int n2 = 0;
                while (n2 < n) {
                    IPeerModel peerModel = iPeerModelArray[n2];
                    if (peerModel.isStatic()) {
                        String name = peerModel.getPeer().getName();
                        Assert.isNotNull((Object)name);
                        if (!"".equals(name) && !usedNames.contains(name)) {
                            usedNames.add(name.trim().toUpperCase());
                        }
                    }
                    ++n2;
                }
            }
        };
        if (Protocol.isDispatchThread()) {
            runnable.run();
        } else {
            Protocol.invokeAndWait((Runnable)runnable);
        }
        return usedNames;
    }
}

