/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.sections;

import java.util.HashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tcf.core.TransientPeer;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.runtime.services.interfaces.ISimulatorService;
import org.eclipse.tcf.te.tcf.core.peers.Peer;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.nodes.PeerRedirector;
import org.eclipse.tcf.te.tcf.locator.utils.SimulatorUtils;
import org.eclipse.tcf.te.tcf.ui.controls.SimulatorTypeSelectionControl;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.ui.forms.parts.AbstractSection;
import org.eclipse.tcf.te.ui.interfaces.data.IDataExchangeNode;
import org.eclipse.tcf.te.ui.jface.interfaces.IValidatingContainer;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;
import org.eclipse.tcf.te.ui.views.editor.pages.AbstractEditorPage;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class TargetSelectorSection
extends AbstractSection
implements IDataExchangeNode {
    Button real;
    SimulatorTypeSelectionControl type;
    IPeerModel od;
    final IPropertiesContainer odc = new PropertiesContainer();
    final IPropertiesContainer wc = new PropertiesContainer();
    protected static final int SELECTION_REAL = 0;
    protected static final int SELECTION_SIM = 1;

    public TargetSelectorSection(IManagedForm form, Composite parent) {
        super(form, parent, 0);
        this.createClient(this.getSection(), form.getToolkit());
    }

    public TargetSelectorSection(IManagedForm form, Composite parent, int style) {
        super(form, parent, style);
        this.createClient(this.getSection(), form.getToolkit());
    }

    public Object getOriginalData() {
        return this.od;
    }

    public void dispose() {
        if (this.type != null) {
            this.type.dispose();
            this.type = null;
        }
        super.dispose();
    }

    public IValidatingContainer getValidatingContainer() {
        Object container = this.getManagedForm().getContainer();
        return container instanceof IValidatingContainer ? (IValidatingContainer)container : null;
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        Assert.isNotNull((Object)section);
        Assert.isNotNull((Object)toolkit);
        section.setText(Messages.TargetSelectorSection_title);
        if (section.getParent().getLayout() instanceof GridLayout) {
            section.setLayoutData((Object)new GridData(4, 4, true, false));
        }
        Composite client = this.createClientContainer((Composite)section, 3, toolkit);
        Assert.isNotNull((Object)client);
        section.setClient((Control)client);
        this.real = toolkit.createButton(client, Messages.TargetSelectorSection_button_enableReal, 16);
        GridData gd = new GridData(1, 0x1000000, false, false);
        gd.horizontalSpan = 3;
        this.real.setSelection(true);
        this.real.setLayoutData((Object)gd);
        this.real.setBackground(client.getBackground());
        this.real.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TargetSelectorSection.this.real.getSelection()) {
                    TargetSelectorSection.this.onSelectionChanged(0);
                }
                TargetSelectorSection.this.getValidatingContainer().validate();
                TargetSelectorSection.this.dataChanged(null);
            }
        });
        this.type = new SimulatorTypeSelectionControl(this){

            @Override
            protected void onLabelControlSelectedChanged() {
                super.onLabelControlSelectedChanged();
                if (TargetSelectorSection.this.type.isLabelControlSelected()) {
                    TargetSelectorSection.this.onSelectionChanged(1);
                    if (!TargetSelectorSection.this.isUpdating()) {
                        TargetSelectorSection.this.onSimulatorChanged(false, true, this.getSelectedSimulatorId(), this.getSelectedSimulatorId(), this.getSimulatorConfig(), this.getSimulatorConfig());
                    }
                }
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                String newId = this.getSelectedSimulatorId();
                TargetSelectorSection.this.onSimulatorChanged(this.isLabelControlSelected(), this.isLabelControlSelected(), null, newId, this.getSimulatorConfig(), this.getSimulatorConfig());
            }

            @Override
            protected void onButtonControlSelected() {
                String oldConfig = this.getSimulatorConfig();
                super.onButtonControlSelected();
                String newConfig = this.getSimulatorConfig();
                if (newConfig != null && !newConfig.equals(oldConfig) || newConfig == null && oldConfig != null) {
                    TargetSelectorSection.this.onSimulatorChanged(this.isLabelControlSelected(), this.isLabelControlSelected(), this.getSelectedSimulatorId(), this.getSelectedSimulatorId(), oldConfig, newConfig);
                }
            }
        };
        this.type.setLabelIsButton(true);
        this.type.setLabelButtonStyle(16);
        this.type.setEditFieldLabel(Messages.TargetSelectorSection_button_enableSimulator);
        this.type.setParentControlIsInnerPanel(true);
        this.type.setupPanel(client);
        this.updateEnablement();
        this.setIsUpdating(false);
    }

    protected void onSelectionChanged(int selectionType) {
    }

    protected void onSimulatorChanged(boolean oldEnabled, boolean newEnabled, String oldType, String newType, String oldConfig, String newConfig) {
    }

    public void setActive(boolean active) {
        if (active) {
            Object node;
            if (this.getManagedForm().getContainer() instanceof AbstractEditorPage && !((AbstractEditorPage)this.getManagedForm().getContainer()).isDirty() && (node = ((AbstractEditorPage)this.getManagedForm().getContainer()).getEditorInputNode()) instanceof IPeerModel) {
                this.setupData((IPeerModel)node);
            }
        } else {
            this.dataChanged(null);
        }
    }

    public void setupData(IPropertiesContainer data) {
        this.setIsUpdating(true);
        if (this.type != null) {
            this.type.initialize(this.od);
            this.type.setSelectedSimulatorId(data.getStringProperty("SimulatorType"));
            this.type.setSimulatorConfig(data.getStringProperty("SimulatorProperties"));
            this.type.setLabelControlSelection(data.getBooleanProperty("SimulatorEnabled"));
        }
        SWTControlUtil.setSelection((Button)this.real, (!data.getBooleanProperty("SimulatorEnabled") ? 1 : 0) != 0);
        this.onSelectionChanged(data.getBooleanProperty("SimulatorEnabled") ? 1 : 0);
        this.setIsUpdating(false);
        this.dataChanged(null);
    }

    public void setupData(final IPeerModel node) {
        if (this.isDirty()) {
            return;
        }
        boolean updateWidgets = true;
        if (node == null && this.od == null || node != null && node.equals(this.od)) {
            updateWidgets = false;
        }
        PropertiesContainer previousOdc = new PropertiesContainer();
        previousOdc.setProperties(this.odc.getProperties());
        this.od = node;
        this.odc.clearProperties();
        this.wc.clearProperties();
        if (node == null) {
            return;
        }
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                TargetSelectorSection.this.odc.setProperty("SimulatorEnabled", node.getPeer().getAttributes().get("SimulatorEnabled"));
                TargetSelectorSection.this.odc.setProperty("SimulatorProperties", node.getPeer().getAttributes().get("SimulatorProperties"));
                TargetSelectorSection.this.odc.setProperty("SimulatorType", node.getPeer().getAttributes().get("SimulatorType"));
                TargetSelectorSection.this.wc.setProperties(TargetSelectorSection.this.odc.getProperties());
            }
        });
        if (!previousOdc.getProperties().equals(this.odc.getProperties())) {
            updateWidgets = true;
        }
        if (updateWidgets) {
            this.setupData(this.wc);
        } else {
            this.dataChanged(null);
        }
    }

    public void extractData(IPropertiesContainer data) {
        Assert.isNotNull((Object)data);
        if (this.type != null) {
            data.setProperty("SimulatorEnabled", this.type.isLabelControlSelected());
            data.setProperty("SimulatorType", (Object)this.type.getSelectedSimulatorId());
            data.setProperty("SimulatorProperties", (Object)this.type.getSimulatorConfig());
        }
    }

    public void extractData(final IPeerModel node) {
        if (node == null) {
            return;
        }
        this.extractData(this.wc);
        if (this.odc.equals(this.wc)) {
            return;
        }
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                boolean isSimEnabled = TargetSelectorSection.this.wc.getBooleanProperty("SimulatorEnabled");
                String configs = TargetSelectorSection.this.wc.getStringProperty("SimulatorProperties");
                String type = TargetSelectorSection.this.wc.getStringProperty("SimulatorType");
                IPeer oldPeer = node.getPeer();
                HashMap<String, String> attributes = new HashMap<String, String>(oldPeer.getAttributes());
                if (isSimEnabled) {
                    attributes.put("SimulatorEnabled", Boolean.toString(isSimEnabled));
                } else {
                    attributes.remove("SimulatorEnabled");
                }
                if (configs != null) {
                    attributes.put("SimulatorProperties", configs);
                } else {
                    attributes.remove("SimulatorProperties");
                }
                if (type != null) {
                    attributes.put("SimulatorType", type);
                } else {
                    attributes.remove("SimulatorType");
                }
                if (oldPeer instanceof TransientPeer && !(oldPeer instanceof PeerRedirector) && !(oldPeer instanceof Peer)) {
                    Peer newPeer = new Peer(attributes);
                    node.setProperty("instance", (Object)newPeer);
                } else if (oldPeer instanceof PeerRedirector) {
                    ((PeerRedirector)oldPeer).updateAttributes(attributes);
                } else if (oldPeer instanceof Peer) {
                    ((Peer)oldPeer).updateAttributes(attributes);
                }
            }
        });
    }

    public boolean isValid() {
        if (this.isUpdating()) {
            return true;
        }
        boolean valid = super.isValid();
        if (this.type != null && this.type.isLabelControlSelected()) {
            valid &= this.type.isValid();
            if (this.type.getMessageType() > this.getMessageType()) {
                this.setMessage(this.type.getMessage(), this.type.getMessageType());
            }
        }
        return valid;
    }

    public void commit(boolean onSave) {
        boolean needsSaving = this.isDirty();
        super.commit(onSave);
        if (!onSave || !needsSaving) {
            return;
        }
        this.extractData((IPeerModel)this.getManagedForm().getInput());
    }

    public void dataChanged(TypedEvent e) {
        if (this.isUpdating()) {
            return;
        }
        boolean isDirty = false;
        if (this.type != null) {
            boolean oldEnabled = this.odc.getBooleanProperty("SimulatorEnabled");
            isDirty |= oldEnabled ^ this.type.isLabelControlSelected();
            if (this.type.isLabelControlSelected()) {
                String newType = this.type.getSelectedSimulatorId();
                String oldType = this.odc.getStringProperty("SimulatorType");
                isDirty = newType == null || "".equals(newType) ? (isDirty |= oldType != null && !"".equals(oldType)) : (isDirty |= !newType.equals(oldType));
                String newConfig = this.type.getSimulatorConfig();
                String oldConfig = this.odc.getStringProperty("SimulatorProperties");
                isDirty = newConfig == null || "".equals(newConfig) ? (isDirty |= oldConfig != null && !"".equals(oldConfig)) : (isDirty |= !newConfig.equals(oldConfig));
            }
        }
        this.markDirty(isDirty);
        this.updateEnablement();
    }

    public Object getAdapter(Class adapter) {
        if (SimulatorTypeSelectionControl.class.equals((Object)adapter)) {
            return this.type;
        }
        return super.getAdapter(adapter);
    }

    protected void updateEnablement() {
        SimulatorUtils.Result simulator = this.od != null ? SimulatorUtils.getSimulatorService((IPeerModel)this.od) : null;
        boolean enabled = simulator == null || simulator.service.getState((Object)this.od, simulator.settings) == ISimulatorService.State.Stopped;
        SWTControlUtil.setEnabled((Control)this.real, (boolean)enabled);
        if (this.type != null) {
            SWTControlUtil.setEnabled((Control)this.type.getEditFieldControl(), (this.type.isLabelControlSelected() && enabled ? 1 : 0) != 0);
        }
    }
}

