/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.wizards;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepContext;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepperService;
import org.eclipse.tcf.te.runtime.stepper.job.StepperJob;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.ui.wizards.NewTargetWizard;
import org.eclipse.tcf.te.tcf.ui.wizards.pages.AbstractConfigWizardPage;
import org.eclipse.ui.IWorkbench;

public abstract class AbstractConfigWizard
extends NewTargetWizard {
    @Override
    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.setWindowTitle(this.getWizardTitle());
        this.setNeedsProgressMonitor(true);
    }

    protected abstract String getWizardTitle();

    protected abstract AbstractConfigWizardPage getConfigWizardPage();

    @Override
    protected void postPerformFinish(IPeerModel peerModel) {
        Assert.isNotNull((Object)peerModel);
        boolean autoConnect = true;
        if (System.getProperty("NoWizardAutoConnect") != null) {
            autoConnect &= !Boolean.getBoolean("NoWizardAutoConnect");
        }
        if (!(autoConnect &= !UIPlugin.getDefault().getPreferenceStore().getBoolean("NoWizardAutoConnect"))) {
            return;
        }
        IStepperService service = (IStepperService)ServiceManager.getInstance().getService((Object)peerModel, IStepperService.class);
        if (service != null) {
            String stepGroupId = service.getStepGroupId((Object)peerModel, "connect");
            IStepContext stepContext = service.getStepContext((Object)peerModel, "connect");
            String name = service.getStepGroupName((Object)peerModel, "connect");
            if (stepGroupId != null && stepContext != null) {
                PropertiesContainer data = new PropertiesContainer();
                StepperJob job = new StepperJob(name != null ? name : "", stepContext, (IPropertiesContainer)data, stepGroupId, "connect", true);
                job.schedule();
            }
        }
    }
}

