/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.controls.validator;

import java.math.BigInteger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.te.ui.controls.validator.RegexValidator;

public class HexValidator
extends RegexValidator {
    public static final int ATTR_ALLOW_DECIMAL = 4;
    public static final int ATTR_ALLOW_NEGATIVE_DECIMAL = 8;
    public static final int ATTR_ALLOW_NEGATIVE_HEX = 16;
    public static final String ERROR_INVALID_VALUE_RANGE = "HexValidator_Error_InvalidValueRange";
    protected static final String HEX_REGEX = "@NEGATIVE@(0(x|X)[0-9a-fA-F]{@BYTES_MIN@,@BYTES_MAX@})|0";
    protected static final String NUMBER_REGEX = "@NEGATIVE@([0-9]*)";
    private int minBytes = 0;
    private int maxBytes = 8;
    private boolean isHex = false;
    private boolean isDecimal = false;

    public HexValidator(int attributes, int minBytes, int maxBytes) {
        super(attributes, HexValidator.getRegEx(attributes, minBytes, maxBytes));
        this.minBytes = minBytes;
        this.maxBytes = maxBytes;
    }

    public HexValidator(int attributes, int bytes) {
        super(attributes, HexValidator.getRegEx(attributes, bytes, bytes));
        this.minBytes = bytes;
        this.maxBytes = bytes;
    }

    private static String getRegEx(int attributes, int minBytes, int maxBytes) {
        String regex = String.valueOf(HexValidator.isAttribute(4, attributes) ? String.valueOf(NUMBER_REGEX.replaceAll("@NEGATIVE@", HexValidator.isAttribute(8, attributes) ? "-?" : "")) + "|" : "") + HEX_REGEX;
        regex = regex.replaceAll("@NEGATIVE@", HexValidator.isAttribute(16, attributes) ? "-?" : "");
        regex = regex.replaceAll("@BYTES_MIN@", "" + minBytes);
        regex = regex.replaceAll("@BYTES_MAX@", "" + maxBytes);
        return regex;
    }

    public void setBounds(int minBytes, int maxBytes) {
        Assert.isTrue((minBytes >= 0 && maxBytes >= 0 && minBytes <= maxBytes ? 1 : 0) != 0);
        this.setRegularExpression(HexValidator.getRegEx(this.getAttributes(), minBytes, maxBytes));
        this.minBytes = minBytes;
        this.maxBytes = maxBytes;
    }

    public boolean isHex() {
        return this.isHex;
    }

    public boolean isDecimal() {
        return this.isDecimal;
    }

    @Override
    public boolean isValid(String newText) {
        this.isHex = false;
        this.isDecimal = false;
        boolean valid = super.isValid(newText);
        if (valid) {
            String hexRegex = HEX_REGEX;
            hexRegex = hexRegex.replaceAll("@NEGATIVE@", this.isAttribute(16) ? "-?" : "");
            hexRegex = hexRegex.replaceAll("@BYTES_MIN@", "" + this.minBytes);
            hexRegex = hexRegex.replaceAll("@BYTES_MAX@", "" + this.maxBytes);
            String numberRegex = NUMBER_REGEX;
            numberRegex = numberRegex.replaceAll("@NEGATIVE@", this.isAttribute(8) ? "-?" : "");
            this.isHex = newText.matches(hexRegex);
            this.isDecimal = newText.matches(numberRegex);
        }
        if (valid && this.isAttribute(4) && this.isDecimal()) {
            BigInteger value;
            BigInteger min = this.minBytes > 1 ? BigInteger.valueOf(16L).pow(this.minBytes - 1) : BigInteger.ZERO;
            BigInteger max = BigInteger.valueOf(16L).pow(this.maxBytes);
            BigInteger bigInteger = value = !"".equals(newText) ? HexValidator.decode(newText) : BigInteger.ZERO;
            if (value == null || value.abs().compareTo(min) < 0 || value.abs().compareTo(max) > 0) {
                this.setMessage(this.getMessageText(ERROR_INVALID_VALUE_RANGE), this.getMessageTextType(ERROR_INVALID_VALUE_RANGE, 3));
                valid = this.getMessageType() != 3;
            }
        }
        return valid;
    }

    public static final BigInteger decode(String value) {
        Assert.isNotNull((Object)value);
        BigInteger result = null;
        if (value != null) {
            try {
                result = value.trim().toUpperCase().startsWith("0X") ? new BigInteger(value.substring(2), 16) : new BigInteger(value, 10);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }
}

