/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.views.editor.pages;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tcf.te.runtime.interfaces.IDisposable;
import org.eclipse.tcf.te.ui.forms.CustomFormToolkit;
import org.eclipse.tcf.te.ui.forms.FormLayoutFactory;
import org.eclipse.tcf.te.ui.views.activator.UIPlugin;
import org.eclipse.tcf.te.ui.views.editor.pages.AbstractEditorPage;
import org.eclipse.tcf.te.ui.views.nls.Messages;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.services.IServiceLocator;

public abstract class AbstractCustomFormToolkitEditorPage
extends AbstractEditorPage {
    private CustomFormToolkit toolkit = null;
    private IToolBarManager manager = null;

    protected final CustomFormToolkit getFormToolkit() {
        return this.toolkit;
    }

    protected final void setFormToolkit(CustomFormToolkit toolkit) {
        this.toolkit = toolkit;
    }

    public void dispose() {
        IMenuService service;
        if (this.manager instanceof ContributionManager && (service = (IMenuService)this.getSite().getService(IMenuService.class)) != null) {
            service.releaseContributions((ContributionManager)this.manager);
        }
        if (this.toolkit != null) {
            this.toolkit.dispose();
            this.toolkit = null;
        }
        super.dispose();
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        Assert.isNotNull((Object)managedForm);
        this.toolkit = new CustomFormToolkit(managedForm.getToolkit());
        this.configureManagedForm(managedForm);
        this.doCreateFormContent(managedForm.getForm().getBody(), this.getFormToolkit());
        managedForm.reflow(true);
    }

    protected void configureManagedForm(IManagedForm managedForm) {
        Assert.isNotNull((Object)managedForm);
        Composite body = managedForm.getForm().getBody();
        body.setLayout((Layout)FormLayoutFactory.createFormGridLayout((boolean)false, (int)1));
        if (this.getContextHelpId() != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)managedForm.getForm(), this.getContextHelpId());
        }
        this.getFormToolkit().getFormToolkit().decorateFormHeading(managedForm.getForm().getForm());
        if (this.getFormTitle() != null) {
            managedForm.getForm().getForm().setText(this.getFormTitle());
        }
        managedForm.getForm().getForm().setImage(this.getFormImage());
        this.manager = managedForm.getForm().getForm().getToolBarManager();
        this.manager.add((IContributionItem)new Separator("additions"));
        this.createToolbarContributionItems(this.manager);
        IMenuService service = (IMenuService)this.getSite().getService(IMenuService.class);
        if (service != null && this.manager instanceof ContributionManager) {
            service.populateContributionManager((ContributionManager)this.manager, "toolbar:" + this.getId());
        }
        this.manager.update(true);
    }

    protected String getContextHelpId() {
        return null;
    }

    protected String getFormTitle() {
        return null;
    }

    protected Image getFormImage() {
        return null;
    }

    protected void createToolbarContributionItems(IToolBarManager manager) {
        Action helpAction;
        Action applyAction;
        Assert.isNotNull((Object)manager);
        manager.add((IContributionItem)new Separator("group.connect"));
        manager.add((IContributionItem)new Separator("group.launch"));
        manager.add((IContributionItem)new GroupMarker("group.launch.rundebug"));
        manager.add((IContributionItem)new GroupMarker("group.launch.modes"));
        manager.add((IContributionItem)new GroupMarker("group.launch.additions"));
        manager.add((IContributionItem)new Separator("group.showIn"));
        if (this.hasShowInSystemManagementAction()) {
            manager.add((IContributionItem)new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)PlatformUI.getWorkbench(), "org.eclipse.tcf.te.ui.views.command.showIn.systemManagement", "org.eclipse.tcf.te.ui.command.showIn.systemManagement", 8)));
        }
        manager.add((IContributionItem)new Separator("group.save"));
        if (this.hasApplyAction() && (applyAction = this.doCreateApplyAction((IEditorPart)this.getEditor())) != null) {
            manager.add((IAction)applyAction);
        }
        manager.add((IContributionItem)new Separator("group.help"));
        if (this.getContextHelpId() != null && (helpAction = this.doCreateHelpAction(this.getContextHelpId())) != null) {
            manager.add((IAction)helpAction);
        }
    }

    protected Action doCreateHelpAction(String contextHelpId) {
        Assert.isNotNull((Object)contextHelpId);
        return new HelpAction(contextHelpId);
    }

    protected Action doCreateApplyAction(IEditorPart part) {
        Assert.isNotNull((Object)part);
        return new ApplyAction(part);
    }

    protected boolean hasShowInSystemManagementAction() {
        return true;
    }

    protected boolean hasApplyAction() {
        return false;
    }

    protected abstract void doCreateFormContent(Composite var1, CustomFormToolkit var2);

    protected static class ApplyAction
    extends Action
    implements IPropertyListener,
    IDisposable {
        private final IEditorPart part;

        public ApplyAction(IEditorPart part) {
            super(Messages.AbstractCustomFormToolkitEditorPage_ApplyAction_label, 1);
            Assert.isNotNull((Object)part);
            this.part = part;
            this.setToolTipText(Messages.AbstractCustomFormToolkitEditorPage_ApplyAction_tooltip);
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_SAVE_EDIT"));
            this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_SAVE_EDIT_DISABLED"));
            part.addPropertyListener((IPropertyListener)this);
        }

        public void dispose() {
            if (this.part != null) {
                this.part.dispose();
            }
        }

        public void run() {
            if (this.part != null && this.part.isDirty()) {
                this.part.doSave((IProgressMonitor)new NullProgressMonitor());
            }
        }

        public void propertyChanged(Object source, int propId) {
            if (propId == 257) {
                boolean dirty = this.part != null && this.part.isDirty();
                this.setEnabled(dirty);
            }
        }
    }

    protected static class HelpAction
    extends Action {
        final String helpID;

        public HelpAction(String helpID) {
            super(Messages.AbstractCustomFormToolkitEditorPage_HelpAction_label, 1);
            Assert.isNotNull((Object)helpID);
            this.helpID = helpID;
            this.setToolTipText(Messages.AbstractCustomFormToolkitEditorPage_HelpAction_tooltip);
            this.setImageDescriptor(UIPlugin.getImageDescriptor("HelpAction"));
        }

        public void run() {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PlatformUI.getWorkbench().getHelpSystem().displayHelp(HelpAction.this.helpID);
                }
            });
        }
    }
}

