/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.internal.utils;

import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.tcf.te.ui.internal.utils.QuickFilter;
import org.eclipse.tcf.te.ui.nls.Messages;

public class QuickFilterPopup
extends PopupDialog {
    QuickFilter quickFilter;
    Text filterText;
    String filter;
    TreeViewer treeViewer;

    public QuickFilterPopup(TreeViewer viewer, QuickFilter qFilter) {
        super(viewer.getTree().getShell(), 4, true, true, false, false, false, null, null);
        this.quickFilter = qFilter;
        this.treeViewer = viewer;
        this.filter = this.quickFilter.getFilterText() != null ? this.quickFilter.getFilterText() : Messages.QuickFilterPopup_PromptMessage;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.marginHeight = 2;
        this.filterText = new Text(composite, 4);
        GridData data = new GridData(768);
        data.widthHint = 185;
        this.filterText.setLayoutData((Object)data);
        this.filterText.setText(this.filter);
        this.filterText.setFont(composite.getFont());
        this.filterText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                QuickFilterPopup.this.getAccessibleName(e);
            }
        });
        this.filterText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                QuickFilterPopup.this.filterTextFocusGained(e);
            }
        });
        this.filterText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                QuickFilterPopup.this.filterTextMouseUp(e);
            }
        });
        this.filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                QuickFilterPopup.this.filterTextKeyPressed(e);
            }
        });
        this.filterText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                QuickFilterPopup.this.filterTextKeyTraversed(e);
            }
        });
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                QuickFilterPopup.this.filterTextModifyText(e);
            }
        });
        return composite;
    }

    protected void getAccessibleName(AccessibleEvent e) {
        String filterTextString = this.filterText.getText();
        e.result = filterTextString.length() == 0 ? this.filter : filterTextString;
    }

    protected void filterTextFocusGained(FocusEvent e) {
        if (this.filter.equals(this.filterText.getText().trim())) {
            this.filterText.selectAll();
        }
    }

    protected void filterTextMouseUp(MouseEvent e) {
        if (this.filter.equals(this.filterText.getText().trim())) {
            this.filterText.selectAll();
        }
    }

    protected void filterTextKeyPressed(KeyEvent e) {
        boolean hasItems;
        boolean bl = hasItems = this.treeViewer.getTree().getItemCount() > 0;
        if (hasItems && e.keyCode == 0x1000002) {
            this.treeViewer.getTree().setFocus();
        }
    }

    protected void filterTextKeyTraversed(TraverseEvent e) {
        if (e.detail == 2) {
            this.quickFilter.resetViewer();
        }
        if (e.detail == 4) {
            e.doit = false;
            if (this.treeViewer.getTree().getItemCount() == 0) {
                Display.getCurrent().beep();
            } else {
                boolean textChanged;
                boolean hasFocus = this.treeViewer.getTree().setFocus();
                boolean bl = textChanged = !this.filter.equals(this.filterText.getText().trim());
                if (hasFocus && textChanged && this.filterText.getText().trim().length() > 0) {
                    TreeItem[] items;
                    TreeItem[] treeItemArray = items = this.treeViewer.getTree().getItems();
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem item = treeItemArray[n2];
                        if (this.quickFilter.match(item.getText())) {
                            this.treeViewer.getTree().setSelection(new TreeItem[]{item});
                            ISelection sel = this.treeViewer.getSelection();
                            this.treeViewer.setSelection(sel, true);
                            break;
                        }
                        ++n2;
                    }
                }
            }
        }
    }

    protected void filterTextModifyText(ModifyEvent e) {
        this.quickFilter.setPattern(this.filterText.getText());
        this.quickFilter.adjustPopup(this.getShell());
    }
}

