/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.trees;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tcf.te.ui.trees.ColumnDescriptor;
import org.eclipse.tcf.te.ui.trees.FilterDescriptor;
import org.eclipse.tcf.te.ui.trees.ViewerDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.osgi.framework.Bundle;

public class TreeViewerExtension {
    private static final String EXTENSION_POINT_ID = "org.eclipse.tcf.te.ui.viewers";
    private String viewerId;

    public TreeViewerExtension(String viewerId) {
        this.viewerId = viewerId;
    }

    public ViewerDescriptor parseViewer() {
        IConfigurationElement[] configurations;
        Assert.isNotNull((Object)this.viewerId);
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_POINT_ID);
        IConfigurationElement[] iConfigurationElementArray = configurations = extensionPoint.getConfigurationElements();
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            String id;
            IConfigurationElement configuration = iConfigurationElementArray[n2];
            String name = configuration.getName();
            if ("viewer".equals(name) && this.viewerId.equals(id = configuration.getAttribute("id"))) {
                return this.createViewerDescriptor(configuration);
            }
            ++n2;
        }
        return null;
    }

    private ViewerDescriptor createViewerDescriptor(final IConfigurationElement configuration) {
        final ViewerDescriptor descriptor = new ViewerDescriptor();
        IConfigurationElement[] children = configuration.getChildren("creation");
        if (children != null && children.length > 0) {
            Assert.isTrue((children.length == 1 ? 1 : 0) != 0);
            descriptor.setStyleConfig(children[0]);
        }
        if ((children = configuration.getChildren("dragSupport")) != null && children.length > 0) {
            Assert.isTrue((children.length == 1 ? 1 : 0) != 0);
            descriptor.setDragConfig(children[0]);
        }
        if ((children = configuration.getChildren("dropSupport")) != null && children.length > 0) {
            Assert.isTrue((children.length == 1 ? 1 : 0) != 0);
            descriptor.setDropConfig(children[0]);
        }
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void handleException(Throwable e) {
            }

            public void run() throws Exception {
                ITreeContentProvider contentProvider = (ITreeContentProvider)configuration.createExecutableExtension("contentProvider");
                descriptor.setContentProvider(contentProvider);
            }
        });
        String value = configuration.getAttribute("persistent");
        if (value != null) {
            descriptor.setPersistent(Boolean.valueOf(value));
        }
        if ((value = configuration.getAttribute("autoExpandLevel")) != null) {
            try {
                int level = Integer.parseInt(value);
                descriptor.setAutoExpandLevel(level);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return descriptor;
    }

    public ColumnDescriptor[] parseColumns(Object input) {
        IConfigurationElement[] configurations;
        Assert.isNotNull((Object)this.viewerId);
        List<ColumnDescriptor> columns = Collections.synchronizedList(new ArrayList());
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_POINT_ID);
        IConfigurationElement[] iConfigurationElementArray = configurations = extensionPoint.getConfigurationElements();
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] children;
            String aViewerId;
            IConfigurationElement configuration = iConfigurationElementArray[n2];
            String name = configuration.getName();
            if ("columnContribution".equals(name) && this.viewerId.equals(aViewerId = configuration.getAttribute("viewerId")) && (children = configuration.getChildren("column")) != null && children.length > 0) {
                IConfigurationElement[] iConfigurationElementArray2 = children;
                int n3 = children.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement child = iConfigurationElementArray2[n4];
                    this.createColumnDescriptor(input, columns, child);
                    ++n4;
                }
            }
            ++n2;
        }
        return columns.toArray(new ColumnDescriptor[columns.size()]);
    }

    public FilterDescriptor[] parseFilters(Object input) {
        IConfigurationElement[] configurations;
        Assert.isNotNull((Object)this.viewerId);
        List<FilterDescriptor> descriptors = Collections.synchronizedList(new ArrayList());
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_POINT_ID);
        IConfigurationElement[] iConfigurationElementArray = configurations = extensionPoint.getConfigurationElements();
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] children;
            String aViewerId;
            IConfigurationElement configuration = iConfigurationElementArray[n2];
            String name = configuration.getName();
            if ("filterContribution".equals(name) && this.viewerId.equals(aViewerId = configuration.getAttribute("viewerId")) && (children = configuration.getChildren("filter")) != null && children.length > 0) {
                IConfigurationElement[] iConfigurationElementArray2 = children;
                int n3 = children.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement child = iConfigurationElementArray2[n4];
                    this.createFilterDescriptor(input, descriptors, child);
                    ++n4;
                }
            }
            ++n2;
        }
        return descriptors.toArray(new FilterDescriptor[descriptors.size()]);
    }

    private void createFilterDescriptor(Object input, List<FilterDescriptor> descriptors, final IConfigurationElement configuration) {
        if (this.isElementActivated(input, configuration)) {
            String id = configuration.getAttribute("id");
            Assert.isNotNull((Object)id);
            final FilterDescriptor descriptor = new FilterDescriptor();
            descriptor.setId(id);
            descriptors.add(descriptor);
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void handleException(Throwable e) {
                }

                public void run() throws Exception {
                    TreeViewerExtension.this.initFilter(descriptor, configuration);
                }
            });
        }
    }

    void initFilter(FilterDescriptor descriptor, IConfigurationElement configuration) throws CoreException {
        String attribute = configuration.getAttribute("name");
        Assert.isNotNull((Object)attribute);
        descriptor.setName(attribute);
        attribute = configuration.getAttribute("description");
        if (attribute != null) {
            descriptor.setDescription(attribute);
        }
        if ((attribute = configuration.getAttribute("image")) != null) {
            String symbolicName = configuration.getContributor().getName();
            URL resource = Platform.getBundle((String)symbolicName).getResource(attribute);
            Image image = ImageDescriptor.createFromURL((URL)resource).createImage();
            descriptor.setImage(image);
        }
        if ((attribute = configuration.getAttribute("enabled")) != null) {
            descriptor.setEnabled(Boolean.valueOf(attribute));
        }
        attribute = configuration.getAttribute("class");
        Assert.isNotNull((Object)attribute);
        ViewerFilter filter = (ViewerFilter)configuration.createExecutableExtension("class");
        Assert.isNotNull((Object)filter);
        descriptor.setFilter(filter);
        attribute = configuration.getAttribute("visibleInUI");
        if (attribute != null) {
            descriptor.setVisible(Boolean.valueOf(attribute));
        }
    }

    private void createColumnDescriptor(Object input, final List<ColumnDescriptor> columns, final IConfigurationElement configuration) {
        if (this.isElementActivated(input, configuration)) {
            String id = configuration.getAttribute("id");
            Assert.isNotNull((Object)id);
            final ColumnDescriptor column = new ColumnDescriptor(id);
            columns.add(column);
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void handleException(Throwable e) {
                }

                public void run() throws Exception {
                    TreeViewerExtension.this.initColumn(column, configuration);
                    column.setOrder(columns.size());
                }
            });
        }
    }

    private boolean isElementActivated(Object input, IConfigurationElement configuration) {
        IConfigurationElement[] children = configuration.getChildren("activation");
        if (children == null || children.length == 0) {
            return true;
        }
        if ((children = children[0].getChildren()) == null || children.length == 0) {
            return true;
        }
        final IConfigurationElement config = children[0];
        IEvaluationContext currentState = ((IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class)).getCurrentState();
        final EvaluationContext context = new EvaluationContext(currentState, input);
        context.addVariable("input", input);
        context.setAllowPluginActivation(true);
        final boolean[] result = new boolean[1];
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void handleException(Throwable e) {
            }

            public void run() throws Exception {
                Expression expression = ExpressionConverter.getDefault().perform(config);
                EvaluationResult evaluate = expression.evaluate((IEvaluationContext)context);
                if (evaluate == EvaluationResult.TRUE) {
                    result[0] = true;
                }
            }
        });
        return result[0];
    }

    void initColumn(ColumnDescriptor column, IConfigurationElement configuration) throws CoreException {
        Comparator comparator;
        ILabelProvider labelProvider;
        String name = configuration.getAttribute("name");
        Assert.isNotNull((Object)name);
        column.setName(name);
        column.setDescription(configuration.getAttribute("description"));
        String attribute = configuration.getAttribute("moveable");
        if (attribute != null) {
            column.setMoveable(Boolean.valueOf(attribute));
        }
        if ((attribute = configuration.getAttribute("resizable")) != null) {
            column.setResizable(Boolean.valueOf(attribute));
        }
        if ((attribute = configuration.getAttribute("visible")) != null) {
            column.setVisible(Boolean.valueOf(attribute));
        }
        if ((attribute = configuration.getAttribute("style")) != null) {
            column.setStyle(this.parseAlignment(attribute));
        }
        if ((attribute = configuration.getAttribute("alignment")) != null) {
            column.setAlignment(this.parseAlignment(attribute));
        }
        if ((attribute = configuration.getAttribute("width")) != null) {
            try {
                column.setWidth(Integer.parseInt(attribute));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((attribute = configuration.getAttribute("image")) != null) {
            String symbolicName = configuration.getContributor().getName();
            URL resource = Platform.getBundle((String)symbolicName).getResource(attribute);
            Image image = ImageDescriptor.createFromURL((URL)resource).createImage();
            column.setImage(image);
        }
        if ((attribute = configuration.getAttribute("labelProvider")) != null && (labelProvider = (ILabelProvider)configuration.createExecutableExtension("labelProvider")) != null) {
            column.setLabelProvider(labelProvider);
        }
        if ((attribute = configuration.getAttribute("comparator")) != null && (comparator = (Comparator)configuration.createExecutableExtension("comparator")) != null) {
            column.setComparator(comparator);
        }
    }

    private int parseAlignment(String attribute) {
        if ("SWT.LEFT".equals(attribute)) {
            return 16384;
        }
        if ("SWT.RIGHT".equals(attribute)) {
            return 131072;
        }
        if ("SWT.CENTER".equals(attribute)) {
            return 0x1000000;
        }
        return 0;
    }

    private int parseStyleName(String name) {
        if ("SWT.NONE".equals(name)) {
            return 0;
        }
        if ("SWT.SINGLE".equals(name)) {
            return 4;
        }
        if ("SWT.MULTI".equals(name)) {
            return 2;
        }
        if ("SWT.CHECK".equals(name)) {
            return 32;
        }
        if ("SWT.FULL_SELECTION".equals(name)) {
            return 65536;
        }
        if ("SWT.VIRTUAL".equals(name)) {
            return 0x10000000;
        }
        if ("SWT.NO_SCROLL".equals(name)) {
            return 16;
        }
        return 0;
    }

    private int parseDndOp(String name) {
        if ("DND.DROP_COPY".equals(name)) {
            return 1;
        }
        if ("DND.DROP_MOVE".equals(name)) {
            return 2;
        }
        if ("DND.DROP_LINK".equals(name)) {
            return 4;
        }
        return 0;
    }

    public int parseStyle(IConfigurationElement configuration) {
        IConfigurationElement[] children = configuration.getChildren();
        int style = 0;
        IConfigurationElement[] iConfigurationElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            String name = child.getAttribute("name");
            style |= this.parseStyleName(name);
            ++n2;
        }
        return style;
    }

    public int parseDnd(IConfigurationElement configuration) {
        IConfigurationElement[] children = configuration.getChildren("operations");
        Assert.isTrue((children != null && children.length == 1 ? 1 : 0) != 0);
        children = children[0].getChildren();
        int operations = 0;
        IConfigurationElement[] iConfigurationElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            String name = child.getAttribute("name");
            operations |= this.parseDndOp(name);
            ++n2;
        }
        return operations;
    }

    public Transfer[] parseTransferTypes(IConfigurationElement configuration) {
        ArrayList<Transfer> transferTypes = new ArrayList<Transfer>();
        IConfigurationElement[] children = configuration.getChildren("transferTypes");
        Assert.isTrue((children != null && children.length == 1 ? 1 : 0) != 0);
        IConfigurationElement[] iConfigurationElementArray = children = children[0].getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            String name = child.getAttribute("name");
            Transfer transfer = this.parseTransferType(name);
            if (transfer != null) {
                transferTypes.add(transfer);
            }
            ++n2;
        }
        return transferTypes.toArray(new Transfer[transferTypes.size()]);
    }

    private Transfer parseTransferType(String name) {
        if ("TextTransfer".equals(name)) {
            return TextTransfer.getInstance();
        }
        if ("ImageTransfer".equals(name)) {
            return ImageTransfer.getInstance();
        }
        if ("FileTransfer".equals(name)) {
            return FileTransfer.getInstance();
        }
        if ("LocalSelectionTransfer".equals(name)) {
            return LocalSelectionTransfer.getTransfer();
        }
        return null;
    }

    public DragSourceListener parseDragSourceListener(final TreeViewer viewer, final IConfigurationElement configuration) {
        final AtomicReference reference = new AtomicReference();
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void handleException(Throwable e) {
            }

            public void run() throws Exception {
                reference.set((DragSourceListener)TreeViewerExtension.this.createExecutableExtension(DragSourceListener.class, viewer, configuration));
            }
        });
        return (DragSourceListener)reference.get();
    }

    Object createExecutableExtension(Class<?> aInterface, TreeViewer viewer, IConfigurationElement configuration) throws Exception {
        String classname = configuration.getAttribute("class");
        Assert.isNotNull((Object)classname);
        String contributorId = configuration.getContributor().getName();
        Bundle bundle = Platform.getBundle((String)contributorId);
        Assert.isNotNull((Object)bundle);
        Class clazz = bundle.loadClass(classname);
        Assert.isTrue((boolean)aInterface.isAssignableFrom(clazz));
        try {
            Constructor constructor = clazz.getConstructor(TreeViewer.class);
            return constructor.newInstance(viewer);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Constructor constructor = clazz.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
    }

    public DropTargetListener parseDropTargetListener(final TreeViewer viewer, final IConfigurationElement configuration) {
        final AtomicReference reference = new AtomicReference();
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void handleException(Throwable e) {
            }

            public void run() throws Exception {
                reference.set((DropTargetListener)TreeViewerExtension.this.createExecutableExtension(DropTargetListener.class, viewer, configuration));
            }
        });
        return (DropTargetListener)reference.get();
    }
}

