/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.wizards;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractWizardCommandHandler
extends AbstractHandler {
    private static final int DEFAULT_WIZARD_WIDTH = 400;
    private static final int DEFAULT_WIZARD_HEIGHT = 500;

    protected abstract IWizard createWizard();

    protected WizardDialog createWizardDialog(Shell shell, IWizard wizard) {
        Assert.isNotNull((Object)wizard);
        return new WizardDialog(shell, wizard);
    }

    protected IStructuredSelection getCurrentSelection(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        return selection instanceof IStructuredSelection ? (IStructuredSelection)selection : StructuredSelection.EMPTY;
    }

    protected int getDefaultWidth() {
        return 400;
    }

    protected int getDefaultHeight() {
        return 500;
    }

    protected abstract String getHelpId();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        if (window != null) {
            IWizard wizard = this.createWizard();
            Assert.isNotNull((Object)wizard);
            if (wizard instanceof IWorkbenchWizard) {
                ((IWorkbenchWizard)wizard).init(window.getWorkbench(), this.getCurrentSelection(event));
            }
            WizardDialog dialog = this.createWizardDialog(window.getShell(), wizard);
            dialog.create();
            dialog.getShell().setSize(Math.max(this.getDefaultWidth(), dialog.getShell().getSize().x), this.getDefaultHeight());
            if (this.getHelpId() != null) {
                window.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), this.getHelpId());
            }
            dialog.open();
        }
        return null;
    }
}

